/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core;

import com.mysql.clusterj.Session;
import com.mysql.clusterj.core.SessionImpl;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class SessionCache {
    private Map<String, Queue<Session>> cachedSessions = new IdentityHashMap<String, Queue<Session>>();
    private int totalCachedSessions;
    private final int MAX_CACHED_SESSIONS;
    private SessionImpl firstLRUList;
    private SessionImpl lastLRUList;

    public SessionCache(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("com.mysql.clusterj.max.cached.sessions can not be less than 0");
        }
        this.MAX_CACHED_SESSIONS = n;
        this.totalCachedSessions = 0;
        this.firstLRUList = null;
        this.lastLRUList = null;
    }

    public synchronized void dropSessionCache() {
        if (this.MAX_CACHED_SESSIONS == 0) {
            return;
        }
        while (this.cachedSessions.keySet().size() > 0) {
            Session session;
            String string = (String)this.cachedSessions.keySet().toArray()[0];
            while ((session = this.getCachedSession(string)) != null) {
                SessionImpl sessionImpl = (SessionImpl)session;
                sessionImpl.setCached(false);
                session.close();
            }
        }
    }

    public synchronized Session getCachedSession(String string) {
        if (this.MAX_CACHED_SESSIONS == 0 || this.totalCachedSessions == 0) {
            return null;
        }
        Queue<Session> queue = this.cachedSessions.get(string);
        if (queue == null) {
            return null;
        }
        Session session = queue.poll();
        if (session == null || queue.size() == 0) {
            this.cachedSessions.remove(string);
        }
        if (session == null) {
            return null;
        }
        SessionImpl sessionImpl = (SessionImpl)session;
        sessionImpl.setCached(false);
        this.removeFromLRUList(sessionImpl);
        if (this.totalCachedSessions == 0) {
            this.cachedSessions.remove(string);
        }
        return session;
    }

    public synchronized void storeCachedSession(Session session, String string) {
        if (session == null || string == null || string == "") {
            throw new IllegalArgumentException("Bad session object or database name");
        }
        if (this.MAX_CACHED_SESSIONS == 0) {
            return;
        }
        SessionImpl sessionImpl = (SessionImpl)session;
        ++this.totalCachedSessions;
        sessionImpl.setCached(true);
        Queue<Session> queue = this.cachedSessions.get(string);
        if (queue == null) {
            queue = new LinkedList<Session>();
            this.cachedSessions.put(string, queue);
        }
        queue.add(session);
        this.addFirstToLRUList(sessionImpl);
        this.validateCacheSize();
    }

    private synchronized void validateCacheSize() {
        if (this.totalCachedSessions > this.MAX_CACHED_SESSIONS) {
            SessionImpl sessionImpl = this.removeLastFromLRUList();
            sessionImpl.setCached(false);
            sessionImpl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeCachedSessions(String string) {
        if (this.MAX_CACHED_SESSIONS == 0) {
            return;
        }
        SessionCache sessionCache = this;
        synchronized (sessionCache) {
            Queue<Session> queue = this.cachedSessions.get(string);
            if (queue != null) {
                int n = queue.size();
                while (!queue.isEmpty()) {
                    Session session = queue.poll();
                    session.close();
                }
                this.cachedSessions.remove(string);
                this.totalCachedSessions -= n;
            }
        }
    }

    private synchronized void addFirstToLRUList(SessionImpl sessionImpl) {
        sessionImpl.setNextLruList(this.firstLRUList);
        sessionImpl.setPrevLruList(null);
        if (this.firstLRUList == null) {
            this.lastLRUList = sessionImpl;
        } else {
            this.firstLRUList.setPrevLruList(sessionImpl);
        }
        this.firstLRUList = sessionImpl;
    }

    private synchronized void removeFromLRUList(SessionImpl sessionImpl) {
        SessionImpl sessionImpl2 = sessionImpl.getNextLruList();
        SessionImpl sessionImpl3 = sessionImpl.getPrevLruList();
        if (sessionImpl3 == null) {
            this.firstLRUList = sessionImpl2;
        } else {
            sessionImpl3.setNextLruList(sessionImpl2);
        }
        if (sessionImpl2 == null) {
            this.lastLRUList = sessionImpl3;
        } else {
            sessionImpl2.setPrevLruList(sessionImpl3);
        }
        --this.totalCachedSessions;
    }

    private synchronized SessionImpl removeLastFromLRUList() {
        assert (this.lastLRUList != null);
        return (SessionImpl)this.getCachedSession(this.lastLRUList.getDatabaseName());
    }

    public synchronized int size() {
        return this.totalCachedSessions;
    }

    public synchronized int size(String string) {
        Queue<Session> queue = this.cachedSessions.get(string);
        if (queue == null) {
            return 0;
        }
        return queue.size();
    }
}

