/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ColumnImpl;
import com.mysql.clusterj.tie.PartitionKeyImpl;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class TableImpl
implements Table {
    static final I18NHelper local = I18NHelper.getInstance(TableImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(TableImpl.class);
    protected NdbDictionary.TableConst ndbTable;
    protected String[] projectedColumnNames;
    protected String key;
    private String tableName;
    private String[] columnNames;
    private String[] primaryKeyColumnNames;
    private String[] partitionKeyColumnNames;
    private Map<String, ColumnImpl> columns = new HashMap<String, ColumnImpl>();
    private String[] indexNames;
    private int[] lengths;
    private int[] offsets;
    private int bufferSize;
    private int maximumColumnId;
    private int maximumColumnLength = 0;
    private Column autoIncrementColumn = null;

    public TableImpl(NdbDictionary.TableConst tableConst, String[] stringArray) {
        this.ndbTable = tableConst;
        this.tableName = tableConst.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = tableConst.getNoOfColumns();
        ColumnImpl[] columnImplArray = new ColumnImpl[n];
        this.columnNames = new String[n];
        for (int i = 0; i < n; ++i) {
            NdbDictionary.ColumnConst columnConst = tableConst.getColumn(i);
            if (columnConst.getPartitionKey()) {
                arrayList.add(columnConst.getName());
            }
            if (columnConst.getPrimaryKey()) {
                arrayList2.add(columnConst.getName());
            }
            String string = columnConst.getName();
            ColumnImpl columnImpl = new ColumnImpl(this.tableName, columnConst);
            if (columnConst.getAutoIncrement()) {
                this.autoIncrementColumn = columnImpl;
            }
            this.columns.put(string, columnImpl);
            columnImplArray[i] = columnImpl;
            this.columnNames[i] = string;
            int n2 = columnConst.getColumnNo();
            if (n2 <= this.maximumColumnId) continue;
            this.maximumColumnId = n2;
        }
        this.projectedColumnNames = this.columnNames;
        this.key = this.tableName;
        this.primaryKeyColumnNames = arrayList2.toArray(new String[arrayList2.size()]);
        this.partitionKeyColumnNames = arrayList.toArray(new String[arrayList.size()]);
        this.indexNames = stringArray;
    }

    @Override
    public Column getAutoIncrementColumn() {
        return this.autoIncrementColumn;
    }

    @Override
    public Column getColumn(String string) {
        return this.columns.get(string);
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String[] getPrimaryKeyColumnNames() {
        return this.primaryKeyColumnNames;
    }

    @Override
    public String[] getPartitionKeyColumnNames() {
        return this.partitionKeyColumnNames;
    }

    @Override
    public PartitionKey createPartitionKey() {
        PartitionKeyImpl partitionKeyImpl = new PartitionKeyImpl();
        partitionKeyImpl.setTable(this.tableName);
        return partitionKeyImpl;
    }

    @Override
    public String[] getIndexNames() {
        return this.indexNames;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String[] getProjectedColumnNames() {
        return this.projectedColumnNames;
    }

    @Override
    public void setProjectedColumnNames(String[] stringArray) {
        this.projectedColumnNames = stringArray;
        StringBuffer stringBuffer = new StringBuffer(this.tableName);
        int n = 120;
        for (int i = 0; i < this.columnNames.length; ++i) {
            n = 48;
            for (int j = 0; j < this.projectedColumnNames.length; ++j) {
                if (!this.columnNames[i].equals(this.projectedColumnNames[j])) continue;
                n = 49;
                break;
            }
            stringBuffer.append((char)n);
        }
        this.key = stringBuffer.toString();
    }

    public int getMaximumColumnId() {
        return this.maximumColumnId;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public int getMaximumColumnLength() {
        return this.maximumColumnLength;
    }
}

