/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.dtocache;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.core.util.I18NHelper;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DTOCache {
    protected static final I18NHelper local = I18NHelper.getInstance(DTOCache.class);
    private final Map<Class, CacheEntry> cacheEntryMap = new HashMap<Class, CacheEntry>();
    private final Map<Object, CacheObject> inCacheMap = new IdentityHashMap<Object, CacheObject>();
    private final Map<Object, CacheObject> inUseMap = new IdentityHashMap<Object, CacheObject>();
    CacheEntry unusedCacheObjects;
    CacheObject theFirst;
    CacheObject theLast;
    Session session;
    int theCacheSize;
    int theCurrentCacheSize;

    public DTOCache(Session session, int n) {
        this.session = session;
        this.theFirst = null;
        this.theLast = null;
        this.theCacheSize = n;
        this.theCurrentCacheSize = n;
        this.unusedCacheObjects = new CacheEntry();
        for (int i = 0; i < n; ++i) {
            CacheObject cacheObject = new CacheObject();
            this.unusedCacheObjects.add(cacheObject);
        }
    }

    private void removeGlobal(CacheObject cacheObject) {
        if (this.theFirst == cacheObject) {
            if (this.theLast == cacheObject) {
                this.theFirst = null;
                this.theLast = null;
            } else {
                this.theFirst = cacheObject.next_global;
                this.theFirst.prev_global = null;
            }
        } else if (this.theLast == cacheObject) {
            this.theLast = this.theLast.prev_global;
            this.theLast.next_global = null;
        } else {
            cacheObject.prev_global.next_global = cacheObject.next_global;
            cacheObject.next_global.prev_global = cacheObject.prev_global;
        }
        cacheObject.prev_global = null;
        cacheObject.next_global = null;
    }

    private CacheObject removeLastGlobal() {
        CacheObject cacheObject = this.theLast;
        if (cacheObject == null) {
            return null;
        }
        this.removeGlobal(cacheObject);
        return cacheObject;
    }

    private void insertGlobal(CacheObject cacheObject) {
        cacheObject.next_global = this.theFirst;
        cacheObject.prev_global = null;
        if (this.theFirst == null) {
            this.theLast = cacheObject;
        } else {
            this.theFirst.prev_global = cacheObject;
        }
        this.theFirst = cacheObject;
    }

    public <T> void remove(T t) {
        if (this.theCacheSize == 0) {
            return;
        }
        CacheObject cacheObject = this.inUseMap.remove(t);
        if (cacheObject == null) {
            cacheObject = this.inCacheMap.get(t);
            if (cacheObject != null) {
                throw new ClusterJUserException(local.message("ERR_Cannot_Access_Object_After_Release"));
            }
            return;
        }
        cacheObject.elem = null;
        if (this.theCurrentCacheSize > this.theCacheSize) {
            --this.theCurrentCacheSize;
            return;
        }
        cacheObject.valid_object = true;
        cacheObject.type = Object.class;
        this.unusedCacheObjects.add(cacheObject);
    }

    public <T> void insert(T t, Class<?> clazz) {
        if (this.theCacheSize == 0) {
            return;
        }
        if (t == null) {
            return;
        }
        CacheObject cacheObject = this.unusedCacheObjects.get_and_remove();
        if (cacheObject == null) {
            cacheObject = this.removeLastGlobal();
            if (cacheObject == null) {
                cacheObject = new CacheObject();
                ++this.theCurrentCacheSize;
            } else {
                cacheObject = this.inCacheMap.remove(cacheObject.elem);
                CacheEntry cacheEntry = this.cacheEntryMap.get(cacheObject.type);
                cacheEntry.remove(cacheObject);
                this.session.release(cacheObject.elem);
                cacheObject.elem = null;
            }
        }
        cacheObject.elem = t;
        cacheObject.type = clazz;
        cacheObject.valid_object = true;
        this.inUseMap.put(t, cacheObject);
    }

    public <T> void put(T t, Class<?> clazz) {
        CacheObject cacheObject = this.inUseMap.remove(t);
        if (cacheObject == null) {
            cacheObject = this.inCacheMap.get(t);
            if (cacheObject != null) {
                throw new ClusterJUserException(local.message("ERR_Cannot_Access_Object_After_Release"));
            }
            this.session.release(t);
            return;
        }
        if (!cacheObject.valid_object) {
            this.session.release(t);
            return;
        }
        CacheEntry cacheEntry = this.cacheEntryMap.get(clazz);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.cacheEntryMap.put(clazz, cacheEntry);
        }
        if (this.theCurrentCacheSize > this.theCacheSize) {
            --this.theCurrentCacheSize;
            CacheObject cacheObject2 = this.removeLastGlobal();
            if (cacheObject2 == null) {
                this.session.release(t);
                return;
            }
            cacheObject2 = this.inCacheMap.remove(cacheObject2.elem);
            CacheEntry cacheEntry2 = this.cacheEntryMap.get(cacheObject2.type);
            cacheEntry2.remove(cacheObject2);
            this.session.release(cacheObject2.elem);
        }
        cacheObject.elem = t;
        cacheObject.type = clazz;
        this.insertGlobal(cacheObject);
        cacheEntry.add(cacheObject);
        this.inCacheMap.put(t, cacheObject);
    }

    public <T> T get(Class<T> clazz) {
        if (this.theCacheSize == 0) {
            return null;
        }
        CacheEntry cacheEntry = this.cacheEntryMap.get(clazz);
        if (cacheEntry == null) {
            return null;
        }
        CacheObject cacheObject = cacheEntry.get_and_remove();
        if (cacheObject == null) {
            return null;
        }
        Object object = cacheObject.elem;
        cacheObject = this.inCacheMap.remove(object);
        this.removeGlobal(cacheObject);
        this.inUseMap.put(object, cacheObject);
        cacheObject.valid_object = true;
        return (T)object;
    }

    private void removeAll(CacheEntry cacheEntry) {
        CacheObject cacheObject;
        while ((cacheObject = cacheEntry.get_and_remove()) != null) {
            cacheObject = this.inCacheMap.remove(cacheObject.elem);
            this.removeGlobal(cacheObject);
            this.session.release(cacheObject.elem);
            cacheObject.elem = null;
            cacheObject.valid_object = true;
            this.unusedCacheObjects.add(cacheObject);
        }
    }

    private void dropInUseMap() {
        Set<Map.Entry<Object, CacheObject>> set = this.inUseMap.entrySet();
        for (Map.Entry<Object, CacheObject> entry : set) {
            CacheObject cacheObject = entry.getValue();
            cacheObject.valid_object = false;
        }
    }

    public <T> void drop(Class<?> clazz) {
        CacheEntry cacheEntry = this.cacheEntryMap.get(clazz);
        if (cacheEntry != null) {
            this.removeAll(cacheEntry);
            this.cacheEntryMap.remove(clazz);
        }
        this.dropInUseMap();
    }

    public void drop() {
        Set<Map.Entry<Class, CacheEntry>> set = this.cacheEntryMap.entrySet();
        Iterator<Map.Entry<Class, CacheEntry>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class, CacheEntry> entry = iterator.next();
            CacheEntry cacheEntry = entry.getValue();
            this.removeAll(cacheEntry);
            iterator.remove();
        }
        this.dropInUseMap();
    }

    private class CacheEntry {
        CacheObject theFirst = null;
        CacheObject theLast = null;

        public CacheObject get_and_remove() {
            CacheObject cacheObject = this.theFirst;
            if (cacheObject != null) {
                this.remove(cacheObject);
            }
            return cacheObject;
        }

        public void add(CacheObject cacheObject) {
            cacheObject.next_class = this.theFirst;
            cacheObject.prev_class = null;
            if (this.theFirst == null) {
                this.theLast = cacheObject;
            } else {
                this.theFirst.prev_class = cacheObject;
            }
            this.theFirst = cacheObject;
        }

        public void remove(CacheObject cacheObject) {
            if (this.theFirst == cacheObject) {
                if (this.theLast == cacheObject) {
                    this.theFirst = null;
                    this.theLast = null;
                } else {
                    this.theFirst = cacheObject.next_class;
                    this.theFirst.prev_class = null;
                }
            } else if (this.theLast == cacheObject) {
                this.theLast = this.theLast.prev_class;
                this.theLast.next_class = null;
            } else {
                cacheObject.prev_class.next_class = cacheObject.next_class;
                cacheObject.next_class.prev_class = cacheObject.prev_class;
            }
            cacheObject.prev_class = null;
            cacheObject.next_class = null;
        }
    }

    private class CacheObject {
        CacheObject next_global = null;
        CacheObject prev_global = null;
        CacheObject next_class = null;
        CacheObject prev_class = null;
        Object elem = null;
        Class<?> type = Object.class;
        boolean valid_object = true;
    }
}

