/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.query.BetweenPredicateImpl;
import com.mysql.clusterj.core.query.ComparativePredicateImpl;
import com.mysql.clusterj.core.query.EqualPredicateImpl;
import com.mysql.clusterj.core.query.InPredicateImpl;
import com.mysql.clusterj.core.query.NotPredicateImpl;
import com.mysql.clusterj.core.query.OrPredicateImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.query.Predicate;
import java.util.ArrayList;
import java.util.List;

public class AndPredicateImpl
extends PredicateImpl {
    List<PredicateImpl> predicates = new ArrayList<PredicateImpl>();

    public AndPredicateImpl(QueryDomainTypeImpl<?> queryDomainTypeImpl, PredicateImpl predicateImpl, PredicateImpl predicateImpl2) {
        super(queryDomainTypeImpl);
        this.predicates.add(predicateImpl);
        this.predicates.add(predicateImpl2);
    }

    @Override
    public Predicate and(Predicate predicate) {
        if (predicate instanceof ComparativePredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof AndPredicateImpl) {
            this.predicates.addAll(((AndPredicateImpl)predicate).predicates);
            return this;
        }
        if (predicate instanceof OrPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof InPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof NotPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof BetweenPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public Predicate or(Predicate predicate) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public Predicate not() {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public void markParameters() {
        for (PredicateImpl predicateImpl : this.predicates) {
            predicateImpl.markParameters();
        }
    }

    @Override
    public void unmarkParameters() {
        for (PredicateImpl predicateImpl : this.predicates) {
            predicateImpl.unmarkParameters();
        }
    }

    @Override
    public void filterCmpValue(QueryExecutionContext queryExecutionContext, ScanOperation scanOperation) {
        try {
            ScanFilter scanFilter = scanOperation.getScanFilter(queryExecutionContext);
            scanFilter.begin(ScanFilter.Group.GROUP_AND);
            for (PredicateImpl predicateImpl : this.predicates) {
                predicateImpl.filterCmpValue(queryExecutionContext, scanOperation, scanFilter);
            }
            scanFilter.end();
        }
        catch (Exception exception) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), exception);
        }
    }

    @Override
    public void operationEqual(QueryExecutionContext queryExecutionContext, Operation operation) {
        for (PredicateImpl predicateImpl : this.predicates) {
            if (!(predicateImpl instanceof EqualPredicateImpl)) {
                throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
            }
            predicateImpl.operationEqual(queryExecutionContext, operation);
        }
    }

    @Override
    protected int getNumberOfConditionsInPredicate() {
        return this.predicates.size();
    }

    @Override
    protected PredicateImpl[] getTopLevelPredicates() {
        return this.predicates.toArray(new PredicateImpl[this.predicates.size()]);
    }
}

