/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.NdbRecordScanOperationImpl;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class NdbRecordIndexScanOperationImpl
extends NdbRecordScanOperationImpl
implements IndexScanOperation {
    private NdbIndexScanOperation ndbIndexScanOperation;
    private int indexBoundRange = 0;
    private ByteBuffer indexBoundLowBuffer = null;
    private int indexBoundLowCount = 0;
    private boolean indexBoundLowStrict = false;
    private ByteBuffer indexBoundHighBuffer = null;
    private int indexBoundHighCount = 0;
    private boolean indexBoundHighStrict = false;
    private boolean equalScan = true;
    List<NdbIndexScanOperation.IndexBound> ndbIndexBoundList = null;
    NdbIndexScanOperation.IndexBound ndbIndexBound = null;
    List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private Index index;

    @Override
    public String toString() {
        return " NdbRecordIndexScanOperationImpl with index: " + this.index.getName() + " " + super.toString();
    }

    public NdbRecordIndexScanOperationImpl(ClusterTransactionImpl clusterTransactionImpl, Index index, Table table, int n) {
        this(clusterTransactionImpl, index, table, false, n);
    }

    public NdbRecordIndexScanOperationImpl(ClusterTransactionImpl clusterTransactionImpl, Index index, Table table, boolean bl, int n) {
        super(clusterTransactionImpl, table, n);
        this.index = index;
        this.multiRange = bl;
        if (this.multiRange) {
            this.ndbIndexBoundList = new ArrayList<NdbIndexScanOperation.IndexBound>();
        }
        this.ndbRecordKeys = clusterTransactionImpl.getCachedNdbRecordImpl(clusterTransactionImpl.db, index, table);
        this.keyBufferSize = this.ndbRecordKeys.bufferSize;
        this.indexBoundLowBuffer = this.ndbRecordKeys.newBuffer();
        this.buffers.add(this.indexBoundLowBuffer);
        this.indexBoundHighBuffer = this.ndbRecordKeys.newBuffer();
        this.buffers.add(this.indexBoundHighBuffer);
    }

    @Override
    public void endDefinition() {
        this.getScanOptions();
        if (logger.isDetailEnabled()) {
            logger.detail("scan index '" + this.index.getName() + "' with options " + this.dumpScanOptions(this.scanOptions.optionsPresent(), this.scanOptions.scan_flags()));
        }
        this.ndbIndexScanOperation = this.clusterTransaction.scanIndex(this.ndbRecordKeys.getNdbRecord(), this.ndbRecordValues.getNdbRecord(), this.mask, this.scanOptions);
        this.ndbOperation = this.ndbIndexScanOperation;
        if (this.ndbIndexBoundList != null) {
            if (logger.isDetailEnabled()) {
                logger.detail("list size " + this.ndbIndexBoundList.size());
            }
            for (NdbIndexScanOperation.IndexBound indexBound : this.ndbIndexBoundList) {
                int n = this.ndbIndexScanOperation.setBound(this.ndbRecordKeys.getNdbRecord(), indexBound);
                NdbRecordIndexScanOperationImpl.handleError(n, (NdbOperationConst)this.ndbIndexScanOperation);
            }
        } else {
            this.ndbIndexBound = this.getNdbIndexBound();
            if (this.ndbIndexBound != null) {
                int n = this.ndbIndexScanOperation.setBound(this.ndbRecordKeys.getNdbRecord(), this.ndbIndexBound);
                NdbRecordIndexScanOperationImpl.handleError(n, (NdbOperationConst)this.ndbIndexScanOperation);
            }
        }
        this.activateBlobs();
        this.clusterTransaction.postExecuteCallback(new Runnable(){

            @Override
            public void run() {
                NdbRecordIndexScanOperationImpl.this.freeResourcesAfterExecute();
            }
        });
    }

    @Override
    public void setBoundBigInteger(Column column, IndexScanOperation.BoundType boundType, BigInteger bigInteger) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + bigInteger);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setBigInteger(this.indexBoundLowBuffer, column, bigInteger);
            this.ndbRecordKeys.setBigInteger(this.indexBoundHighBuffer, column, bigInteger);
        } else {
            this.ndbRecordKeys.setBigInteger(byteBuffer, column, bigInteger);
        }
    }

    @Override
    public void setBoundByte(Column column, IndexScanOperation.BoundType boundType, byte by) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + by);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setByte(this.indexBoundLowBuffer, column, by);
            this.ndbRecordKeys.setByte(this.indexBoundHighBuffer, column, by);
        } else {
            this.ndbRecordKeys.setByte(byteBuffer, column, by);
        }
    }

    @Override
    public void setBoundBytes(Column column, IndexScanOperation.BoundType boundType, byte[] byArray) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + byArray);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setBytes(this.indexBoundLowBuffer, column, byArray);
            this.ndbRecordKeys.setBytes(this.indexBoundHighBuffer, column, byArray);
        } else {
            this.ndbRecordKeys.setBytes(byteBuffer, column, byArray);
        }
    }

    @Override
    public void setBoundDecimal(Column column, IndexScanOperation.BoundType boundType, BigDecimal bigDecimal) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + bigDecimal);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setDecimal(this.indexBoundLowBuffer, column, bigDecimal);
            this.ndbRecordKeys.setDecimal(this.indexBoundHighBuffer, column, bigDecimal);
        } else {
            this.ndbRecordKeys.setDecimal(byteBuffer, column, bigDecimal);
        }
    }

    @Override
    public void setBoundDouble(Column column, IndexScanOperation.BoundType boundType, Double d) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + d);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setDouble(this.indexBoundLowBuffer, column, d);
            this.ndbRecordKeys.setDouble(this.indexBoundHighBuffer, column, d);
        } else {
            this.ndbRecordKeys.setDouble(byteBuffer, column, d);
        }
    }

    @Override
    public void setBoundFloat(Column column, IndexScanOperation.BoundType boundType, Float f) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + f);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setFloat(this.indexBoundLowBuffer, column, f.floatValue());
            this.ndbRecordKeys.setFloat(this.indexBoundHighBuffer, column, f.floatValue());
        } else {
            this.ndbRecordKeys.setFloat(byteBuffer, column, f.floatValue());
        }
    }

    @Override
    public void setBoundShort(Column column, IndexScanOperation.BoundType boundType, short s) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + s);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setShort(this.indexBoundLowBuffer, column, s);
            this.ndbRecordKeys.setShort(this.indexBoundHighBuffer, column, s);
        } else {
            this.ndbRecordKeys.setShort(byteBuffer, column, s);
        }
    }

    @Override
    public void setBoundInt(Column column, IndexScanOperation.BoundType boundType, Integer n) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + n);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setInt(this.indexBoundLowBuffer, column, n);
            this.ndbRecordKeys.setInt(this.indexBoundHighBuffer, column, n);
        } else {
            this.ndbRecordKeys.setInt(byteBuffer, column, n);
        }
    }

    @Override
    public void setBoundLong(Column column, IndexScanOperation.BoundType boundType, long l) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + l);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setLong(this.indexBoundLowBuffer, column, l);
            this.ndbRecordKeys.setLong(this.indexBoundHighBuffer, column, l);
        } else {
            this.ndbRecordKeys.setLong(byteBuffer, column, l);
        }
    }

    @Override
    public void setBoundString(Column column, IndexScanOperation.BoundType boundType, String string) {
        ByteBuffer byteBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(column.getName() + " " + (Object)((Object)boundType) + " " + string);
        }
        if ((byteBuffer = this.assignBoundBuffer(boundType)) == null) {
            this.ndbRecordKeys.setString(this.indexBoundLowBuffer, this.bufferManager, column, string);
            this.ndbRecordKeys.setString(this.indexBoundHighBuffer, this.bufferManager, column, string);
        } else {
            this.ndbRecordKeys.setString(byteBuffer, this.bufferManager, column, string);
        }
    }

    @Override
    public void endBound(int n) {
        if (logger.isDetailEnabled()) {
            logger.detail("range: " + n);
        }
        this.indexBoundRange = n;
        this.ndbIndexBoundList.add(this.getNdbIndexBound());
    }

    private ByteBuffer assignBoundBuffer(IndexScanOperation.BoundType boundType) {
        switch (boundType) {
            case BoundEQ: {
                ++this.indexBoundHighCount;
                ++this.indexBoundLowCount;
                return null;
            }
            case BoundGE: {
                this.equalScan = false;
                ++this.indexBoundHighCount;
                return this.indexBoundHighBuffer;
            }
            case BoundGT: {
                this.equalScan = false;
                this.indexBoundHighStrict = true;
                ++this.indexBoundHighCount;
                return this.indexBoundHighBuffer;
            }
            case BoundLE: {
                this.equalScan = false;
                ++this.indexBoundLowCount;
                return this.indexBoundLowBuffer;
            }
            case BoundLT: {
                this.equalScan = false;
                this.indexBoundLowStrict = true;
                ++this.indexBoundLowCount;
                return this.indexBoundLowBuffer;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    private NdbIndexScanOperation.IndexBound getNdbIndexBound() {
        ByteBuffer byteBuffer = null;
        if (this.indexBoundLowCount + this.indexBoundHighCount > 0) {
            if (this.indexBoundLowCount == 0) {
                this.indexBoundLowBuffer = null;
            } else {
                this.indexBoundLowBuffer.limit(this.keyBufferSize);
                this.indexBoundLowBuffer.position(0);
            }
            if (this.indexBoundHighCount == 0) {
                this.indexBoundHighBuffer = null;
            } else {
                this.indexBoundHighBuffer.limit(this.keyBufferSize);
                this.indexBoundHighBuffer.position(0);
            }
            if (this.equalScan) {
                byteBuffer = this.indexBoundLowBuffer;
                this.indexBoundLowBuffer = this.indexBoundHighBuffer;
            }
            NdbIndexScanOperation.IndexBound indexBound = this.db.createIndexBound();
            indexBound.low_key(this.indexBoundLowBuffer);
            indexBound.high_key(this.indexBoundHighBuffer);
            indexBound.low_key_count(this.indexBoundLowCount);
            indexBound.high_key_count(this.indexBoundHighCount);
            indexBound.low_inclusive(!this.indexBoundLowStrict);
            indexBound.high_inclusive(!this.indexBoundHighStrict);
            indexBound.range_no(this.indexBoundRange);
            if (logger.isDetailEnabled()) {
                logger.detail(" indexBoundLowCount: " + this.indexBoundLowCount + " indexBoundHighCount: " + this.indexBoundHighCount + " indexBoundLowStrict: " + this.indexBoundLowStrict + " indexBoundHighStrict: " + this.indexBoundHighStrict + " range: " + this.indexBoundRange);
            }
            if (byteBuffer != null) {
                this.indexBoundLowBuffer = byteBuffer;
                this.ndbRecordKeys.initializeBuffer(byteBuffer);
            } else {
                this.indexBoundLowBuffer = this.ndbRecordKeys.newBuffer();
                this.buffers.add(this.indexBoundLowBuffer);
            }
            this.indexBoundHighBuffer = this.ndbRecordKeys.newBuffer();
            this.buffers.add(this.indexBoundHighBuffer);
            this.indexBoundLowCount = 0;
            this.indexBoundHighCount = 0;
            this.indexBoundLowStrict = false;
            this.indexBoundHighStrict = false;
            this.indexBoundRange = 0;
            this.equalScan = true;
            return indexBound;
        }
        return null;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void freeResourcesAfterExecute() {
        if (this.ndbIndexBound != null) {
            this.db.delete(this.ndbIndexBound);
            this.ndbIndexBound = null;
        }
        if (this.ndbIndexBoundList != null) {
            for (NdbIndexScanOperation.IndexBound object : this.ndbIndexBoundList) {
                this.db.delete(object);
            }
            this.ndbIndexBoundList = null;
        }
        if (this.buffers != null) {
            for (ByteBuffer byteBuffer : this.buffers) {
                this.ndbRecordKeys.returnBuffer(byteBuffer);
            }
        }
        super.freeResourcesAfterExecute();
    }
}

