/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.InPredicateImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractDomainFieldHandlerImpl
implements DomainFieldHandler,
ColumnMetadata {
    public static final byte[] emptyByteArray = new byte[0];
    static final I18NHelper local = I18NHelper.getInstance(AbstractDomainFieldHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(AbstractDomainFieldHandlerImpl.class);
    protected DomainTypeHandler<?> domainTypeHandler;
    protected boolean nullable;
    protected String columnDefaultValue = null;
    protected String columnName = "";
    protected Column storeColumn;
    protected String charsetName = null;
    protected int precision;
    protected int scale;
    protected int maximumLength;
    protected boolean partitionKey;
    protected ColumnType storeColumnType = null;
    protected String[] columnNames;
    protected Object defaultValue;
    protected StringBuffer errorMessages;
    protected int fieldNumber;
    protected Set<String> indexNames = new HashSet<String>();
    protected int[][] indices = new int[0][0];
    protected String name;
    protected Class<?> type;
    protected boolean orderedIndex = false;
    protected boolean uniqueIndex = false;
    protected boolean primaryKey = false;
    public AbstractDomainFieldHandlerImpl[] compositeDomainFieldHandlers = null;
    protected ObjectOperationHandler objectOperationHandlerDelegate;
    protected static ObjectOperationHandler objectOperationHandlerByte = new ObjectOperationHandlerByte(){

        @Override
        public String handler() {
            return "primitive byte";
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyByte = new ObjectOperationHandlerByte(){

        @Override
        public String handler() {
            return "primitive key byte";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            operation.equalByte(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getByte(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addByteKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getByte(abstractDomainFieldHandlerImpl.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectByte = new ObjectOperationHandlerObjectByte(){

        @Override
        public String handler() {
            return "object Byte";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setByte(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectByte(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerBoolean = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setBoolean(abstractDomainFieldHandlerImpl.fieldNumber, false);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Boolean.FALSE : Boolean.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setBoolean(abstractDomainFieldHandlerImpl.storeColumn, (Boolean)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            operation.setBoolean(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getBoolean(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public String handler() {
            return "setBoolean";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setBoolean(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getBoolean(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            throw new ClusterJFatalInternalException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpBoolean(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (Boolean)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalBoolean(abstractDomainFieldHandlerImpl.storeColumn, (Boolean)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getBoolean(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getBoolean(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setBoolean(abstractDomainFieldHandlerImpl.fieldNumber, (Boolean)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectBoolean = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setBoolean(abstractDomainFieldHandlerImpl.fieldNumber, false);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Boolean.FALSE : Boolean.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setBoolean(abstractDomainFieldHandlerImpl.storeColumn, (Boolean)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setBoolean(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getBoolean(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "setObjectBoolean";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setObjectBoolean(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getObjectBoolean(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            throw new ClusterJFatalInternalException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpBoolean(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (Boolean)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalBoolean(abstractDomainFieldHandlerImpl.storeColumn, (Boolean)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getBoolean(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getObjectBoolean(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setObjectBoolean(abstractDomainFieldHandlerImpl.fieldNumber, (Boolean)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerBytes = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            if (string == null) {
                return new byte[0];
            }
            throw new UnsupportedOperationException(local.message("ERR_Convert_String_To_Value", (Object)string, (Object)"byte[]"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (object == null) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setBytes(abstractDomainFieldHandlerImpl.storeColumn, (byte[])object);
            }
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            byte[] byArray = valueHandler.getBytes(abstractDomainFieldHandlerImpl.fieldNumber);
            if (byArray == null) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setBytes(abstractDomainFieldHandlerImpl.storeColumn, byArray);
            }
        }

        @Override
        public String handler() {
            return "setBytes";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setBytes(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getBytes(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundBytes(abstractDomainFieldHandlerImpl.storeColumn, boundType, (byte[])object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpBytes(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (byte[])object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setBytes.setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalBytes(abstractDomainFieldHandlerImpl.storeColumn, (byte[])object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getBytes(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getBytes(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setBytes(abstractDomainFieldHandlerImpl.fieldNumber, (byte[])object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyBytes = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            if (string == null) {
                return emptyByteArray;
            }
            throw new UnsupportedOperationException(local.message("ERR_Convert_String_To_Value", (Object)string, (Object)"byte[]"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalBytes(abstractDomainFieldHandlerImpl.storeColumn, (byte[])object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            byte[] byArray = valueHandler.getBytes(abstractDomainFieldHandlerImpl.fieldNumber);
            operation.equalBytes(abstractDomainFieldHandlerImpl.storeColumn, byArray);
        }

        @Override
        public String handler() {
            return "setKeyBytes";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setBytes(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getBytes(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundBytes(abstractDomainFieldHandlerImpl.storeColumn, boundType, (byte[])object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpBytes(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (byte[])object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setBytes.setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalBytes(abstractDomainFieldHandlerImpl.storeColumn, (byte[])object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addBytesKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getBytes(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getBytes(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getBytes(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setBytes(abstractDomainFieldHandlerImpl.fieldNumber, (byte[])object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerBytesLob = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getBlob(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            if (string == null) {
                return new byte[0];
            }
            throw new UnsupportedOperationException(local.message("ERR_Convert_String_To_Value", (Object)string, (Object)"byte[]"));
        }

        @Override
        public void operationSetValue(final AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, final Object object, final Operation operation) {
            Blob blob = operation.getBlobHandle(abstractDomainFieldHandlerImpl.storeColumn);
            if (object == null) {
                blob.setNull();
            } else {
                blob.setValue(emptyByteArray);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Blob blob = operation.getBlobHandle(abstractDomainFieldHandlerImpl.storeColumn);
                        byte[] byArray = (byte[])object;
                        int n = byArray.length;
                        if (logger.isDetailEnabled()) {
                            logger.detail("Value to operation set blob value for field " + abstractDomainFieldHandlerImpl.name + " for column " + abstractDomainFieldHandlerImpl.columnName + " wrote length " + n + AbstractDomainFieldHandlerImpl.formatBytes(16, byArray));
                        }
                        blob.writeData(byArray);
                    }
                };
                operation.postExecuteCallback(runnable);
            }
        }

        @Override
        public void operationSetValue(final AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, final ValueHandler valueHandler, final Operation operation) {
            Blob blob = operation.getBlobHandle(abstractDomainFieldHandlerImpl.storeColumn);
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                blob.setNull();
            } else {
                blob.setValue(emptyByteArray);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Blob blob = operation.getBlobHandle(abstractDomainFieldHandlerImpl.storeColumn);
                        byte[] byArray = valueHandler.getLobBytes(abstractDomainFieldHandlerImpl.fieldNumber);
                        int n = byArray.length;
                        if (logger.isDetailEnabled()) {
                            logger.detail("Value to operation set blob value for field " + abstractDomainFieldHandlerImpl.name + " for column " + abstractDomainFieldHandlerImpl.columnName + " wrote length " + n + AbstractDomainFieldHandlerImpl.formatBytes(16, byArray));
                        }
                        blob.writeData(byArray);
                    }
                };
                operation.postExecuteCallback(runnable);
            }
        }

        @Override
        public String handler() {
            return "setBytesLob";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            Blob blob = resultData.getBlob(abstractDomainFieldHandlerImpl.storeColumn);
            int n = blob.getLength().intValue();
            byte[] byArray = new byte[n];
            blob.readData(byArray, n);
            if (logger.isDetailEnabled()) {
                logger.detail("ResultSet get blob value for field " + abstractDomainFieldHandlerImpl.name + " for column " + abstractDomainFieldHandlerImpl.columnName + " returned length " + n + AbstractDomainFieldHandlerImpl.formatBytes(16, byArray));
            }
            blob.close();
            valueHandler.setLobBytes(abstractDomainFieldHandlerImpl.fieldNumber, byArray);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getBoolean(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getLobBytes(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setLobBytes(abstractDomainFieldHandlerImpl.fieldNumber, (byte[])object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerStringLob = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getBlob(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            if (string == null) {
                return "";
            }
            return string;
        }

        @Override
        public void operationSetValue(final AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, final Object object, final Operation operation) {
            Blob blob = operation.getBlobHandle(abstractDomainFieldHandlerImpl.storeColumn);
            if (object == null) {
                blob.setNull();
            } else {
                blob.setValue(emptyByteArray);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Blob blob = operation.getBlobHandle(abstractDomainFieldHandlerImpl.storeColumn);
                        byte[] byArray = abstractDomainFieldHandlerImpl.storeColumn.encode((String)object);
                        int n = byArray.length;
                        if (logger.isDetailEnabled()) {
                            logger.detail("Value to operation set text value for field " + abstractDomainFieldHandlerImpl.name + " for column " + abstractDomainFieldHandlerImpl.columnName + " wrote length " + n + AbstractDomainFieldHandlerImpl.formatBytes(16, byArray));
                        }
                        blob.writeData(byArray);
                    }
                };
                operation.postExecuteCallback(runnable);
            }
        }

        @Override
        public void operationSetValue(final AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, final ValueHandler valueHandler, final Operation operation) {
            Blob blob = operation.getBlobHandle(abstractDomainFieldHandlerImpl.storeColumn);
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                blob.setNull();
            } else {
                blob.setValue(emptyByteArray);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Blob blob = operation.getBlobHandle(abstractDomainFieldHandlerImpl.storeColumn);
                        byte[] byArray = abstractDomainFieldHandlerImpl.storeColumn.encode(valueHandler.getLobString(abstractDomainFieldHandlerImpl.fieldNumber));
                        int n = byArray.length;
                        if (logger.isDetailEnabled()) {
                            logger.detail("Value to operation set text value for field " + abstractDomainFieldHandlerImpl.name + " for column " + abstractDomainFieldHandlerImpl.columnName + " wrote length " + n + AbstractDomainFieldHandlerImpl.formatBytes(16, byArray));
                        }
                        blob.writeData(byArray);
                    }
                };
                operation.postExecuteCallback(runnable);
            }
        }

        @Override
        public String handler() {
            return "setStringLob";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            Blob blob = resultData.getBlob(abstractDomainFieldHandlerImpl.storeColumn);
            int n = blob.getLength().intValue();
            byte[] byArray = new byte[n];
            blob.readData(byArray, n);
            if (logger.isDetailEnabled()) {
                logger.detail("ResultSet get text value for field " + abstractDomainFieldHandlerImpl.name + " for column " + abstractDomainFieldHandlerImpl.columnName + " returned length " + n + AbstractDomainFieldHandlerImpl.formatBytes(16, byArray));
            }
            blob.close();
            try {
                valueHandler.setLobString(abstractDomainFieldHandlerImpl.fieldNumber, abstractDomainFieldHandlerImpl.storeColumn.decode(byArray));
            }
            catch (ClusterJException clusterJException) {
                System.out.println(clusterJException.getMessage() + " length: " + byArray.length + " " + AbstractDomainFieldHandlerImpl.formatBytes(byArray.length, byArray));
                throw clusterJException;
            }
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getString(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getLobString(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setLobString(abstractDomainFieldHandlerImpl.fieldNumber, (String)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerDecimal = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? BigDecimal.ZERO : new BigDecimal(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setDecimal(abstractDomainFieldHandlerImpl.storeColumn, (BigDecimal)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setDecimal(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getBigDecimal(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object BigDecimal";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setBigDecimal(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getDecimal(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundDecimal(abstractDomainFieldHandlerImpl.storeColumn, boundType, (BigDecimal)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpDecimal(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (BigDecimal)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setDecimal.setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalDecimal(abstractDomainFieldHandlerImpl.storeColumn, (BigDecimal)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getBigDecimal(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getBigDecimal(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setBigDecimal(abstractDomainFieldHandlerImpl.fieldNumber, (BigDecimal)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerBigInteger = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? BigInteger.ZERO : new BigInteger(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setBigInteger(abstractDomainFieldHandlerImpl.storeColumn, (BigInteger)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setBigInteger(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getBigInteger(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object BigInteger";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setBigInteger(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getBigInteger(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundBigInteger(abstractDomainFieldHandlerImpl.storeColumn, boundType, (BigInteger)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpBigInteger(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (BigInteger)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setDecimal.setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalBigInteger(abstractDomainFieldHandlerImpl.storeColumn, (BigInteger)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getBigInteger(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getBigInteger(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setBigInteger(abstractDomainFieldHandlerImpl.fieldNumber, (BigInteger)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerDouble = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setDouble(abstractDomainFieldHandlerImpl.fieldNumber, 0.0);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Double.valueOf("0") : Double.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setDouble(abstractDomainFieldHandlerImpl.storeColumn, (Double)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            operation.setDouble(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getDouble(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public String handler() {
            return "primitive double";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setDouble(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getDouble(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundDouble(abstractDomainFieldHandlerImpl.storeColumn, boundType, (Double)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpDouble(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (Double)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalDouble(abstractDomainFieldHandlerImpl.storeColumn, (Double)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getDouble(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getDouble(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setDouble(abstractDomainFieldHandlerImpl.fieldNumber, (Double)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerFloat = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setFloat(abstractDomainFieldHandlerImpl.fieldNumber, 0.0f);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Float.valueOf("0") : Float.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setFloat(abstractDomainFieldHandlerImpl.storeColumn, (Float)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            operation.setFloat(abstractDomainFieldHandlerImpl.storeColumn, Float.valueOf(valueHandler.getFloat(abstractDomainFieldHandlerImpl.fieldNumber)));
        }

        @Override
        public String handler() {
            return "primitive float";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setFloat(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getFloat(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundFloat(abstractDomainFieldHandlerImpl.storeColumn, boundType, (Float)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpFloat(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Float)object).floatValue());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalFloat(abstractDomainFieldHandlerImpl.storeColumn, ((Float)object).floatValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getFloat(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return Float.valueOf(valueHandler.getFloat(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setFloat(abstractDomainFieldHandlerImpl.fieldNumber, ((Float)object).floatValue());
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerInt = new ObjectOperationHandlerInt(){

        @Override
        public String handler() {
            return "primitive int";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + abstractDomainFieldHandlerImpl.columnName + " set to value " + valueHandler.getInt(abstractDomainFieldHandlerImpl.fieldNumber));
            }
            operation.setInt(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getInt(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyInt = new ObjectOperationHandlerInt(){

        @Override
        public String handler() {
            return "primitive key int";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("Key field " + abstractDomainFieldHandlerImpl.name + " set equal to value " + valueHandler.getInt(abstractDomainFieldHandlerImpl.getFieldNumber()));
            }
            operation.equalInt(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getInt(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addIntKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getInt(abstractDomainFieldHandlerImpl.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerJavaSqlDate = new ObjectOperationHandlerJavaSqlDate(){

        @Override
        public String handler() {
            return "object java.sql.Date";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getJavaSqlDate(abstractDomainFieldHandlerImpl.fieldNumber).getTime());
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyJavaSqlDate = new ObjectOperationHandlerJavaSqlDate(){

        @Override
        public String handler() {
            return "key java.sql.Date";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + abstractDomainFieldHandlerImpl.columnName + " set to value " + valueHandler.getLong(abstractDomainFieldHandlerImpl.fieldNumber));
            }
            operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getJavaSqlDate(abstractDomainFieldHandlerImpl.fieldNumber).getTime());
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addLongKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getJavaSqlDate(abstractDomainFieldHandlerImpl.fieldNumber).getTime());
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerJavaSqlTime = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            if (string == null) {
                return new Time(new java.util.Date().getTime());
            }
            return Time.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, ((Time)object).getTime());
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getJavaSqlTime(abstractDomainFieldHandlerImpl.fieldNumber).getTime());
            }
        }

        @Override
        public String handler() {
            return "object java.sql.Time";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setJavaSqlTime(abstractDomainFieldHandlerImpl.fieldNumber, new Time(resultData.getLong(abstractDomainFieldHandlerImpl.storeColumn)));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundLong(abstractDomainFieldHandlerImpl.storeColumn, boundType, ((Time)object).getTime());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpLong(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Time)object).getTime());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, ((Time)object).getTime());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getJavaSqlTime(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getJavaSqlTime(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setJavaSqlTime(abstractDomainFieldHandlerImpl.fieldNumber, (Time)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerJavaSqlTimestamp = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            if (string == null) {
                return new Timestamp(new java.util.Date().getTime());
            }
            return Timestamp.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, ((Timestamp)object).getTime());
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getJavaSqlTimestamp(abstractDomainFieldHandlerImpl.fieldNumber).getTime());
            }
        }

        @Override
        public String handler() {
            return "object java.sql.Timestamp";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setJavaSqlTimestamp(abstractDomainFieldHandlerImpl.fieldNumber, new Timestamp(resultData.getLong(abstractDomainFieldHandlerImpl.storeColumn)));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundLong(abstractDomainFieldHandlerImpl.storeColumn, boundType, ((Timestamp)object).getTime());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpLong(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Timestamp)object).getTime());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, ((Timestamp)object).getTime());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getJavaSqlTimestamp(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getJavaSqlTimestamp(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setJavaSqlTimestamp(abstractDomainFieldHandlerImpl.fieldNumber, (Timestamp)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerJavaUtilDate = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            if (string == null) {
                return new java.util.Date();
            }
            return AbstractDomainFieldHandlerImpl.parse(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, ((java.util.Date)object).getTime());
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getJavaUtilDate(abstractDomainFieldHandlerImpl.fieldNumber).getTime());
            }
        }

        @Override
        public String handler() {
            return "object java.util.Date";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setJavaUtilDate(abstractDomainFieldHandlerImpl.fieldNumber, new java.util.Date(resultData.getLong(abstractDomainFieldHandlerImpl.storeColumn)));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundLong(abstractDomainFieldHandlerImpl.storeColumn, boundType, ((java.util.Date)object).getTime());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpLong(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((java.util.Date)object).getTime());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, ((java.util.Date)object).getTime());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getJavaUtilDate(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getJavaUtilDate(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setJavaUtilDate(abstractDomainFieldHandlerImpl.fieldNumber, (java.util.Date)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyString = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? "" : string;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setString(abstractDomainFieldHandlerImpl.storeColumn, (String)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            operation.equalString(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getString(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public String handler() {
            return "key String";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setString(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getString(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundString(abstractDomainFieldHandlerImpl.storeColumn, boundType, (String)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpString(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (String)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setString.setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalString(abstractDomainFieldHandlerImpl.storeColumn, (String)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addStringKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getString(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getString(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getString(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setString(abstractDomainFieldHandlerImpl.fieldNumber, (String)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerLong = new ObjectOperationHandlerLong(){

        @Override
        public String handler() {
            return "primitive long";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + abstractDomainFieldHandlerImpl.columnName + " set to value " + valueHandler.getLong(abstractDomainFieldHandlerImpl.fieldNumber));
            }
            operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getLong(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyLong = new ObjectOperationHandlerLong(){

        @Override
        public String handler() {
            return "key primitive long";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + abstractDomainFieldHandlerImpl.columnName + " set to value " + valueHandler.getLong(abstractDomainFieldHandlerImpl.fieldNumber));
            }
            operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getLong(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addLongKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getLong(abstractDomainFieldHandlerImpl.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectDouble = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Double.valueOf("0") : Double.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setDouble(abstractDomainFieldHandlerImpl.storeColumn, (Double)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setDouble(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectDouble(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object Double";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setObjectDouble(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getObjectDouble(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundDouble(abstractDomainFieldHandlerImpl.storeColumn, boundType, (Double)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpDouble(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (Double)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalDouble(abstractDomainFieldHandlerImpl.storeColumn, (Double)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getDouble(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getObjectDouble(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setObjectDouble(abstractDomainFieldHandlerImpl.fieldNumber, (Double)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectFloat = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Float.valueOf("0") : Float.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setFloat(abstractDomainFieldHandlerImpl.storeColumn, (Float)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setFloat(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectFloat(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object Float";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setObjectFloat(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getObjectFloat(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundFloat(abstractDomainFieldHandlerImpl.storeColumn, boundType, (Float)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpFloat(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Float)object).floatValue());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalFloat(abstractDomainFieldHandlerImpl.storeColumn, ((Float)object).floatValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getFloat(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getObjectFloat(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setObjectFloat(abstractDomainFieldHandlerImpl.fieldNumber, (Float)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectInteger = new ObjectOperationHandlerInteger(){

        @Override
        public String handler() {
            return "object Integer";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setInt(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectInt(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyObjectInteger = new ObjectOperationHandlerInteger(){

        @Override
        public String handler() {
            return "key object Integer";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.equalInt(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectInt(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addIntKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectInt(abstractDomainFieldHandlerImpl.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectLong = new ObjectOperationHandlerObjectLong(){

        @Override
        public String handler() {
            return "object Long";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectLong(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyObjectLong = new ObjectOperationHandlerObjectLong(){

        @Override
        public String handler() {
            return "key object Long";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectLong(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addLongKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectLong(abstractDomainFieldHandlerImpl.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerShort = new ObjectOperationHandlerShort(){

        @Override
        public String handler() {
            return "primitive short";
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyShort = new ObjectOperationHandlerShort(){

        @Override
        public String handler() {
            return "primitive key short";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            operation.equalShort(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getShort(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            partitionKey.addShortKey(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getShort(abstractDomainFieldHandlerImpl.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectShort = new ObjectOperationHandlerObjectShort(){

        @Override
        public String handler() {
            return "object Short";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setShort(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getObjectShort(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerShortYear = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, (short)1900);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Short.valueOf((short)1900) : Short.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setByte(abstractDomainFieldHandlerImpl.storeColumn, (byte)((Short)object - 1900));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            operation.setByte(abstractDomainFieldHandlerImpl.storeColumn, (byte)(valueHandler.getShort(abstractDomainFieldHandlerImpl.fieldNumber) - 1900));
        }

        @Override
        public String handler() {
            return "primitive short year";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, (short)(resultData.getByte(abstractDomainFieldHandlerImpl.storeColumn) + 1900));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            try {
                indexScanOperation.setBoundByte(abstractDomainFieldHandlerImpl.storeColumn, boundType, (byte)(((Number)object).shortValue() - 1900));
            }
            catch (ClassCastException classCastException) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)object.getClass().getName()));
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            try {
                scanFilter.cmpByte(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (byte)(((Number)object).shortValue() - 1900));
            }
            catch (ClassCastException classCastException) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)object.getClass().getName()));
            }
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalByte(abstractDomainFieldHandlerImpl.storeColumn, (byte)(((Number)object).shortValue() - 1900));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getShort(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return (short)(valueHandler.getByte(abstractDomainFieldHandlerImpl.fieldNumber) + 1900);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setByte(abstractDomainFieldHandlerImpl.fieldNumber, (byte)((Short)object - 1900));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectShortYear = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, (short)1900);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Short.valueOf((short)1900) : Short.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setByte(abstractDomainFieldHandlerImpl.storeColumn, (byte)((Short)object - 1900));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setByte(abstractDomainFieldHandlerImpl.storeColumn, (byte)(valueHandler.getShort(abstractDomainFieldHandlerImpl.fieldNumber) - 1900));
            }
        }

        @Override
        public String handler() {
            return "object short year";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, (short)(resultData.getByte(abstractDomainFieldHandlerImpl.storeColumn) + 1900));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            try {
                indexScanOperation.setBoundByte(abstractDomainFieldHandlerImpl.storeColumn, boundType, (byte)(((Number)object).shortValue() - 1900));
            }
            catch (ClassCastException classCastException) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)object.getClass().getName()));
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            try {
                scanFilter.cmpByte(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (byte)(((Number)object).shortValue() - 1900));
            }
            catch (ClassCastException classCastException) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)object.getClass().getName()));
            }
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalByte(abstractDomainFieldHandlerImpl.storeColumn, (byte)(((Number)object).shortValue() - 1900));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getShort(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            Byte by = valueHandler.getObjectByte(abstractDomainFieldHandlerImpl.fieldNumber);
            return by == null ? null : Short.valueOf((short)(by + 1900));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            if (object == null) {
                valueHandler.setObjectByte(abstractDomainFieldHandlerImpl.fieldNumber, null);
            } else {
                valueHandler.setByte(abstractDomainFieldHandlerImpl.fieldNumber, (byte)((Short)object - 1900));
            }
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerString = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? "" : string;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (object == null) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setString(abstractDomainFieldHandlerImpl.storeColumn, (String)object);
            }
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setString(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getString(abstractDomainFieldHandlerImpl.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object String";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            if (logger.isDetailEnabled()) {
                logger.detail("field " + abstractDomainFieldHandlerImpl.name + " set to value " + resultData.getString(abstractDomainFieldHandlerImpl.storeColumn));
            }
            valueHandler.setString(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getString(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundString(abstractDomainFieldHandlerImpl.storeColumn, boundType, (String)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpString(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (String)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalString(abstractDomainFieldHandlerImpl.storeColumn, (String)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getString(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getString(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setString(abstractDomainFieldHandlerImpl.fieldNumber, (String)object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerUnsupportedType = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return null;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public String handler() {
            return "unsupported Type";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)abstractDomainFieldHandlerImpl.getTypeName(), (Object)abstractDomainFieldHandlerImpl.getName()));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerVirtualType = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
        }

        @Override
        public String handler() {
            return "Virtual Type (field with no columns)";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentByte = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive byte";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setByte(abstractDomainFieldHandlerImpl.fieldNumber, (byte)0);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getByte(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setByte(abstractDomainFieldHandlerImpl.fieldNumber, (Byte)object);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return (byte)0;
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentDouble = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive double";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setDouble(abstractDomainFieldHandlerImpl.fieldNumber, 0.0);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getDouble(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setDouble(abstractDomainFieldHandlerImpl.fieldNumber, (Double)object);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return 0.0;
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentFloat = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive float";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setFloat(abstractDomainFieldHandlerImpl.fieldNumber, 0.0f);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return Float.valueOf(valueHandler.getFloat(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setFloat(abstractDomainFieldHandlerImpl.fieldNumber, ((Float)object).floatValue());
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return Float.valueOf(0.0f);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentInt = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive int";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setInt(abstractDomainFieldHandlerImpl.fieldNumber, 0);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getInt(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setInt(abstractDomainFieldHandlerImpl.fieldNumber, (Integer)object);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return 0;
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentLong = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive long";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setLong(abstractDomainFieldHandlerImpl.fieldNumber, 0L);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getLong(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setLong(abstractDomainFieldHandlerImpl.fieldNumber, (Long)object);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return 0L;
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentObject = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent Object";
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.get(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setObject(abstractDomainFieldHandlerImpl.fieldNumber, object);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentShort = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive short";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, (short)0);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getShort(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, (Short)object);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return (short)0;
        }
    };

    protected void error(String string) {
        if (this.errorMessages == null) {
            this.errorMessages = new StringBuffer(local.message("ERR_Field_Not_Valid", (Object)this.domainTypeHandler.getName(), (Object)this.name));
        }
        this.errorMessages.append(string);
        this.errorMessages.append('\n');
    }

    @Override
    public void filterCompareValue(Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
        if (object == null) {
            if (ScanFilter.BinaryCondition.COND_EQ.equals((Object)binaryCondition)) {
                scanFilter.isNull(this.storeColumn);
                return;
            }
            throw new ClusterJUserException(local.message("ERR_Null_Values_Can_Only_Be_Filtered_Equal", new Object[]{this.domainTypeHandler.getName(), this.name, binaryCondition}));
        }
        try {
            this.objectOperationHandlerDelegate.filterCompareValue(this, object, binaryCondition, scanFilter);
        }
        catch (Exception exception) {
            throw new ClusterJDatastoreException(local.message("ERR_Filter_Value", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), object), exception);
        }
    }

    @Override
    public void filterIsNull(ScanFilter scanFilter) {
        scanFilter.isNull(this.storeColumn);
    }

    @Override
    public void filterIsNotNull(ScanFilter scanFilter) {
        scanFilter.isNotNull(this.storeColumn);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getFieldNumber() {
        return this.fieldNumber;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type == null ? "unknown" : this.printableName(this.type);
    }

    protected String printableName(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.printableName(clazz.getComponentType()) + "[] ";
        }
        return clazz.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean includedInIndex(String string) {
        return this.indexNames.contains(string);
    }

    public boolean isPrimitive() {
        return this.objectOperationHandlerDelegate.isPrimitive();
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Column getStoreColumn() {
        return this.storeColumn;
    }

    @Override
    public void markEqualBounds(CandidateIndexImpl[] candidateIndexImplArray, PredicateImpl predicateImpl) {
        for (int[] nArray : this.indices) {
            candidateIndexImplArray[nArray[0]].markEqualBound(nArray[1], predicateImpl);
        }
    }

    @Override
    public void markInBounds(CandidateIndexImpl[] candidateIndexImplArray, InPredicateImpl inPredicateImpl) {
        for (int[] nArray : this.indices) {
            candidateIndexImplArray[nArray[0]].markInBound(nArray[1], inPredicateImpl);
        }
    }

    @Override
    public void markLowerBounds(CandidateIndexImpl[] candidateIndexImplArray, PredicateImpl predicateImpl, boolean bl) {
        for (int[] nArray : this.indices) {
            candidateIndexImplArray[nArray[0]].markLowerBound(nArray[1], predicateImpl, bl);
        }
    }

    @Override
    public void markUpperBounds(CandidateIndexImpl[] candidateIndexImplArray, PredicateImpl predicateImpl, boolean bl) {
        for (int[] nArray : this.indices) {
            candidateIndexImplArray[nArray[0]].markUpperBound(nArray[1], predicateImpl, bl);
        }
    }

    @Override
    public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
        return this.objectOperationHandlerDelegate.getValue(queryExecutionContext, string);
    }

    void objectSetDefaultValue(ValueHandler valueHandler) {
        this.objectOperationHandlerDelegate.objectInitializeJavaDefaultValue(this, valueHandler);
    }

    Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void objectSetKeyValue(Object object, ValueHandler valueHandler) {
        if (logger.isDetailEnabled()) {
            logger.detail("Setting value " + object + ".");
        }
        this.objectOperationHandlerDelegate.objectSetValue(this, object, valueHandler);
    }

    @Override
    public void objectSetValue(ResultData resultData, ValueHandler valueHandler) {
        try {
            this.objectOperationHandlerDelegate.objectSetValue(this, resultData, valueHandler);
        }
        catch (Exception exception) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "objectSetValue"), exception);
        }
    }

    @Override
    public void objectSetValue(Object object, ValueHandler valueHandler) {
        try {
            this.objectOperationHandlerDelegate.objectSetValue(this, object, valueHandler);
        }
        catch (Exception exception) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "objectSetValue"), exception);
        }
    }

    @Override
    public Object objectGetValue(ValueHandler valueHandler) {
        try {
            return this.objectOperationHandlerDelegate.objectGetValue(this, valueHandler);
        }
        catch (Exception exception) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "objectGetValue"), exception);
        }
    }

    @Override
    public void objectSetValueExceptIndex(ResultData resultData, ValueHandler valueHandler, String string) {
        try {
            if (!this.includedInIndex(string)) {
                this.objectOperationHandlerDelegate.objectSetValue(this, resultData, valueHandler);
            }
        }
        catch (Exception exception) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "objectSetValueExcept"), exception);
        }
    }

    @Override
    public void objectSetValueFor(Object object, Object object2, String string) {
        if (this.includedInIndex(string)) {
            ValueHandler valueHandler = (ValueHandler)Proxy.getInvocationHandler(object2);
            valueHandler.setObject(this.fieldNumber, object);
        }
    }

    @Override
    public void operationEqual(Object object, Operation operation) {
        try {
            this.objectOperationHandlerDelegate.operationEqual(this, object, operation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationEqual"), exception);
        }
    }

    @Override
    public void operationEqualForIndex(Object object, Operation operation, String string) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void operationGetValue(Operation operation) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column " + this.columnName + ".");
        }
        try {
            this.objectOperationHandlerDelegate.operationGetValue(this, operation);
        }
        catch (Exception exception) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationGetValue"), exception);
        }
    }

    @Override
    public void operationSetBounds(Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + this.columnName + " type: " + (Object)((Object)boundType) + " value: " + object);
        }
        try {
            this.objectOperationHandlerDelegate.operationSetBounds(this, object, boundType, indexScanOperation);
        }
        catch (Exception exception) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationSetBounds"), exception);
        }
    }

    @Override
    public void operationSetModifiedValue(ValueHandler valueHandler, Operation operation) {
        if (valueHandler.isModified(this.fieldNumber)) {
            this.operationSetValue(valueHandler, operation);
        }
    }

    @Override
    public void operationSetValue(ValueHandler valueHandler, Operation operation) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + this.columnName + " field: " + this.name + " type: " + this.type + " delegate " + this.objectOperationHandlerDelegate.handler());
        }
        try {
            this.objectOperationHandlerDelegate.operationSetValue(this, valueHandler, operation);
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationSetValue"), clusterJDatastoreException);
        }
    }

    public void operationSetValue(Object object, Operation operation) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + this.columnName + " field: " + this.name + " type: " + this.type + " delegate " + this.objectOperationHandlerDelegate.handler());
        }
        try {
            this.objectOperationHandlerDelegate.operationSetValue(this, object, operation);
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationSetValue"), clusterJDatastoreException);
        }
    }

    protected void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
        try {
            this.objectOperationHandlerDelegate.operationSetValue(abstractDomainFieldHandlerImpl, object, operation);
        }
        catch (Exception exception) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationSetValue"), exception);
        }
    }

    @Override
    public void partitionKeySetPart(PartitionKey partitionKey, ValueHandler valueHandler) {
        try {
            this.objectOperationHandlerDelegate.partitionKeySetPart(this, partitionKey, valueHandler);
        }
        catch (NullPointerException nullPointerException) {
            throw new ClusterJUserException(local.message("ERR_Key_Must_Not_Be_Null", (Object)this.domainTypeHandler.getName(), (Object)this.getName()), nullPointerException);
        }
    }

    protected static String formatBytes(int n, byte[] byArray) {
        int n2 = Math.min(n, byArray.length);
        StringBuffer stringBuffer = new StringBuffer(":");
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("[");
            stringBuffer.append(byArray[i]);
            stringBuffer.append("]");
        }
        if (n2 < byArray.length) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    protected static java.util.Date parse(String string) {
        try {
            return new SimpleDateFormat().parse(string);
        }
        catch (ParseException parseException) {
            throw new ClusterJUserException(local.message("ERR_Parse_Exception", (Object)string));
        }
    }

    protected String printIndices() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("indices[");
        stringBuffer.append(this.indices.length);
        stringBuffer.append("][]\n");
        for (int[] nArray : this.indices) {
            stringBuffer.append(" row size ");
            stringBuffer.append(nArray == null ? "null" : Integer.valueOf(nArray.length));
            stringBuffer.append(": ");
            stringBuffer.append(nArray == null ? "" : Integer.valueOf(nArray[0]));
            stringBuffer.append(" ");
            stringBuffer.append(nArray == null ? "" : Integer.valueOf(nArray[1]));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected void reportErrors() {
        if (this.errorMessages != null) {
            this.domainTypeHandler.setUnsupported(this.errorMessages.toString());
        }
    }

    public String toString() {
        return this.name;
    }

    public void validateIndexType(String string, boolean bl) {
        if (this.objectOperationHandlerDelegate == null || !this.objectOperationHandlerDelegate.isValidIndexType(this, bl)) {
            this.error(local.message("ERR_Invalid_Index_For_Type", this.domainTypeHandler.getName(), this.name, this.columnName, string, bl ? "hash" : "btree"));
        }
    }

    protected void initializeColumnMetadata(Column column) {
        this.columnName = column.getName();
        this.storeColumnType = column.getType();
        this.charsetName = column.getCharsetName();
        this.primaryKey = column.isPrimaryKey();
        this.partitionKey = column.isPartitionKey();
        this.precision = column.getPrecision();
        this.scale = column.getScale();
        this.maximumLength = column.getLength();
        this.nullable = column.getNullable();
    }

    @Override
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public int maximumLength() {
        return this.maximumLength;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int number() {
        return this.fieldNumber;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public ColumnType columnType() {
        return this.storeColumnType;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public Class<?> javaType() {
        return this.type;
    }

    @Override
    public String charsetName() {
        return this.charsetName;
    }

    @Override
    public boolean isLob() {
        throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"isLob()", (Object)"AbstractDomainFieldHandlerImpl"));
    }

    @Override
    public boolean isPersistent() {
        throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"isPersistent()", (Object)"AbstractDomainFieldHandlerImpl"));
    }

    protected static abstract class ObjectOperationHandlerNotPersistent
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerNotPersistent() {
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return null;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }
    }

    protected static abstract class ObjectOperationHandlerObjectShort
    extends ObjectOperationHandlerShort {
        protected ObjectOperationHandlerObjectShort() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Short.valueOf((short)0) : Short.valueOf(string);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setObjectShort(abstractDomainFieldHandlerImpl.fieldNumber, object != null ? Short.valueOf(((Number)object).shortValue()) : null);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getObjectShort(abstractDomainFieldHandlerImpl.fieldNumber);
        }
    }

    protected static abstract class ObjectOperationHandlerShort
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerShort() {
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, (short)0);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Short.valueOf((short)0) : Short.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setShort(abstractDomainFieldHandlerImpl.storeColumn, (Short)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + abstractDomainFieldHandlerImpl.columnName + " set to value " + valueHandler.getShort(abstractDomainFieldHandlerImpl.fieldNumber));
            }
            operation.setShort(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getShort(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getShort(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setShort(abstractDomainFieldHandlerImpl.fieldNumber, ((Number)object).shortValue());
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            try {
                indexScanOperation.setBoundShort(abstractDomainFieldHandlerImpl.storeColumn, boundType, ((Number)object).shortValue());
            }
            catch (ClassCastException classCastException) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)object.getClass().getName()));
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            try {
                scanFilter.cmpShort(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).shortValue());
            }
            catch (ClassCastException classCastException) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)object.getClass().getName()));
            }
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalShort(abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).shortValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getShort(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getShort(abstractDomainFieldHandlerImpl.fieldNumber);
        }
    }

    public static abstract class ObjectOperationHandlerObjectLong
    implements ObjectOperationHandler {
        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Long.valueOf(0L) : Long.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).longValue());
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setObjectLong(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getObjectLong(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundLong(abstractDomainFieldHandlerImpl.storeColumn, boundType, ((Number)object).longValue());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpLong(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).longValue());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setObjectLong.setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).longValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getLong(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getObjectLong(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setObjectLong(abstractDomainFieldHandlerImpl.fieldNumber, (Long)object);
        }
    }

    protected static abstract class ObjectOperationHandlerInteger
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerInteger() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Integer.valueOf(0) : Integer.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setInt(abstractDomainFieldHandlerImpl.storeColumn, (Integer)object);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setObjectInt(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getObjectInteger(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundInt(abstractDomainFieldHandlerImpl.storeColumn, boundType, (Integer)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpInt(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (Integer)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setObjectInteger.setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalInt(abstractDomainFieldHandlerImpl.storeColumn, (Integer)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getInt(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getObjectInt(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setObjectInt(abstractDomainFieldHandlerImpl.fieldNumber, (Integer)object);
        }
    }

    public static abstract class ObjectOperationHandlerLong
    implements ObjectOperationHandler {
        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setLong(abstractDomainFieldHandlerImpl.fieldNumber, 0L);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Long.valueOf(0L) : Long.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).longValue());
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setLong(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getLong(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundLong(abstractDomainFieldHandlerImpl.storeColumn, boundType, ((Number)object).longValue());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpLong(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).longValue());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setLong.setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).longValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getLong(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getLong(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setLong(abstractDomainFieldHandlerImpl.fieldNumber, (Long)object);
        }
    }

    protected static abstract class ObjectOperationHandlerJavaSqlDate
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerJavaSqlDate() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            if (string == null) {
                return new Date(new java.util.Date().getTime());
            }
            return Date.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, ((Date)object).getTime());
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (valueHandler.isNull(abstractDomainFieldHandlerImpl.fieldNumber)) {
                operation.setNull(abstractDomainFieldHandlerImpl.storeColumn);
            } else {
                operation.setLong(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getJavaSqlDate(abstractDomainFieldHandlerImpl.fieldNumber).getTime());
            }
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            try {
                valueHandler.setJavaSqlDate(abstractDomainFieldHandlerImpl.fieldNumber, new Date(resultData.getLong(abstractDomainFieldHandlerImpl.storeColumn)));
            }
            catch (Exception exception) {
                throw new ClusterJDatastoreException(local.message("ERR_Set_Value", (Object)abstractDomainFieldHandlerImpl.objectOperationHandlerDelegate.handler()), exception);
            }
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundLong(abstractDomainFieldHandlerImpl.storeColumn, boundType, ((Date)object).getTime());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpLong(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Date)object).getTime());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalLong(abstractDomainFieldHandlerImpl.storeColumn, ((Date)object).getTime());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getJavaSqlDate(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getJavaSqlDate(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setJavaSqlDate(abstractDomainFieldHandlerImpl.fieldNumber, (Date)object);
        }
    }

    protected static abstract class ObjectOperationHandlerInt
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerInt() {
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setInt(abstractDomainFieldHandlerImpl.fieldNumber, 0);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            Integer n = string == null ? Integer.valueOf(0) : Integer.valueOf(string);
            return n;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setInt(abstractDomainFieldHandlerImpl.storeColumn, (Integer)object);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            int n = resultData.getInt(abstractDomainFieldHandlerImpl.storeColumn);
            if (logger.isDetailEnabled()) {
                logger.detail("Field " + abstractDomainFieldHandlerImpl.name + " from column " + abstractDomainFieldHandlerImpl.columnName + " set to value " + n);
            }
            valueHandler.setInt(abstractDomainFieldHandlerImpl.fieldNumber, n);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundInt(abstractDomainFieldHandlerImpl.storeColumn, boundType, (Integer)object);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            scanFilter.cmpInt(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, (Integer)object);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("setEqual " + abstractDomainFieldHandlerImpl.columnName + " to value " + object);
            }
            operation.equalInt(abstractDomainFieldHandlerImpl.storeColumn, (Integer)object);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getInt(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getInt(abstractDomainFieldHandlerImpl.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setInt(abstractDomainFieldHandlerImpl.fieldNumber, (Integer)object);
        }
    }

    protected static abstract class ObjectOperationHandlerObjectByte
    extends ObjectOperationHandlerByte {
        protected ObjectOperationHandlerObjectByte() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Byte.valueOf((byte)0) : Byte.valueOf(string);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setObjectByte(abstractDomainFieldHandlerImpl.fieldNumber, object != null ? Byte.valueOf(((Number)object).byteValue()) : null);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getObjectByte(abstractDomainFieldHandlerImpl.fieldNumber);
        }
    }

    protected static abstract class ObjectOperationHandlerByte
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerByte() {
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            valueHandler.setByte(abstractDomainFieldHandlerImpl.fieldNumber, (byte)0);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            return string == null ? Byte.valueOf((byte)0) : Byte.valueOf(string);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.setByte(abstractDomainFieldHandlerImpl.storeColumn, (Byte)object);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + abstractDomainFieldHandlerImpl.columnName + " set to value " + valueHandler.getByte(abstractDomainFieldHandlerImpl.fieldNumber));
            }
            operation.setByte(abstractDomainFieldHandlerImpl.storeColumn, valueHandler.getByte(abstractDomainFieldHandlerImpl.fieldNumber));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            valueHandler.setByte(abstractDomainFieldHandlerImpl.fieldNumber, resultData.getByte(abstractDomainFieldHandlerImpl.storeColumn));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            valueHandler.setByte(abstractDomainFieldHandlerImpl.fieldNumber, ((Number)object).byteValue());
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            try {
                indexScanOperation.setBoundByte(abstractDomainFieldHandlerImpl.storeColumn, boundType, ((Number)object).byteValue());
            }
            catch (ClassCastException classCastException) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)object.getClass().getName()));
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            try {
                scanFilter.cmpByte(binaryCondition, abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).byteValue());
            }
            catch (ClassCastException classCastException) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)object.getClass().getName()));
            }
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            operation.equalByte(abstractDomainFieldHandlerImpl.storeColumn, ((Number)object).byteValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getByte(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            return valueHandler.getByte(abstractDomainFieldHandlerImpl.fieldNumber);
        }
    }

    protected static interface ObjectOperationHandler {
        public boolean isPrimitive();

        public Object objectGetValue(AbstractDomainFieldHandlerImpl var1, ValueHandler var2);

        public Object getValue(QueryExecutionContext var1, String var2);

        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl var1, ValueHandler var2);

        public void operationGetValue(AbstractDomainFieldHandlerImpl var1, Operation var2);

        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl var1, String var2);

        public void operationSetValue(AbstractDomainFieldHandlerImpl var1, Object var2, Operation var3);

        public void operationSetValue(AbstractDomainFieldHandlerImpl var1, ValueHandler var2, Operation var3);

        public String handler();

        public void objectSetValue(AbstractDomainFieldHandlerImpl var1, ResultData var2, ValueHandler var3);

        public void objectSetValue(AbstractDomainFieldHandlerImpl var1, Object var2, ValueHandler var3);

        public void operationSetBounds(AbstractDomainFieldHandlerImpl var1, Object var2, IndexScanOperation.BoundType var3, IndexScanOperation var4);

        public void filterCompareValue(AbstractDomainFieldHandlerImpl var1, Object var2, ScanFilter.BinaryCondition var3, ScanFilter var4);

        public void operationEqual(AbstractDomainFieldHandlerImpl var1, Object var2, Operation var3);

        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl var1, boolean var2);

        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl var1, PartitionKey var2, ValueHandler var3);
    }
}

