/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.ResultDataImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import java.util.List;

class ScanResultDataImpl
extends ResultDataImpl {
    static final I18NHelper local = I18NHelper.getInstance(ScanResultDataImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ScanResultDataImpl.class);
    private NdbScanOperation ndbScanOperation = null;
    private ClusterTransactionImpl clusterTransaction = null;
    protected long skip = 0L;
    protected long limit = Long.MAX_VALUE;
    protected long recordCounter = 0L;
    boolean recordsLocked = false;
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;

    public ScanResultDataImpl(ClusterTransactionImpl clusterTransactionImpl, NdbScanOperation ndbScanOperation, List<Column> list, int n, int n2, int[] nArray, int[] nArray2, int n3, DbImpl.BufferManager bufferManager, long l, long l2) {
        super(ndbScanOperation, list, n, n2, nArray, nArray2, bufferManager, false);
        this.clusterTransaction = clusterTransactionImpl;
        this.ndbScanOperation = ndbScanOperation;
        this.skip = l;
        this.limit = l2;
    }

    private void executeIfRecordsLocked() {
        if (this.recordsLocked) {
            this.clusterTransaction.executeNoCommit(true, true);
            this.recordsLocked = false;
        }
    }

    @Override
    public boolean next() {
        if (this.recordCounter >= this.limit) {
            this.executeIfRecordsLocked();
            this.ndbScanOperation.close(true, true);
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        block5: while (!bl) {
            int n = this.ndbScanOperation.nextResult(bl2, bl3);
            switch (n) {
                case 0: {
                    if (++this.recordCounter <= this.skip) continue block5;
                    if (this.ndbScanOperation.getLockMode() != 2) {
                        this.ndbScanOperation.lockCurrentTuple();
                        this.recordsLocked = true;
                    }
                    return true;
                }
                case 1: {
                    this.executeIfRecordsLocked();
                    this.ndbScanOperation.close(true, true);
                    return false;
                }
                case 2: {
                    this.executeIfRecordsLocked();
                    bl2 = true;
                    continue block5;
                }
            }
            Utility.throwError(n, this.ndbScanOperation.getNdbError());
        }
        return true;
    }
}

