/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.metadata.IndexHandlerImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDomainTypeHandlerImpl<T>
implements DomainTypeHandler<T> {
    protected static final I18NHelper local = I18NHelper.getInstance(AbstractDomainTypeHandlerImpl.class);
    protected static final Logger logger = LoggerFactoryService.getFactory().getInstance(AbstractDomainTypeHandlerImpl.class);
    protected String name;
    protected String tableName;
    protected String tableKey;
    protected Table table;
    protected int numberOfIdFields;
    protected int[] idFieldNumbers;
    protected DomainFieldHandler[] idFieldHandlers;
    protected DomainFieldHandler[] fieldHandlers;
    protected String[] primaryKeyColumnNames;
    protected int numberOfPartitionKeyColumns = 0;
    protected DomainFieldHandler[] partitionKeyFieldHandlers;
    protected String[] partitionKeyColumnNames;
    protected int numberOfFields = 0;
    protected List<DomainFieldHandler> persistentFieldHandlers = new ArrayList<DomainFieldHandler>();
    protected List<DomainFieldHandler> nonPKFieldHandlers = new ArrayList<DomainFieldHandler>();
    protected List<DomainFieldHandler> primitiveFieldHandlers = new ArrayList<DomainFieldHandler>();
    protected Map<String, Integer> fieldNameToNumber = new HashMap<String, Integer>();
    protected String[] fieldNames;
    protected List<IndexHandlerImpl> indexHandlerImpls = new ArrayList<IndexHandlerImpl>();
    protected Set<String> indexNames = new HashSet<String>();
    private StringBuilder reasons = null;

    public void registerPrimaryKeyColumn(DomainFieldHandler domainFieldHandler, String string) {
        int n;
        for (n = 0; n < this.primaryKeyColumnNames.length; ++n) {
            if (!this.primaryKeyColumnNames[n].equals(string)) continue;
            this.idFieldHandlers[n] = domainFieldHandler;
            this.idFieldNumbers[n] = domainFieldHandler.getFieldNumber();
            if (!logger.isDetailEnabled()) continue;
            logger.detail("registerPrimaryKeyColumn registered primary key " + string);
        }
        for (n = 0; n < this.partitionKeyColumnNames.length; ++n) {
            if (!this.partitionKeyColumnNames[n].equals(string)) continue;
            this.partitionKeyFieldHandlers[n] = domainFieldHandler;
            if (!logger.isDetailEnabled()) continue;
            logger.detail("registerPrimaryKeyColumn registered partition key " + string);
        }
    }

    public int[][] registerIndices(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 0; i < this.indexHandlerImpls.size(); ++i) {
            IndexHandlerImpl indexHandlerImpl = this.indexHandlerImpls.get(i);
            String[] stringArray = indexHandlerImpl.getColumnNames();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!abstractDomainFieldHandlerImpl.getColumnName().equals(stringArray[j])) continue;
                if (logger.isDetailEnabled()) {
                    logger.detail("Found field " + abstractDomainFieldHandlerImpl.getName() + " column " + abstractDomainFieldHandlerImpl.getColumnName() + " matching " + indexHandlerImpl.getIndexName());
                }
                indexHandlerImpl.setDomainFieldHandlerFor(j, abstractDomainFieldHandlerImpl);
                arrayList.add(new int[]{i, j});
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found " + arrayList.size() + " indexes for " + string);
        }
        return (int[][])arrayList.toArray((T[])new int[arrayList.size()][]);
    }

    public Set<String> getIndexNames(int[][] nArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int[] nArray2 : nArray) {
            hashSet.add(this.indexHandlerImpls.get(nArray2[0]).getIndexName());
        }
        return hashSet;
    }

    protected String[] getColumnNames(String string, Column[] columnArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Column column : columnArray) {
            String string2 = column.getName();
            if (hashSet.contains(string2)) {
                throw new ClusterJUserException(local.message("ERR_Duplicate_Column", this.name, string, string2));
            }
            hashSet.add(string2);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public CandidateIndexImpl[] createCandidateIndexes() {
        CandidateIndexImpl[] candidateIndexImplArray = new CandidateIndexImpl[this.indexHandlerImpls.size()];
        int n = 0;
        for (IndexHandlerImpl indexHandlerImpl : this.indexHandlerImpls) {
            candidateIndexImplArray[n++] = indexHandlerImpl.toCandidateIndexImpl();
        }
        return candidateIndexImplArray;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public int getNumberOfFields() {
        return this.numberOfFields;
    }

    public DomainFieldHandler[] getIdFieldHandlers() {
        return this.idFieldHandlers;
    }

    public DomainFieldHandler[] getFieldHandlers() {
        return this.fieldHandlers;
    }

    @Override
    public DomainFieldHandler getFieldHandler(String string) {
        for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
            if (!domainFieldHandler.getName().equals(string)) continue;
            return domainFieldHandler;
        }
        throw new ClusterJUserException(local.message("ERR_Not_A_Member", (Object)string, (Object)this.name));
    }

    public int getFieldNumber(String string) {
        Integer n = this.fieldNameToNumber.get(string);
        if (n == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_No_Field_Number", (Object)string, (Object)this.name));
        }
        return n;
    }

    @Override
    public void operationSetNonPKValues(ValueHandler valueHandler, Operation operation) {
        for (DomainFieldHandler domainFieldHandler : this.nonPKFieldHandlers) {
            if (!valueHandler.isModified(domainFieldHandler.getFieldNumber())) continue;
            domainFieldHandler.operationSetValue(valueHandler, operation);
        }
    }

    @Override
    public void operationSetValues(ValueHandler valueHandler, Operation operation) {
        for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
            if (logger.isDetailEnabled()) {
                logger.detail("operationSetValues field: " + domainFieldHandler.getName());
            }
            domainFieldHandler.operationSetValue(valueHandler, operation);
        }
    }

    @Override
    public void operationSetModifiedNonPKValues(ValueHandler valueHandler, Operation operation) {
        for (DomainFieldHandler domainFieldHandler : this.nonPKFieldHandlers) {
            domainFieldHandler.operationSetModifiedValue(valueHandler, operation);
        }
    }

    @Override
    public void operationSetModifiedValues(ValueHandler valueHandler, Operation operation) {
        for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
            domainFieldHandler.operationSetModifiedValue(valueHandler, operation);
        }
    }

    @Override
    public void operationSetKeys(ValueHandler valueHandler, Operation operation) {
        for (DomainFieldHandler domainFieldHandler : this.idFieldHandlers) {
            domainFieldHandler.operationSetValue(valueHandler, operation);
        }
    }

    @Override
    public void operationGetValues(Operation operation) {
        for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
            domainFieldHandler.operationGetValue(operation);
        }
    }

    @Override
    public void operationGetValues(Operation operation, BitSet bitSet) {
        if (bitSet == null) {
            this.operationGetValues(operation);
        } else {
            int n = 0;
            for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
                if (!bitSet.get(n++)) continue;
                domainFieldHandler.operationGetValue(operation);
            }
        }
    }

    public void operationGetValuesExcept(IndexOperation indexOperation, String string) {
        for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
            if (domainFieldHandler.includedInIndex(string)) continue;
            if (logger.isDetailEnabled()) {
                logger.detail("operationGetValuesExcept index: " + string);
            }
            domainFieldHandler.operationGetValue(indexOperation);
        }
    }

    @Override
    public void objectSetValues(ResultData resultData, ValueHandler valueHandler) {
        for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
            domainFieldHandler.objectSetValue(resultData, valueHandler);
        }
    }

    public void objectSetValuesExcept(ResultData resultData, ValueHandler valueHandler, String string) {
        for (DomainFieldHandler domainFieldHandler : this.persistentFieldHandlers) {
            domainFieldHandler.objectSetValueExceptIndex(resultData, valueHandler, string);
        }
    }

    protected Table getTable(Dictionary dictionary) {
        Table table;
        try {
            table = dictionary.getTable(this.tableName);
        }
        catch (Exception exception) {
            if (!(exception instanceof ClusterJException)) {
                throw new ClusterJException(local.message("ERR_Get_NdbTable", (Object)this.name, (Object)this.tableName), exception);
            }
            throw exception;
        }
        return table;
    }

    @Override
    public int[] getKeyFieldNumbers() {
        return this.idFieldNumbers;
    }

    @Override
    public Table getStoreTable() {
        return this.table;
    }

    @Override
    public PartitionKey createPartitionKey(ValueHandler valueHandler) {
        PartitionKey partitionKey = this.table.createPartitionKey();
        for (DomainFieldHandler domainFieldHandler : this.partitionKeyFieldHandlers) {
            if (logger.isDetailEnabled()) {
                logger.detail("Field number " + domainFieldHandler.getFieldNumber() + " column name " + domainFieldHandler.getName() + " field name " + domainFieldHandler.getName());
            }
            domainFieldHandler.partitionKeySetPart(partitionKey, valueHandler);
        }
        return partitionKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<String> getColumnNames(BitSet bitSet) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public Set<Column> getStoreColumns(BitSet bitSet) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public ValueHandler createKeyValueHandler(Object object, Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public Class<?> getOidClass() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public Class<?>[] getProxyInterfaces() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public ValueHandler getValueHandler(Object object) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public boolean isSupportedType() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T newInstance(Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T newInstance(ResultData resultData, Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectMarkModified(ValueHandler valueHandler, String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectResetModified(ValueHandler valueHandler) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectSetCacheManager(CacheManager cacheManager, Object object) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    protected String removeUniqueSuffix(String string) {
        int n = string.lastIndexOf("$unique");
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setUnsupported(String string) {
        if (this.reasons == null) {
            this.reasons = new StringBuilder();
        }
        this.reasons.append(string);
    }

    public String getUnsupported() {
        return this.reasons == null ? null : this.reasons.toString();
    }

    @Override
    public T newInstance(ValueHandler valueHandler) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }
}

