/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.ClusterConnection;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.DbImplForNdbRecord;
import com.mysql.clusterj.tie.FixedByteBufferPoolImpl;
import com.mysql.clusterj.tie.NdbRecordImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.NdbRecordSmartValueHandlerFactoryImpl;
import com.mysql.clusterj.tie.VariableByteBufferPoolImpl;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.Ndb_cluster_connection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClusterConnectionImpl
implements ClusterConnection {
    static final I18NHelper local = I18NHelper.getInstance(ClusterConnectionImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ClusterConnectionImpl.class);
    protected Ndb_cluster_connection clusterConnection;
    final String connectString;
    int nodeId;
    final int connectTimeoutMgm;
    private Map<DbImpl, Object> dbs = Collections.synchronizedMap(new IdentityHashMap());
    DbImplForNdbRecord defaultDbForNdbRecord;
    private ConcurrentMap<String, DbImplForNdbRecord> databaseForNdbRecord = new ConcurrentHashMap<String, DbImplForNdbRecord>();
    private ConcurrentMap<String, NdbRecordImpl> ndbRecordImplMap = new ConcurrentHashMap<String, NdbRecordImpl>();
    private int[] byteBufferPoolSizes;
    protected VariableByteBufferPoolImpl byteBufferPool;
    private int errorBufferSize = 300;
    protected FixedByteBufferPoolImpl byteBufferPoolForDBImplError;
    private static final int PARTITION_KEY_BUFFER_SIZE = 10000;
    protected FixedByteBufferPoolImpl byteBufferPoolForPartitionKey;
    NdbDictionary.Dictionary dictionaryForNdbRecord = null;
    private ConcurrentMap<String, NdbDictionary.Dictionary> dbDictionaryForNdbRecord = new ConcurrentHashMap<String, NdbDictionary.Dictionary>();
    private boolean isClosing = false;
    private long[] autoIncrement;
    private static final String USE_SMART_VALUE_HANDLER_NAME = "com.mysql.clusterj.UseSmartValueHandler";
    private static final boolean USE_SMART_VALUE_HANDLER = ClusterJHelper.getBooleanProperty("com.mysql.clusterj.UseSmartValueHandler", "true");
    protected static boolean queryObjectsInitialized = false;

    public ClusterConnectionImpl(String string, int n, int n2) {
        this.connectString = string;
        this.nodeId = n;
        this.connectTimeoutMgm = n2;
        this.byteBufferPoolForDBImplError = new FixedByteBufferPoolImpl(this.errorBufferSize, "DBImplErrorBufferPool");
        this.byteBufferPoolForPartitionKey = new FixedByteBufferPoolImpl(10000, "PartitionKeyBufferPool");
        this.clusterConnection = Ndb_cluster_connection.create(string, n);
        ClusterConnectionImpl.handleError(this.clusterConnection, string, n);
        int n3 = this.clusterConnection.set_timeout(n2);
        ClusterConnectionImpl.handleError(n3, string, n, n2);
        logger.info(local.message("INFO_Create_Cluster_Connection", string, n, n2));
    }

    @Override
    public void connect(int n, int n2, boolean bl) {
        this.byteBufferPool = new VariableByteBufferPoolImpl(this.byteBufferPoolSizes);
        this.checkConnection();
        int n3 = this.clusterConnection.connect(n, n2, bl ? 1 : 0);
        ClusterConnectionImpl.handleError(n3, this.clusterConnection, this.connectString, this.nodeId);
        this.nodeId = this.clusterConnection.node_id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Db createDb(String string, boolean bl, int n) {
        this.checkConnection();
        Ndb ndb = null;
        Object object = this;
        synchronized (object) {
            ndb = Ndb.create(this.clusterConnection, string, "def");
            ClusterConnectionImpl.handleError(ndb, this.clusterConnection, this.connectString, this.nodeId);
            if (bl) {
                if (this.dictionaryForNdbRecord == null) {
                    Ndb ndb2 = Ndb.create(this.clusterConnection, string, "def");
                    ClusterConnectionImpl.handleError(ndb2, this.clusterConnection, this.connectString, this.nodeId);
                    this.defaultDbForNdbRecord = new DbImplForNdbRecord(this, ndb2, string, bl);
                    this.defaultDbForNdbRecord.initializeQueryObjects();
                    this.dictionaryForNdbRecord = this.defaultDbForNdbRecord.getNdbDictionary();
                }
            } else {
                NdbDictionary.Dictionary dictionary = (NdbDictionary.Dictionary)this.dbDictionaryForNdbRecord.get(string);
                if (dictionary == null) {
                    Ndb ndb3 = Ndb.create(this.clusterConnection, string, "def");
                    ClusterConnectionImpl.handleError(ndb3, this.clusterConnection, this.connectString, this.nodeId);
                    DbImplForNdbRecord dbImplForNdbRecord = new DbImplForNdbRecord(this, ndb3, string, bl);
                    dbImplForNdbRecord.initializeQueryObjects();
                    dictionary = dbImplForNdbRecord.getNdbDictionary();
                    this.dbDictionaryForNdbRecord.put(string, dictionary);
                    this.databaseForNdbRecord.put(string, dbImplForNdbRecord);
                }
            }
        }
        object = new DbImpl(this, ndb, n, string, bl);
        ((DbImpl)object).initializeAutoIncrement(this.autoIncrement);
        this.dbs.put((DbImpl)object, null);
        return object;
    }

    @Override
    public void configureTls(String string, int n) {
        if (string == null) {
            string = "";
        }
        this.clusterConnection.configure_tls(string, n);
    }

    @Override
    public void waitUntilReady(int n, int n2) {
        this.checkConnection();
        int n3 = this.clusterConnection.wait_until_ready(n, n2);
        ClusterConnectionImpl.handleError(n3, this.clusterConnection, this.connectString, this.nodeId);
    }

    private void checkConnection() {
        if (this.clusterConnection == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Cluster_Connection_Must_Not_Be_Null"));
        }
    }

    protected static void handleError(int n, String string, int n2, int n3) {
        if (n != 0) {
            String string2 = local.message("ERR_Set_Timeout_Mgm", string, n2, n3, n);
            logger.error(string2);
            throw new ClusterJDatastoreException(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleError(int n, Ndb_cluster_connection ndb_cluster_connection, String string, int n2) {
        if (n >= 0) {
            return;
        }
        try {
            ClusterConnectionImpl.throwError(n, ndb_cluster_connection, string, n2);
        }
        finally {
            Ndb_cluster_connection.delete(ndb_cluster_connection);
        }
    }

    protected static void handleError(Object object, Ndb_cluster_connection ndb_cluster_connection, String string, int n) {
        if (object != null) {
            return;
        }
        ClusterConnectionImpl.throwError(null, ndb_cluster_connection, string, n);
    }

    protected static void handleError(Ndb_cluster_connection ndb_cluster_connection, String string, int n) {
        if (ndb_cluster_connection == null) {
            String string2 = local.message("ERR_Connect", (Object)string, (Object)n);
            logger.error(string2);
            throw new ClusterJDatastoreException(string2);
        }
    }

    protected static void throwError(Object object, Ndb_cluster_connection ndb_cluster_connection, String string, int n) {
        String string2 = ndb_cluster_connection.get_latest_error_msg();
        int n2 = ndb_cluster_connection.get_latest_error();
        String string3 = local.message("ERR_NdbError", object, n2, string2, string, n);
        throw new ClusterJDatastoreException(string3);
    }

    @Override
    public void closing() {
        this.isClosing = true;
        if (this.clusterConnection != null) {
            logger.info(local.message("INFO_Close_Cluster_Connection", (Object)this.connectString, (Object)this.nodeId));
            if (this.dbs.size() > 0) {
                for (DbImpl object : this.dbs.keySet()) {
                    object.closing();
                }
            }
            if (this.defaultDbForNdbRecord != null) {
                this.defaultDbForNdbRecord.closing();
            }
            for (Map.Entry entry : this.databaseForNdbRecord.entrySet()) {
                DbImplForNdbRecord dbImplForNdbRecord = (DbImplForNdbRecord)entry.getValue();
                dbImplForNdbRecord.closing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.clusterConnection != null) {
            Object object2;
            Iterator iterator;
            if (!this.isClosing) {
                this.closing();
                this.sleep(1000L);
            }
            if (this.dbs.size() != 0) {
                iterator = new IdentityHashMap<DbImpl, Object>(this.dbs);
                for (Db db : iterator.keySet()) {
                    db.close();
                }
            }
            for (Object object2 : this.ndbRecordImplMap.values()) {
                ((NdbRecordImpl)object2).releaseNdbRecord();
            }
            if (this.defaultDbForNdbRecord != null) {
                this.defaultDbForNdbRecord.close();
                this.defaultDbForNdbRecord = null;
            }
            iterator = this.databaseForNdbRecord.entrySet().iterator();
            while (iterator.hasNext()) {
                Db db;
                object2 = iterator.next();
                db = (DbImplForNdbRecord)object2.getValue();
                ((DbImplForNdbRecord)db).close();
                iterator.remove();
            }
            this.databaseForNdbRecord.clear();
            this.ndbRecordImplMap.clear();
            object2 = this;
            synchronized (object2) {
                Ndb_cluster_connection.delete(this.clusterConnection);
                this.clusterConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(NdbRecordImpl ndbRecordImpl) {
        ClusterConnectionImpl clusterConnectionImpl = this;
        synchronized (clusterConnectionImpl) {
            if (this.clusterConnection != null) {
                ndbRecordImpl.releaseNdbRecord();
            }
        }
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public void close(Db db) {
        this.dbs.remove(db);
    }

    @Override
    public int dbCount() {
        return this.dbs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NdbRecordImpl getCachedNdbRecordImpl(DbImpl dbImpl, Table table) {
        NdbRecordImpl ndbRecordImpl;
        this.defaultDbForNdbRecord.assertNotClosed("ClusterConnectionImpl.getCachedNdbRecordImpl for table");
        String string = dbImpl.getName() + "+" + table.getKey();
        NdbRecordImpl ndbRecordImpl2 = (NdbRecordImpl)this.ndbRecordImplMap.get(string);
        if (ndbRecordImpl2 != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl found for " + string);
            }
            return ndbRecordImpl2;
        }
        ClusterConnectionImpl clusterConnectionImpl = this;
        synchronized (clusterConnectionImpl) {
            ndbRecordImpl2 = (NdbRecordImpl)this.ndbRecordImplMap.get(string);
            if (ndbRecordImpl2 != null) {
                return ndbRecordImpl2;
            }
            NdbDictionary.Dictionary dictionary = this.dictionaryForNdbRecord;
            if (!dbImpl.isDefaultDatabase()) {
                dictionary = (NdbDictionary.Dictionary)this.dbDictionaryForNdbRecord.get(dbImpl.getName());
            }
            ndbRecordImpl = new NdbRecordImpl(table, dictionary, this);
            this.ndbRecordImplMap.put(string, ndbRecordImpl);
        }
        return ndbRecordImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NdbRecordImpl getCachedNdbRecordImpl(DbImpl dbImpl, Index index, Table table) {
        NdbRecordImpl ndbRecordImpl;
        this.defaultDbForNdbRecord.assertNotClosed("ClusterConnectionImpl.getCachedNdbRecordImpl for index");
        String string = dbImpl.getName() + "+" + table.getName() + "+" + index.getInternalName();
        NdbRecordImpl ndbRecordImpl2 = (NdbRecordImpl)this.ndbRecordImplMap.get(string);
        if (ndbRecordImpl2 != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl found for " + string);
            }
            return ndbRecordImpl2;
        }
        ClusterConnectionImpl clusterConnectionImpl = this;
        synchronized (clusterConnectionImpl) {
            ndbRecordImpl2 = (NdbRecordImpl)this.ndbRecordImplMap.get(string);
            if (ndbRecordImpl2 != null) {
                return ndbRecordImpl2;
            }
            NdbDictionary.Dictionary dictionary = this.dictionaryForNdbRecord;
            if (!dbImpl.isDefaultDatabase()) {
                dictionary = (NdbDictionary.Dictionary)this.dbDictionaryForNdbRecord.get(dbImpl.getName());
            }
            ndbRecordImpl = new NdbRecordImpl(index, table, dictionary, this);
            this.ndbRecordImplMap.put(string, ndbRecordImpl);
        }
        return ndbRecordImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadSchema(String string, String string2, boolean bl) {
        boolean bl2 = false;
        ConcurrentMap<String, NdbRecordImpl> concurrentMap = this.ndbRecordImplMap;
        synchronized (concurrentMap) {
            NdbDictionary.Dictionary dictionary = this.dictionaryForNdbRecord;
            if (!bl) {
                dictionary = (NdbDictionary.Dictionary)this.dbDictionaryForNdbRecord.get(string);
                assert (dictionary != null);
            }
            Iterator iterator = this.ndbRecordImplMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string3;
                Map.Entry entry = iterator.next();
                String string4 = (String)entry.getKey();
                if (!string4.startsWith(string3 = string + "+" + string2)) continue;
                bl2 = true;
                String[] stringArray = string4.split("\\+");
                if (stringArray.length > 2) {
                    object = stringArray[2];
                    if (logger.isDebugEnabled()) {
                        logger.debug("Removing dictionary entry for cached index db:" + string + " " + string2 + " " + (String)object);
                    }
                    dictionary.invalidateIndex((String)object, string2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing cached NdbRecord for " + string4);
                }
                object = (NdbRecordImpl)entry.getValue();
                iterator.remove();
            }
            if (bl2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing dictionary entry for cached table db:" + string + " " + string2);
                }
                dictionary.invalidateTable(string2);
            }
        }
    }

    @Override
    public ValueHandlerFactory getSmartValueHandlerFactory() {
        NdbRecordSmartValueHandlerFactoryImpl ndbRecordSmartValueHandlerFactoryImpl = null;
        if (USE_SMART_VALUE_HANDLER) {
            ndbRecordSmartValueHandlerFactoryImpl = new NdbRecordSmartValueHandlerFactoryImpl();
        }
        return ndbRecordSmartValueHandlerFactoryImpl;
    }

    public NdbRecordOperationImpl newNdbRecordOperationImpl(DbImpl dbImpl, Table table) {
        return new NdbRecordOperationImpl(this, dbImpl, table);
    }

    @Override
    public void initializeAutoIncrement(long[] lArray) {
        this.autoIncrement = lArray;
    }

    public VariableByteBufferPoolImpl getByteBufferPool() {
        return this.byteBufferPool;
    }

    @Override
    public void setByteBufferPoolSizes(int[] nArray) {
        this.byteBufferPoolSizes = nArray;
    }

    @Override
    public void setRecvThreadCPUid(short s) {
        int n = 0;
        if (s < 0) {
            throw new ClusterJUserException(local.message("ERR_Invalid_CPU_Id", s));
        }
        n = this.clusterConnection.set_recv_thread_cpu(s);
        if (n != 0) {
            switch (n) {
                case 22: 
                case 31994: {
                    throw new ClusterJUserException(local.message("ERR_Invalid_CPU_Id", s));
                }
                case 31999: {
                    throw new ClusterJFatalUserException(local.message("ERR_Bind_CPU_Not_Supported"));
                }
            }
            throw new ClusterJFatalInternalException(local.message("ERR_Binding_Recv_Thread_To_CPU", (Object)s, (Object)n));
        }
    }

    @Override
    public void unsetRecvThreadCPUid() {
        int n = this.clusterConnection.unset_recv_thread_cpu();
        if (n == 31999) {
            throw new ClusterJFatalUserException(local.message("ERR_Bind_CPU_Not_Supported"));
        }
        if (n != 0) {
            throw new ClusterJFatalInternalException(local.message("ERR_Unbinding_Recv_Thread_From_CPU", n));
        }
    }

    @Override
    public void setRecvThreadActivationThreshold(int n) {
        if (this.clusterConnection.set_recv_thread_activation_threshold(n) == -1) {
            throw new ClusterJFatalInternalException(local.message("ERR_Setting_Activation_Threshold"));
        }
    }
}

