/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;

class VariableByteBufferPoolImpl {
    static final I18NHelper local = I18NHelper.getInstance(VariableByteBufferPoolImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(VariableByteBufferPoolImpl.class);
    final TreeMap<Integer, ConcurrentLinkedQueue<ByteBuffer>> queues = new TreeMap();
    int biggest = 0;
    static ByteBufferCleaner theByteBufferCleaner = null;
    static byte[] guard;

    static void clean(ByteBuffer byteBuffer) {
        if (theByteBufferCleaner != null) {
            theByteBufferCleaner.clean(byteBuffer);
        }
    }

    void initializeGuard(ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.capacity() - guard.length);
        byteBuffer.put(guard);
        byteBuffer.position(0);
    }

    void checkGuard(ByteBuffer byteBuffer) {
        if (byteBuffer.limit() == 0) {
            return;
        }
        byteBuffer.limit(byteBuffer.capacity());
        byteBuffer.position(byteBuffer.capacity() - guard.length);
        for (int i = 0; i < guard.length; ++i) {
            if (byteBuffer.get() == guard[i]) continue;
            throw new RuntimeException("ByteBufferPool failed guard test with buffer of length " + (byteBuffer.capacity() - guard.length) + ": " + byteBuffer.toString());
        }
    }

    public VariableByteBufferPoolImpl(int[] nArray) {
        for (int n : nArray) {
            this.queues.put(n, new ConcurrentLinkedQueue());
            if (this.biggest >= n) continue;
            this.biggest = n;
        }
        logger.info(local.message("MSG_ByteBuffer_Pools_Initialized", (Object)Arrays.toString(nArray)));
    }

    public ByteBuffer borrowBuffer(int n) {
        Map.Entry<Integer, ConcurrentLinkedQueue<ByteBuffer>> entry = this.queues.ceilingEntry(n);
        ByteBuffer byteBuffer = null;
        if (entry == null) {
            if (logger.isDetailEnabled()) {
                logger.warn(local.message("MSG_Cannot_allocate_byte_buffer_from_pool", (Object)n, (Object)this.biggest));
            }
            byteBuffer = ByteBuffer.allocateDirect(n + guard.length);
            this.initializeGuard(byteBuffer);
            return byteBuffer;
        }
        ConcurrentLinkedQueue<ByteBuffer> concurrentLinkedQueue = entry.getValue();
        int n2 = entry.getKey();
        byteBuffer = concurrentLinkedQueue.poll();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocateDirect(n2 + guard.length);
            this.initializeGuard(byteBuffer);
        }
        byteBuffer.limit(n);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public void returnBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.capacity() - guard.length;
        if (n > this.biggest) {
            byteBuffer.limit(0);
            VariableByteBufferPoolImpl.clean(byteBuffer);
        } else {
            try {
                this.queues.get(n).add(byteBuffer);
            }
            catch (NullPointerException nullPointerException) {
                throw new ClusterJFatalInternalException(nullPointerException);
            }
        }
    }

    static {
        Cleaner0 cleaner0 = null;
        try {
            cleaner0 = new SunMiscCleaner();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        if (cleaner0 == null) {
            try {
                cleaner0 = new SunMiscUnsafeCleaner();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (cleaner0 == null) {
            try {
                cleaner0 = new JavaInternalRefCleaner();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        try {
            ((Cleaner0)cleaner0).test();
        }
        catch (Throwable throwable) {
            logger.warn(local.message("WARN_Buffer_Cleaning_Unusable", (Object)throwable.getClass().getName(), (Object)throwable.getMessage()));
        }
        theByteBufferCleaner = cleaner0;
        guard = new byte[0];
        for (int i = 0; i < guard.length; ++i) {
            VariableByteBufferPoolImpl.guard[i] = 10;
        }
    }

    static class SunMiscUnsafeCleaner
    extends Cleaner0 {
        protected Object obj = null;

        SunMiscUnsafeCleaner() throws ReflectiveOperationException {
            this.implClass = Class.forName("sun.misc.Unsafe");
            Field field = this.implClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            this.obj = field.get(null);
            this.cleanerMethod = this.implClass.getMethod("invokeCleaner", ByteBuffer.class);
        }

        @Override
        void test() throws ReflectiveOperationException {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
            this.invoke(byteBuffer);
        }

        @Override
        void invoke(ByteBuffer byteBuffer) throws ReflectiveOperationException {
            this.cleanerMethod.invoke(this.obj, byteBuffer);
        }
    }

    static class JavaInternalRefCleaner
    extends Cleaner1 {
        JavaInternalRefCleaner() throws ReflectiveOperationException {
            this.implClass = Class.forName("java.internal.ref.Cleaner");
            this.cleanerMethod = this.implClass.getMethod("clean", new Class[0]);
            logger.debug("Using JavaInternalRefCleaner (some Java 9 releases)");
        }
    }

    static class SunMiscCleaner
    extends Cleaner1 {
        SunMiscCleaner() throws ReflectiveOperationException {
            this.implClass = Class.forName("sun.misc.cleaner");
            this.cleanerMethod = this.implClass.getMethod("clean", new Class[0]);
            logger.debug("Using SunMiscCleaner (Java 8 and earlier)");
        }
    }

    static abstract class Cleaner1
    extends Cleaner0 {
        private Field cleanerField = null;

        Cleaner1() {
        }

        @Override
        void test() throws ReflectiveOperationException {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
            this.cleanerField = byteBuffer.getClass().getDeclaredField("cleaner");
            this.cleanerField.setAccessible(true);
            this.invoke(byteBuffer);
        }

        @Override
        void invoke(ByteBuffer byteBuffer) throws ReflectiveOperationException {
            this.cleanerMethod.invoke(this.implClass.cast(this.cleanerField.get(byteBuffer)), new Object[0]);
        }
    }

    static abstract class Cleaner0
    implements ByteBufferCleaner {
        protected Class<?> implClass = null;
        protected Method cleanerMethod = null;

        Cleaner0() {
        }

        abstract void test() throws ReflectiveOperationException;

        abstract void invoke(ByteBuffer var1) throws ReflectiveOperationException;

        @Override
        public void clean(ByteBuffer byteBuffer) {
            try {
                this.invoke(byteBuffer);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    static interface ByteBufferCleaner {
        public void clean(ByteBuffer var1);
    }
}

