/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.osgi;

import com.predic8.membrane.core.ClassloaderUtil;
import com.predic8.membrane.core.MembraneCommandLine;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.osgi.logger.MembraneLogListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class CoreActivator
extends Plugin {
    public static final String PLUGIN_ID = "com.predic8.membrane.core";
    private static Log log = LogFactory.getLog((String)CoreActivator.class.getName());
    private Router router;
    private ServiceRegistration<?> sr;
    private ILogListener logListener = new MembraneLogListener();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (new File("configuration/log4j.properties").exists()) {
            PropertyConfigurator.configure((String)"configuration/log4j.properties");
        }
        Platform.addLogListener((ILogListener)this.logListener);
        MembraneCommandLine cl = new MembraneCommandLine();
        cl.parse(this.fixArguments(Platform.getCommandLineArgs()));
        if (cl.hasConfiguration()) {
            log.info((Object)("loading monitor beans from command line argument: " + this.getConfigurationFileName(cl)));
            this.router = Router.init((String)this.getConfigurationFileName(cl), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        } else {
            try {
                if (ClassloaderUtil.fileExists((String)this.getConfigurationFileName())) {
                    log.info((Object)("Eclipse framework found config file: " + this.getConfigurationFileName()));
                    this.readBeanConfigWhenStartedAsProduct();
                } else {
                    this.readBeanConfigWhenStartedInEclipse();
                }
            }
            catch (Exception e1) {
                log.error((Object)("Unable to read bean configuration file: " + e1.getMessage()));
                log.error((Object)("Unable to read bean configuration file: " + e1.getStackTrace()));
                e1.printStackTrace();
            }
        }
        this.sr = context.registerService(this.router.getClass().getName(), (Object)this.router, null);
    }

    private String[] fixArguments(String[] args) {
        int i = ArrayUtils.indexOf((Object[])args, (Object)"-product");
        if (i == -1) {
            return args;
        }
        return (String[])ArrayUtils.remove((Object[])ArrayUtils.remove((Object[])args, (int)i), (int)i);
    }

    private String getConfigurationFileName(MembraneCommandLine cl) {
        if (cl.hasConfiguration()) {
            log.info((Object)("loading configuration from command line argument: " + cl.getConfiguration()));
            return new File(cl.getConfiguration()).getAbsolutePath();
        }
        return System.getProperty("user.home") + System.getProperty("file.separator") + ".membrane.xml";
    }

    private void readBeanConfigWhenStartedAsProduct() throws Exception {
        log.info((Object)("Reading router configuration from " + this.getConfigurationFileName()));
        log.info((Object)("Project root: " + this.getProjectRoot()));
        URLClassLoader externalClassloader = ClassloaderUtil.getExternalClassloader((String)this.getProjectRoot());
        Thread.currentThread().setContextClassLoader(externalClassloader);
        this.router = Router.init((String)this.getConfigurationFileName(), (ClassLoader)externalClassloader);
        log.info((Object)("Router instance: " + this.router));
    }

    private void readBeanConfigWhenStartedInEclipse() throws MalformedURLException {
        log.info((Object)"Reading configuration from configuration/proxies.xml");
        String membraneHome = System.getenv("MEMBRANE_HOME");
        if (membraneHome == null) {
            throw new IllegalStateException("MEMBRANE_HOME not set");
        }
        this.router = Router.init((String)("file:" + membraneHome + System.getProperty("file.separator") + "configuration" + System.getProperty("file.separator") + "proxies.xml"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    private String getConfigurationFileName() throws IOException {
        return this.getProjectRoot() + System.getProperty("file.separator") + "configuration" + System.getProperty("file.separator") + "proxies.xml";
    }

    private String getProjectRoot() throws IOException {
        return new File(FileLocator.resolve((URL)this.getBundle().getEntry("/")).getPath()).getParentFile().getParentFile().getPath();
    }

    public void stop(BundleContext context) throws Exception {
        this.sr.unregister();
        Platform.removeLogListener((ILogListener)this.logListener);
        this.router.stop();
        this.logListener = null;
        super.stop(context);
    }
}

