/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.ErasureCode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XORCode
extends ErasureCode {
    public static final Log LOG = LogFactory.getLog(XORCode.class);
    private int stripeSize;
    private int paritySize;
    private int[] dataBuff;

    @Deprecated
    public XORCode(int stripeSize, int paritySize) {
        this.init(stripeSize, paritySize);
    }

    public XORCode() {
    }

    public void init(Codec codec) {
        this.init(codec.stripeLength, codec.parityLength);
        LOG.info((Object)("Initialized " + XORCode.class + " stripeLength:" + codec.stripeLength + " parityLength:" + codec.parityLength));
    }

    private void init(int stripeSize, int paritySize) {
        assert (paritySize == 1);
        this.stripeSize = stripeSize;
        this.paritySize = paritySize;
        this.dataBuff = new int[paritySize + stripeSize];
    }

    public void encode(int[] message, int[] parity) {
        assert (message.length == this.stripeSize && parity.length == 1);
        boolean val = false;
        parity[0] = message[0];
        for (int i = 1; i < message.length; ++i) {
            parity[0] = parity[0] ^ message[i];
        }
    }

    public void decode(int[] data, int[] erasedLocation, int[] erasedValue) {
        if (erasedLocation.length != 1) {
            return;
        }
        assert (erasedLocation.length == erasedValue.length);
        int skipIndex = erasedLocation[0];
        int val = 0;
        for (int i = 0; i < data.length; ++i) {
            if (i == skipIndex) continue;
            val ^= data[i];
        }
        erasedValue[0] = val;
    }

    public void decode(int[] data, int[] erasedLocations, int[] erasedValues, int[] locationsToRead, int[] locationsNotToRead) {
        this.decode(data, erasedLocations, erasedValues);
    }

    public int stripeSize() {
        return this.stripeSize;
    }

    public int paritySize() {
        return this.paritySize;
    }

    public int symbolSize() {
        return 8;
    }

    public void encodeBulk(byte[][] inputs, byte[][] outputs) {
        byte[] output = outputs[0];
        int bufSize = output.length;
        for (int j = 0; j < bufSize; ++j) {
            output[j] = inputs[0][j];
        }
        for (int i = 1; i < inputs.length; ++i) {
            for (int j = 0; j < bufSize; ++j) {
                int n = j;
                output[n] = (byte)(output[n] ^ inputs[i][j]);
            }
        }
    }

    public void decodeBulk(byte[][] readBufs, byte[][] writeBufs, int[] erasedLocations) {
        assert (erasedLocations.length == writeBufs.length);
        assert (erasedLocations.length <= 1);
        byte[] output = writeBufs[0];
        int erasedIdx = erasedLocations[0];
        for (int j = 0; j < output.length; ++j) {
            output[j] = 0;
        }
        for (int i = 0; i < readBufs.length; ++i) {
            if (i == erasedIdx) continue;
            byte[] input = readBufs[i];
            for (int j = 0; j < input.length; ++j) {
                int n = j;
                output[n] = (byte)(output[n] ^ input[j]);
            }
        }
    }

    public void decodeBulk(byte[][] readBufs, byte[][] writeBufs, int[] erasedLocations, int[] locationsToRead, int[] locationsNotToRead) {
        this.decodeBulk(readBufs, writeBufs, erasedLocations);
    }
}

