/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.BaseEncodingManager;
import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.MapReduceEncoder;
import io.hops.erasure_coding.PolicyInfo;
import io.hops.erasure_coding.Report;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.EncodingJobsDataAccess;
import io.hops.metadata.hdfs.entity.EncodingJob;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;

public class MapReduceEncodingManager
extends BaseEncodingManager {
    public static final Log LOG = LogFactory.getLog(MapReduceEncodingManager.class);
    public static final String ENCODING_JOB_EXECUTION_LIMIT = "io.hops.erasure_coding.encoding_job_execution_limit";
    public static final long DEFAULT_ENCODING_JOB_EXECUTION_LIMIT = 86400000L;
    private final long executionLimit;
    private Map<String, MapReduceEncoder> currentJobs = new HashMap<String, MapReduceEncoder>();
    private Collection<MapReduceEncoder> completedJobs = new ArrayList<MapReduceEncoder>();
    private boolean initialized = false;

    public MapReduceEncodingManager(Configuration conf) throws IOException {
        super(conf);
        this.executionLimit = conf.getLong(ENCODING_JOB_EXECUTION_LIMIT, 86400000L);
        LOG.info((Object)"created");
    }

    public void encodeFile(EncodingPolicy policy, Path sourceFile, Path parityFile, boolean copy) {
        this.initialize();
        Codec codec = Codec.getCodec((String)policy.getCodec());
        LOG.info((Object)("Start encoding with policy: " + policy + " for source file " + sourceFile.toUri().getPath() + " and parity file " + parityFile + " copy " + copy));
        PolicyInfo policyInfo = new PolicyInfo();
        try {
            policyInfo.setSrcPath(sourceFile.toUri().getPath());
            policyInfo.setCodecId(codec.getId());
            policyInfo.setProperty(PolicyInfo.PROPERTY_PARITY_PATH, parityFile.toUri().getPath());
            policyInfo.setProperty(PolicyInfo.PROPERTY_REPLICATION, String.valueOf(policy.getTargetReplication()));
            policyInfo.setProperty(PolicyInfo.PROPERTY_PARITY_REPLICATION, String.valueOf(1));
            policyInfo.setProperty(PolicyInfo.PROPERTY_COPY, String.valueOf(copy));
            this.raidFiles(policyInfo);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
    }

    public void raidFiles(PolicyInfo info) throws IOException {
        MapReduceEncoder dr = new MapReduceEncoder(this.conf);
        boolean started = dr.startDistRaid(info);
        if (started) {
            String path = info.getSrcPath().toUri().getPath();
            this.persistActiveJob(path, dr.getJobID(), dr.getConf().get("mapReduceEncoder.job.dir"));
            this.currentJobs.put(path, dr);
        }
    }

    public List<Report> computeReports() throws IOException {
        MapReduceEncoder job;
        this.initialize();
        this.cleanRecovery();
        ArrayList<Report> reports = new ArrayList<Report>(this.currentJobs.size());
        for (Map.Entry<String, MapReduceEncoder> entry : this.currentJobs.entrySet()) {
            String fileName = entry.getKey();
            job = entry.getValue();
            try {
                if (job.checkComplete() && job.successful()) {
                    reports.add(new Report(fileName, Report.Status.FINISHED));
                    LOG.info((Object)("Encoding successful for job " + job.getJobID()));
                    continue;
                }
                if (job.checkComplete() && !job.successful()) {
                    reports.add(new Report(fileName, Report.Status.FAILED));
                    LOG.info((Object)("Encoding failed for job " + job.getJobID()));
                    continue;
                }
                if (System.currentTimeMillis() - job.getStartTime() > this.executionLimit) {
                    job.killJob();
                    reports.add(new Report(fileName, Report.Status.CANCELED));
                    LOG.info((Object)("Encoding canceled for job " + job.getJobID()));
                    continue;
                }
                reports.add(new Report(fileName, Report.Status.ACTIVE));
                LOG.info((Object)("Encoding active for job " + job.getJobID()));
            }
            catch (IOException e) {
                LOG.error((Object)"Exception during completeness check", (Throwable)e);
                try {
                    job.killJob();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                reports.add(new Report(fileName, Report.Status.FAILED));
            }
        }
        for (Report report : reports) {
            Report.Status status = report.getStatus();
            if (status != Report.Status.FINISHED && status != Report.Status.FAILED && status != Report.Status.CANCELED) continue;
            job = this.currentJobs.remove(report.getFilePath());
            this.completedJobs.add(job);
        }
        return reports;
    }

    private void persistActiveJob(final String path, final JobID jobId, final String jobDir) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.PERSIST_ENCODING_JOB){

            public Object performTask() throws IOException {
                EncodingJobsDataAccess da = (EncodingJobsDataAccess)HdfsStorageFactory.getDataAccess(EncodingJobsDataAccess.class);
                da.add((Object)new EncodingJob(jobId.getJtIdentifier(), jobId.getId(), path, jobDir));
                return null;
            }
        }.handle();
    }

    private void cleanRecovery() throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.DELETE_ENCODING_JOBS){

            public Object performTask() throws IOException {
                EncodingJobsDataAccess da = (EncodingJobsDataAccess)HdfsStorageFactory.getDataAccess(EncodingJobsDataAccess.class);
                Iterator it = MapReduceEncodingManager.this.completedJobs.iterator();
                while (it.hasNext()) {
                    MapReduceEncoder job = (MapReduceEncoder)it.next();
                    JobID jobId = job.getJobID();
                    da.delete((Object)new EncodingJob(jobId.getJtIdentifier(), jobId.getId()));
                    it.remove();
                }
                return null;
            }
        }.handle();
    }

    public void cancelAll() {
        this.initialize();
        for (MapReduceEncoder job : this.currentJobs.values()) {
            try {
                job.killJob();
            }
            catch (IOException e) {
                LOG.error((Object)"Exception", (Throwable)e);
            }
        }
        this.currentJobs.clear();
    }

    public void cancel(String toCancel) {
        this.initialize();
        MapReduceEncoder job = this.currentJobs.get(toCancel);
        try {
            job.killJob();
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        this.currentJobs.remove(toCancel);
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        try {
            for (EncodingJob job : this.recoverActiveJobs()) {
                MapReduceEncoder recovered = new MapReduceEncoder(this.conf, job);
                this.currentJobs.put(job.getPath(), recovered);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Encoding job recovery failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }

    private Collection<EncodingJob> recoverActiveJobs() throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.RECOVER_ENCODING_JOBS){

            public Object performTask() throws IOException {
                EncodingJobsDataAccess da = (EncodingJobsDataAccess)HdfsStorageFactory.getDataAccess(EncodingJobsDataAccess.class);
                return da.findAll();
            }
        };
        return (Collection)handler.handle();
    }
}

