/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.BlockRepairManager;
import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.Decoder;
import io.hops.erasure_coding.Report;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.datanode.BlockReconstructor;

public class LocalBlockRepairManager
extends BlockRepairManager {
    public static final Log LOG = LogFactory.getLog(LocalBlockRepairManager.class);
    private BlockReconstructor blockReconstructor;

    public LocalBlockRepairManager(Configuration conf) {
        super(conf);
        this.blockReconstructor = new BlockReconstructor(conf);
    }

    public void repairSourceBlocks(String codecId, Path sourceFile, Path parityFile) {
        Codec codec = Codec.getCodec((String)codecId);
        Decoder decoder = new Decoder(this.getConf(), codec);
        try {
            this.blockReconstructor.processFile(sourceFile, parityFile, decoder);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
    }

    public void repairParityBlocks(String codecId, Path sourceFile, Path parityFile) {
        Codec codec = Codec.getCodec((String)codecId);
        Decoder decoder = new Decoder(this.getConf(), codec);
        try {
            this.blockReconstructor.processParityFile(sourceFile, parityFile, decoder);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
    }

    public List<Report> computeReports() {
        throw new NotImplementedException();
    }

    public void cancelAll() {
        throw new NotImplementedException();
    }

    public void cancel(String toCancel) {
        throw new NotImplementedException();
    }
}

