/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.Decoder;
import io.hops.erasure_coding.ParallelStreamReader;
import io.hops.erasure_coding.RaidUtils;
import io.hops.erasure_coding.XOREncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Progressable;

public class XORDecoder
extends Decoder {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.raid.XORDecoder");
    private int stripeSize;

    public XORDecoder(Configuration conf) {
        super(conf, Codec.getCodec((String)"xor"));
        this.stripeSize = this.codec.stripeLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long fixErasedBlockImpl(FileSystem fs, Path srcFile, FileSystem parityFs, Path parityFile, boolean fixSource, long blockSize, long errorOffset, long limit, boolean partial, OutputStream out, Progressable reporter, CRC32 crc) throws IOException {
        if (partial) {
            throw new IOException("We don't support partial reconstruction");
        }
        LOG.info((Object)("Fixing block at " + srcFile + ":" + errorOffset + ", limit " + limit));
        if (crc != null) {
            crc.reset();
        }
        FileStatus srcStat = fs.getFileStatus(srcFile);
        FSDataInputStream[] inputs = new FSDataInputStream[this.stripeSize + this.codec.parityLength];
        try {
            long errorBlockOffset = errorOffset / blockSize * blockSize;
            long[] srcOffsets = this.stripeOffsets(errorOffset, blockSize, fixSource);
            for (int i = 0; i < srcOffsets.length; ++i) {
                if (fixSource && srcOffsets[i] == errorBlockOffset) {
                    inputs[i] = new FSDataInputStream((InputStream)new RaidUtils.ZeroInputStream(blockSize));
                    LOG.info((Object)("Using zeros at " + srcFile + ":" + errorBlockOffset));
                    continue;
                }
                if (srcOffsets[i] < srcStat.getLen()) {
                    FSDataInputStream in = fs.open(srcFile);
                    in.seek(srcOffsets[i]);
                    inputs[i] = in;
                    continue;
                }
                inputs[i] = new FSDataInputStream((InputStream)new RaidUtils.ZeroInputStream(blockSize));
                LOG.info((Object)("Using zeros at " + srcFile + ":" + errorBlockOffset));
            }
            if (fixSource) {
                FSDataInputStream parityFileIn = parityFs.open(parityFile);
                parityFileIn.seek(this.parityOffset(errorOffset, blockSize));
                inputs[inputs.length - 1] = parityFileIn;
            } else {
                inputs[inputs.length - 1] = new FSDataInputStream((InputStream)new RaidUtils.ZeroInputStream(blockSize));
                LOG.info((Object)("Using zeros at " + parityFile + ":" + errorBlockOffset));
            }
        }
        catch (IOException e) {
            RaidUtils.closeStreams((InputStream[])inputs);
            throw e;
        }
        int boundedBufferCapacity = 1;
        ParallelStreamReader parallelReader = new ParallelStreamReader(reporter, (InputStream[])inputs, this.bufSize, this.parallelism, boundedBufferCapacity, blockSize);
        parallelReader.start();
        try {
            long written;
            int toWrite;
            for (written = 0L; written < limit; written += (long)toWrite) {
                ParallelStreamReader.ReadResult readResult;
                try {
                    readResult = parallelReader.getReadResult();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted while waiting for read result");
                }
                IOException readEx = readResult.getException();
                if (readEx != null) {
                    throw readEx;
                }
                toWrite = (int)Math.min((long)this.bufSize, limit - written);
                XOREncoder.xor(readResult.readBufs, this.writeBufs[0]);
                out.write(this.writeBufs[0], 0, toWrite);
                if (crc == null) continue;
                crc.update(this.writeBufs[0], 0, toWrite);
            }
            long l = written;
            return l;
        }
        finally {
            parallelReader.shutdown();
        }
    }

    protected long[] stripeOffsets(long errorOffset, long blockSize, boolean fixSource) {
        long[] offsets = new long[this.stripeSize];
        long stripeIdx = fixSource ? errorOffset / (blockSize * (long)this.stripeSize) : errorOffset / blockSize;
        long startOffsetOfStripe = stripeIdx * (long)this.stripeSize * blockSize;
        for (int i = 0; i < this.stripeSize; ++i) {
            offsets[i] = startOffsetOfStripe + (long)i * blockSize;
        }
        return offsets;
    }

    protected long parityOffset(long errorOffset, long blockSize) {
        long stripeIdx = errorOffset / (blockSize * (long)this.stripeSize);
        return stripeIdx * blockSize;
    }
}

