/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.BaseEncodingManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Progressable;

public class RaidUtils {
    public static Progressable NULL_PROGRESSABLE = new Progressable(){

        public void progress() {
        }
    };

    public static int readTillEnd(InputStream in, byte[] buf, boolean eofOK, long endOffset, int toRead) throws IOException {
        int numRead;
        int nread;
        for (numRead = 0; numRead < toRead; numRead += nread) {
            int available;
            int readLen = toRead - numRead;
            if (in instanceof DFSClient.DFSDataInputStream && (available = (int)(endOffset - ((DFSClient.DFSDataInputStream)in).getPos())) < readLen) {
                readLen = available;
            }
            int n = nread = readLen > 0 ? in.read(buf, numRead, readLen) : 0;
            if (nread < 0) {
                if (eofOK) {
                    Arrays.fill(buf, numRead, toRead, (byte)0);
                    break;
                }
                throw new IOException("Premature EOF");
            }
            if (nread != 0) continue;
            Arrays.fill(buf, numRead, toRead, (byte)0);
            break;
        }
        if (in instanceof ZeroInputStream) {
            return 0;
        }
        return numRead;
    }

    public static void copyBytes(InputStream in, OutputStream out, byte[] buf, long count) throws IOException {
        int toRead;
        for (long bytesRead = 0L; bytesRead < count; bytesRead += (long)toRead) {
            toRead = Math.min(buf.length, (int)(count - bytesRead));
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)toRead);
            out.write(buf, 0, toRead);
        }
    }

    public static void parseAndSetOptions(Configuration conf, String optionKey) {
        String optionValue = conf.get(optionKey);
        if (optionValue != null) {
            String[] keyValues;
            BaseEncodingManager.LOG.info((Object)("Parsing option " + optionKey));
            for (String keyValue : keyValues = optionValue.trim().split(",")) {
                String[] fields = keyValue.trim().split(":");
                String key = fields[0].trim();
                String value = fields[1].trim();
                conf.set(key, value);
            }
        } else {
            BaseEncodingManager.LOG.error((Object)("Option " + optionKey + " not found"));
        }
    }

    public static void closeStreams(InputStream[] streams) throws IOException {
        if (streams == null) {
            return;
        }
        for (InputStream stm : streams) {
            if (stm == null) continue;
            stm.close();
        }
    }

    public static class ZeroInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private long endOffset;
        private long pos;

        public ZeroInputStream(long endOffset) {
            this.endOffset = endOffset;
            this.pos = 0L;
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.endOffset) {
                ++this.pos;
                return 0;
            }
            return -1;
        }

        @Override
        public int available() throws IOException {
            return (int)(this.endOffset - this.pos);
        }

        public long getPos() throws IOException {
            return this.pos;
        }

        public void seek(long seekOffset) throws IOException {
            if (seekOffset >= this.endOffset) {
                throw new IOException("Illegal Offset" + this.pos);
            }
            this.pos = seekOffset;
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            int count;
            for (count = 0; position < this.endOffset && count < length; ++count, ++position) {
                buffer[offset + count] = 0;
            }
            return count;
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            int count;
            for (count = 0; position < this.endOffset && count < length; ++count, ++position) {
                buffer[offset + count] = 0;
            }
            if (count < length) {
                throw new IOException("Premature EOF");
            }
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.readFully(position, buffer, 0, buffer.length);
        }

        public List<ByteBuffer> readFullyScatterGather(long position, int length) throws IOException {
            throw new IOException("ScatterGather not implemeted for Raid.");
        }
    }
}

