/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.Encoder;
import io.hops.erasure_coding.ErasureCode;
import io.hops.erasure_coding.ParallelStreamReader;
import io.hops.erasure_coding.ReedSolomonCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Progressable;

public class ReedSolomonEncoder
extends Encoder {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.raid.ReedSolomonEncoder");
    private ErasureCode reedSolomonCode;
    private int stripeSize;
    private int paritySize;

    public ReedSolomonEncoder(Configuration conf) {
        super(conf, Codec.getCodec((String)"rs"));
        this.stripeSize = this.codec.stripeLength;
        this.paritySize = this.codec.parityLength;
        this.reedSolomonCode = new ReedSolomonCode(this.stripeSize, this.paritySize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeStripeImpl(InputStream[] blocks, long stripeStartOffset, long blockSize, OutputStream[] outs, Progressable reporter) throws IOException {
        int boundedBufferCapacity = 1;
        ParallelStreamReader parallelReader = new ParallelStreamReader(reporter, blocks, this.bufSize, this.parallelism, boundedBufferCapacity, blockSize);
        parallelReader.start();
        try {
            this.encodeStripeParallel(blocks, stripeStartOffset, blockSize, outs, reporter, parallelReader);
        }
        finally {
            parallelReader.shutdown();
        }
    }

    private void encodeStripeParallel(InputStream[] blocks, long stripeStartOffset, long blockSize, OutputStream[] outs, Progressable reporter, ParallelStreamReader parallelReader) throws IOException {
        int[] data = new int[this.stripeSize];
        int[] code = new int[this.paritySize];
        for (long encoded = 0L; encoded < blockSize; encoded += (long)this.bufSize) {
            ParallelStreamReader.ReadResult readResult;
            try {
                readResult = parallelReader.getReadResult();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while waiting for read result");
            }
            IOException readEx = readResult.getException();
            if (readEx != null) {
                throw readEx;
            }
            for (int j = 0; j < this.bufSize; ++j) {
                this.performEncode(readResult.readBufs, this.writeBufs, j, data, code);
            }
            reporter.progress();
            for (int i = 0; i < this.paritySize; ++i) {
                outs[i].write(this.writeBufs[i], 0, this.bufSize);
                reporter.progress();
            }
        }
    }

    void performEncode(byte[][] readBufs, byte[][] writeBufs, int idx, int[] data, int[] code) {
        int i;
        for (i = 0; i < this.paritySize; ++i) {
            code[i] = 0;
        }
        for (i = 0; i < this.stripeSize; ++i) {
            data[i] = readBufs[i][idx] & 0xFF;
        }
        this.reedSolomonCode.encode(data, code);
        for (i = 0; i < this.paritySize; ++i) {
            writeBufs[i][idx] = (byte)code[i];
        }
    }
}

