/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.Decoder;
import io.hops.erasure_coding.ErasureCode;
import io.hops.erasure_coding.ParallelStreamReader;
import io.hops.erasure_coding.RaidUtils;
import io.hops.erasure_coding.ReedSolomonCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.util.Progressable;

public class ReedSolomonDecoder
extends Decoder {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.raid.ReedSolomonDecoder");
    private ErasureCode[] reedSolomonCode;
    private long decodeTime;
    private long waitTime;
    ExecutorService parallelDecoder;
    Semaphore decodeOps;
    private int stripeSize;
    private int paritySize;

    public ReedSolomonDecoder(Configuration conf) {
        super(conf, Codec.getCodec((String)"rs"));
        this.reedSolomonCode = new ReedSolomonCode[this.parallelism];
        this.stripeSize = this.codec.stripeLength;
        this.paritySize = this.codec.parityLength;
        for (int i = 0; i < this.parallelism; ++i) {
            this.reedSolomonCode[i] = new ReedSolomonCode(this.stripeSize, this.paritySize);
        }
        this.decodeOps = new Semaphore(this.parallelism);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long fixErasedBlockImpl(FileSystem fs, Path srcFile, FileSystem parityFs, Path parityFile, boolean fixSource, long blockSize, long errorOffset, long limit, boolean partial, OutputStream out, Progressable reporter, CRC32 crc) throws IOException {
        int erasedLocationToFix;
        int blockIdxInStripe;
        if (partial) {
            throw new IOException("We don't support partial reconstruction");
        }
        FSDataInputStream[] inputs = new FSDataInputStream[this.stripeSize + this.paritySize];
        int[] erasedLocations = this.buildInputs(fs, srcFile, parityFs, parityFile, fixSource, errorOffset, inputs);
        if (fixSource) {
            blockIdxInStripe = (int)(errorOffset / blockSize) % this.stripeSize;
            erasedLocationToFix = this.paritySize + blockIdxInStripe;
        } else {
            erasedLocationToFix = blockIdxInStripe = (int)(errorOffset / blockSize) % this.paritySize;
        }
        int boundedBufferCapacity = 2;
        this.parallelDecoder = Executors.newFixedThreadPool(this.parallelism);
        ParallelStreamReader parallelReader = new ParallelStreamReader(reporter, (InputStream[])inputs, this.bufSize, this.parallelism, boundedBufferCapacity, blockSize);
        parallelReader.start();
        this.decodeTime = 0L;
        this.waitTime = 0L;
        try {
            long l = this.writeFixedBlock(inputs, erasedLocations, erasedLocationToFix, limit, out, reporter, parallelReader, crc);
            return l;
        }
        finally {
            parallelReader.shutdown();
            LOG.info((Object)("Time spent in read " + parallelReader.readTime + ", decode " + this.decodeTime + " wait " + this.waitTime));
            this.parallelDecoder.shutdownNow();
        }
    }

    protected int[] buildInputs(FileSystem fs, Path srcFile, FileSystem parityFs, Path parityFile, boolean fixSource, long errorOffset, FSDataInputStream[] inputs) throws IOException {
        LOG.info((Object)("Building inputs to recover block starting at " + errorOffset));
        try {
            FSDataInputStream in;
            long offset;
            int i;
            FileStatus srcStat = fs.getFileStatus(srcFile);
            FileStatus parityStat = fs.getFileStatus(parityFile);
            long blockSize = srcStat.getBlockSize();
            long blockIdx = (int)(errorOffset / blockSize);
            long stripeIdx = fixSource ? blockIdx / (long)this.stripeSize : blockIdx / (long)this.paritySize;
            LOG.info((Object)("FileSize = " + srcStat.getLen() + ", blockSize = " + blockSize + ", blockIdx = " + blockIdx + ", stripeIdx = " + stripeIdx));
            ArrayList<Integer> erasedLocations = new ArrayList<Integer>();
            for (i = 0; i < this.paritySize; ++i) {
                offset = blockSize * (stripeIdx * (long)this.paritySize + (long)i);
                if (!fixSource && offset == errorOffset) {
                    LOG.info((Object)(parityFile + ":" + offset + " is known to have error, adding zeros as input " + i));
                    inputs[i] = new FSDataInputStream((InputStream)new RaidUtils.ZeroInputStream(offset + blockSize));
                    erasedLocations.add(i);
                    continue;
                }
                if (offset > parityStat.getLen()) {
                    LOG.info((Object)(parityFile + ":" + offset + " is past file size, adding zeros as input " + i));
                    inputs[i] = new FSDataInputStream((InputStream)new RaidUtils.ZeroInputStream(offset + blockSize));
                    continue;
                }
                in = parityFs.open(parityFile, this.conf.getInt("io.file.buffer.size", 65536));
                in.seek(offset);
                LOG.info((Object)("Adding " + parityFile + ":" + offset + " as input " + i));
                inputs[i] = in;
            }
            for (i = this.paritySize; i < this.paritySize + this.stripeSize; ++i) {
                offset = blockSize * (stripeIdx * (long)this.stripeSize + (long)i - (long)this.paritySize);
                if (fixSource && offset == errorOffset) {
                    LOG.info((Object)(srcFile + ":" + offset + " is known to have error, adding zeros as input " + i));
                    inputs[i] = new FSDataInputStream((InputStream)new RaidUtils.ZeroInputStream(offset + blockSize));
                    erasedLocations.add(i);
                    continue;
                }
                if (offset > srcStat.getLen()) {
                    LOG.info((Object)(srcFile + ":" + offset + " is past file size, adding zeros as input " + i));
                    inputs[i] = new FSDataInputStream((InputStream)new RaidUtils.ZeroInputStream(offset + blockSize));
                    continue;
                }
                in = fs.open(srcFile, this.conf.getInt("io.file.buffer.size", 65536));
                in.seek(offset);
                LOG.info((Object)("Adding " + srcFile + ":" + offset + " as input " + i));
                inputs[i] = in;
            }
            if (erasedLocations.size() > this.paritySize) {
                String msg = "Too many erased locations: " + erasedLocations.size();
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            int[] locs = new int[erasedLocations.size()];
            for (int i2 = 0; i2 < locs.length; ++i2) {
                locs[i2] = (Integer)erasedLocations.get(i2);
            }
            return locs;
        }
        catch (IOException e) {
            RaidUtils.closeStreams((InputStream[])inputs);
            throw e;
        }
    }

    long writeFixedBlock(FSDataInputStream[] inputs, int[] erasedLocations, int erasedLocationToFix, long limit, OutputStream out, Progressable reporter, ParallelStreamReader parallelReader, CRC32 crc) throws IOException {
        LOG.info((Object)("Need to write " + limit + " bytes for erased location index " + erasedLocationToFix));
        if (crc != null) {
            crc.reset();
        }
        int[] tmp = new int[inputs.length];
        int[] decoded = new int[erasedLocations.length];
        long written = 0L;
        block2: while (written < limit) {
            if (decoded.length != (erasedLocations = this.readFromInputs(inputs, erasedLocations, limit, reporter, parallelReader)).length) {
                decoded = new int[erasedLocations.length];
            }
            int toWrite = (int)Math.min((long)this.bufSize, limit - written);
            int partSize = (int)Math.ceil((double)this.bufSize * 1.0 / (double)this.parallelism);
            try {
                long startTime = System.currentTimeMillis();
                for (int i = 0; i < this.parallelism; ++i) {
                    this.decodeOps.acquire(1);
                    int start = i * partSize;
                    int count = Math.min(this.bufSize - start, partSize);
                    this.parallelDecoder.execute(new DecodeOp(this.readBufs, this.writeBufs, start, count, erasedLocations, this.reedSolomonCode[i]));
                }
                this.decodeOps.acquire(this.parallelism);
                this.decodeOps.release(this.parallelism);
                this.decodeTime += System.currentTimeMillis() - startTime;
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while waiting for read result");
            }
            for (int i = 0; i < erasedLocations.length; ++i) {
                if (erasedLocations[i] != erasedLocationToFix) continue;
                out.write(this.writeBufs[i], 0, toWrite);
                if (crc != null) {
                    crc.update(this.writeBufs[i], 0, toWrite);
                }
                written += (long)toWrite;
                continue block2;
            }
        }
        return written;
    }

    int[] readFromInputs(FSDataInputStream[] inputs, int[] erasedLocations, long limit, Progressable reporter, ParallelStreamReader parallelReader) throws IOException {
        ParallelStreamReader.ReadResult readResult;
        try {
            long start = System.currentTimeMillis();
            readResult = parallelReader.getReadResult();
            this.waitTime += System.currentTimeMillis() - start;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for read result");
        }
        for (int i = 0; i < readResult.ioExceptions.length; ++i) {
            IOException e = readResult.ioExceptions[i];
            if (e == null) continue;
            if (e instanceof BlockMissingException) {
                LOG.warn((Object)("Encountered BlockMissingException in stream " + i));
            } else if (e instanceof ChecksumException) {
                LOG.warn((Object)("Encountered ChecksumException in stream " + i));
            } else {
                throw e;
            }
            if (erasedLocations.length == this.paritySize) {
                String msg = "Too many read errors";
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
            int[] newErasedLocations = new int[erasedLocations.length + 1];
            for (int j = 0; j < erasedLocations.length; ++j) {
                newErasedLocations[j] = erasedLocations[j];
            }
            newErasedLocations[newErasedLocations.length - 1] = i;
            erasedLocations = newErasedLocations;
        }
        this.readBufs = readResult.readBufs;
        return erasedLocations;
    }

    class DecodeOp
    implements Runnable {
        byte[][] readBufs;
        byte[][] writeBufs;
        int startIdx;
        int count;
        int[] erasedLocations;
        int[] tmpInput;
        int[] tmpOutput;
        ErasureCode rs;

        DecodeOp(byte[][] readBufs, byte[][] writeBufs, int startIdx, int count, int[] erasedLocations, ErasureCode rs) {
            this.readBufs = readBufs;
            this.writeBufs = writeBufs;
            this.startIdx = startIdx;
            this.count = count;
            this.erasedLocations = erasedLocations;
            this.tmpInput = new int[readBufs.length];
            this.tmpOutput = new int[erasedLocations.length];
            this.rs = rs;
        }

        @Override
        public void run() {
            try {
                this.performDecode();
            }
            finally {
                ReedSolomonDecoder.this.decodeOps.release();
            }
        }

        private void performDecode() {
            for (int idx = this.startIdx; idx < this.startIdx + this.count; ++idx) {
                int i;
                for (i = 0; i < this.tmpOutput.length; ++i) {
                    this.tmpOutput[i] = 0;
                }
                for (i = 0; i < this.tmpInput.length; ++i) {
                    this.tmpInput[i] = this.readBufs[i][idx] & 0xFF;
                }
                this.rs.decode(this.tmpInput, this.erasedLocations, this.tmpOutput);
                for (i = 0; i < this.tmpOutput.length; ++i) {
                    this.writeBufs[i][idx] = (byte)this.tmpOutput[i];
                }
            }
        }
    }
}

