/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.Decoder;
import io.hops.erasure_coding.Encoder;
import io.hops.erasure_coding.EncodingManager;
import io.hops.erasure_coding.FileStripeReader;
import io.hops.erasure_coding.Helper;
import io.hops.erasure_coding.PolicyInfo;
import io.hops.erasure_coding.RaidUtils;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.json.simple.JSONObject;
import org.xml.sax.SAXException;

public abstract class BaseEncodingManager
extends EncodingManager {
    public static final Log LOG = LogFactory.getLog(BaseEncodingManager.class);
    public static final Log ENCODER_METRICS_LOG = LogFactory.getLog((String)"RaidMetrics");
    public static final String JOBUSER = "erasure_coding";
    public static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
    protected Configuration conf;

    BaseEncodingManager(Configuration conf) throws IOException {
        super(conf);
        try {
            this.initialize(conf);
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void initialize(Configuration conf) throws IOException, SAXException, InterruptedException, ClassNotFoundException, ParserConfigurationException {
        this.conf = conf;
    }

    static long numBlocks(FileStatus stat) {
        return (long)Math.ceil((double)stat.getLen() * 1.0 / (double)stat.getBlockSize());
    }

    static long numStripes(long numBlocks, int stripeSize) {
        return (long)Math.ceil((double)numBlocks * 1.0 / (double)stripeSize);
    }

    void doRaid(Configuration conf, PolicyInfo info) throws IOException {
        int targetRepl = Integer.parseInt(info.getProperty(PolicyInfo.PROPERTY_REPLICATION));
        int metaRepl = Integer.parseInt(info.getProperty(PolicyInfo.PROPERTY_PARITY_REPLICATION));
        Codec codec = Codec.getCodec((String)info.getCodecId());
        Path destPref = new Path(codec.parityDirectory);
        boolean copy = Boolean.valueOf(info.getProperty(PolicyInfo.PROPERTY_COPY));
        Statistics statistics = new Statistics();
        BaseEncodingManager.doRaid(conf, info.getSrcPath(), destPref, codec, statistics, RaidUtils.NULL_PROGRESSABLE, targetRepl, metaRepl, copy);
        LOG.info((Object)("RAID statistics " + statistics.toString()));
    }

    public static boolean doRaid(Configuration conf, PolicyInfo info, Path src, Statistics statistics, Progressable reporter) throws IOException {
        int targetRepl = Integer.parseInt(info.getProperty(PolicyInfo.PROPERTY_REPLICATION));
        int metaRepl = Integer.parseInt(info.getProperty(PolicyInfo.PROPERTY_PARITY_REPLICATION));
        Codec codec = Codec.getCodec((String)info.getCodecId());
        Path parityPath = new Path(info.getProperty(PolicyInfo.PROPERTY_PARITY_PATH));
        boolean copy = Boolean.valueOf(info.getProperty(PolicyInfo.PROPERTY_COPY));
        return BaseEncodingManager.doRaid(conf, src, parityPath, codec, statistics, reporter, targetRepl, metaRepl, copy);
    }

    public static boolean doRaid(Configuration conf, Path path, Path parityPath, Codec codec, Statistics statistics, Progressable reporter, int targetRepl, int metaRepl, boolean copy) throws IOException {
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            boolean bl = BaseEncodingManager.doFileRaid(conf, path, parityPath, codec, statistics, reporter, targetRepl, metaRepl, copy);
            return bl;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            long delay = System.currentTimeMillis() - startTime;
            long savingBytes = statistics.processedSize - statistics.remainingSize - statistics.metaSize;
            FileSystem srcFs = path.getFileSystem(conf);
            if (success) {
                BaseEncodingManager.logRaidEncodingMetrics("SUCCESS", codec, delay, statistics.processedSize, statistics.numProcessedBlocks, statistics.numMetaBlocks, statistics.metaSize, savingBytes, path, LOGTYPES.ENCODING, srcFs);
            } else {
                BaseEncodingManager.logRaidEncodingMetrics("FAILURE", codec, delay, statistics.processedSize, statistics.numProcessedBlocks, statistics.numMetaBlocks, statistics.metaSize, savingBytes, path, LOGTYPES.ENCODING, srcFs);
            }
        }
    }

    public static long getNumBlocks(FileStatus stat) {
        long numBlocks = stat.getLen() / stat.getBlockSize();
        if (stat.getLen() % stat.getBlockSize() == 0L) {
            return numBlocks;
        }
        return numBlocks + 1L;
    }

    public static boolean doFileRaid(Configuration conf, Path sourceFile, Path parityPath, Codec codec, Statistics statistics, Progressable reporter, int targetRepl, int metaRepl, boolean copy) throws IOException {
        FileStatus sourceStatus;
        DistributedFileSystem srcFs = Helper.getDFS(conf, sourceFile);
        BlockLocation[] locations = srcFs.getFileBlockLocations(sourceFile, 0L, (sourceStatus = srcFs.getFileStatus(sourceFile)).getLen());
        if (locations.length <= 2) {
            return false;
        }
        long diskSpace = 0L;
        for (BlockLocation l : locations) {
            diskSpace += l.getLength() * (long)sourceStatus.getReplication();
        }
        statistics.numProcessedBlocks += (long)locations.length;
        statistics.processedSize += diskSpace;
        Path tmpFile = null;
        FSDataOutputStream out = null;
        try {
            if (copy) {
                tmpFile = new Path("/tmp" + sourceFile);
                out = srcFs.create(tmpFile, (short)targetRepl);
                DFSOutputStream dfsOut = (DFSOutputStream)out.getWrappedStream();
                dfsOut.enableSourceStream(codec.getStripeLength());
            }
            BaseEncodingManager.generateParityFile(conf, sourceStatus, reporter, (FileSystem)srcFs, parityPath, codec, metaRepl, sourceStatus.getBlockSize(), tmpFile, out);
            if (copy) {
                out.close();
                srcFs.rename(tmpFile, sourceFile, new Options.Rename[]{Options.Rename.OVERWRITE, Options.Rename.KEEP_ENCODING_STATUS});
            } else if (!srcFs.setReplication(sourceFile, (short)targetRepl)) {
                LOG.info((Object)("Error in reducing replication of " + sourceFile + " to " + targetRepl));
                statistics.remainingSize += diskSpace;
                return false;
            }
        }
        catch (IOException e) {
            if (out != null) {
                out.close();
            }
            throw e;
        }
        diskSpace = 0L;
        for (BlockLocation l : locations) {
            diskSpace += l.getLength() * (long)targetRepl;
        }
        statistics.remainingSize += diskSpace;
        int numMeta = locations.length / codec.stripeLength;
        if (locations.length % codec.stripeLength != 0) {
            ++numMeta;
        }
        statistics.numMetaBlocks += (long)(numMeta * metaRepl);
        statistics.metaSize += (long)(numMeta * metaRepl) * sourceStatus.getBlockSize();
        return true;
    }

    private static void generateParityFile(Configuration conf, FileStatus sourceFile, Progressable reporter, FileSystem inFs, Path destPath, Codec codec, int metaRepl, long blockSize, Path copyPath, FSDataOutputStream copy) throws IOException {
        Path inpath = sourceFile.getPath();
        FileSystem outFs = inFs;
        Encoder encoder = new Encoder(conf, codec);
        FileStatus srcStat = inFs.getFileStatus(inpath);
        long srcSize = srcStat.getLen();
        long numBlocks = srcSize % blockSize == 0L ? srcSize / blockSize : srcSize / blockSize + 1L;
        long numStripes = numBlocks % (long)codec.stripeLength == 0L ? numBlocks / (long)codec.stripeLength : numBlocks / (long)codec.stripeLength + 1L;
        FileStripeReader sReader = new FileStripeReader(conf, blockSize, codec, inFs, 0L, inpath, srcSize);
        encoder.encodeFile(conf, inFs, inpath, outFs, destPath, (short)metaRepl, numStripes, blockSize, reporter, sReader, copyPath, copy);
        FileStatus outstat = outFs.getFileStatus(destPath);
        FileStatus inStat = inFs.getFileStatus(inpath);
        LOG.info((Object)("Source file " + inpath + " of size " + inStat.getLen() + " Parity file " + destPath + " of size " + outstat.getLen() + " src mtime " + sourceFile.getModificationTime() + " parity mtime " + outstat.getModificationTime()));
    }

    public static Decoder.DecoderInputStream unRaidCorruptInputStream(Configuration conf, Path srcPath, long blockSize, long corruptOffset, long limit) throws IOException {
        DistributedFileSystem srcFs = Helper.getDFS(conf, srcPath);
        EncodingStatus encodingStatus = srcFs.getEncodingStatus(srcPath.toUri().getPath());
        Decoder decoder = new Decoder(conf, Codec.getCodec((String)encodingStatus.getEncodingPolicy().getCodec()));
        String parityFolder = conf.get("dfs.erasure_coding.parity_folder", "/parity");
        return decoder.generateAlternateStream((FileSystem)srcFs, srcPath, (FileSystem)srcFs, new Path(parityFolder + "/" + encodingStatus.getParityFileName()), blockSize, corruptOffset, limit, null);
    }

    static long now() {
        return System.currentTimeMillis();
    }

    static Path makeRelative(Path path) {
        if (!path.isAbsolute()) {
            return path;
        }
        String p = path.toUri().getPath();
        String relative = p.substring(1, p.length());
        return new Path(relative);
    }

    public static String getJobID(Configuration conf) {
        return conf.get("mapred.job.id", "localRaid" + df.format(new Date()));
    }

    public static void logRaidEncodingMetrics(String result, Codec codec, long delay, long numReadBytes, long numReadBlocks, long metaBlocks, long metaBytes, long savingBytes, Path srcPath, LOGTYPES type, FileSystem fs) {
        JSONObject json = new JSONObject();
        json.put((Object)"result", (Object)result);
        json.put((Object)"code", (Object)codec.id);
        json.put((Object)"delay", (Object)delay);
        json.put((Object)"readbytes", (Object)numReadBytes);
        json.put((Object)"readblocks", (Object)numReadBlocks);
        json.put((Object)"metablocks", (Object)metaBlocks);
        json.put((Object)"metabytes", (Object)metaBytes);
        json.put((Object)"savingbytes", (Object)savingBytes);
        json.put((Object)"path", (Object)srcPath.toString());
        json.put((Object)"type", (Object)type.name());
        json.put((Object)"cluster", (Object)fs.getUri().getAuthority());
        ENCODER_METRICS_LOG.info((Object)json.toString());
    }

    public static class Statistics {
        long numProcessedBlocks;
        long processedSize;
        long remainingSize;
        long numMetaBlocks;
        long metaSize;

        public void clear() {
            this.numProcessedBlocks = 0L;
            this.processedSize = 0L;
            this.remainingSize = 0L;
            this.numMetaBlocks = 0L;
            this.metaSize = 0L;
        }

        public String toString() {
            long save = this.processedSize - (this.remainingSize + this.metaSize);
            long savep = 0L;
            if (this.processedSize > 0L) {
                savep = save * 100L / this.processedSize;
            }
            String msg = " numProcessedBlocks = " + this.numProcessedBlocks + " processedSize = " + this.processedSize + " postRaidSize = " + this.remainingSize + " numMetaBlocks = " + this.numMetaBlocks + " metaSize = " + this.metaSize + " %save in raw disk space = " + savep;
            return msg;
        }
    }

    public static enum LOGTYPES {
        ONLINE_RECONSTRUCTION,
        OFFLINE_RECONSTRUCTION,
        ENCODING;

    }
}

