/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.RaidUtils;
import io.hops.erasure_coding.StripeReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileStripeReader
extends StripeReader {
    long srcSize;
    FileSystem fs;
    Path srcFile;
    long stripeStartOffset;
    long blockSize;

    public FileStripeReader(Configuration conf, long blockSize, Codec codec, FileSystem fs, long stripeStartIdx, Path srcFile, long srcSize) {
        super(conf, codec, fs, stripeStartIdx);
        this.blockSize = blockSize;
        this.stripeStartOffset = stripeStartIdx * (long)codec.stripeLength * blockSize;
        this.fs = fs;
        this.srcFile = srcFile;
        this.srcSize = srcSize;
    }

    @Override
    public boolean hasNext() {
        return this.stripeStartOffset < this.srcSize;
    }

    @Override
    public InputStream[] getNextStripeInputs() throws IOException {
        InputStream[] blocks = new InputStream[this.codec.stripeLength];
        try {
            for (int i = 0; i < this.codec.stripeLength; ++i) {
                long seekOffset = this.stripeStartOffset + (long)i * this.blockSize;
                if (seekOffset < this.srcSize) {
                    FSDataInputStream in = this.fs.open(this.srcFile, this.bufferSize);
                    in.seek(seekOffset);
                    LOG.info((Object)("Opening stream at " + this.srcFile + ":" + seekOffset));
                    blocks[i] = in;
                    continue;
                }
                LOG.info((Object)("Using zeros at offset " + seekOffset));
                blocks[i] = new RaidUtils.ZeroInputStream(seekOffset + this.blockSize);
            }
            this.stripeStartOffset += this.blockSize * (long)this.codec.stripeLength;
            return blocks;
        }
        catch (IOException e) {
            RaidUtils.closeStreams(blocks);
            throw e;
        }
    }

    @Override
    public InputStream buildOneInput(int locationIndex, long offsetInBlock, FileSystem srcFs, Path srcFile, FileStatus srcStat, FileSystem parityFs, Path parityFile, FileStatus parityStat) throws IOException {
        long blockSize = srcStat.getBlockSize();
        LOG.info((Object)("buildOneInput srcfile " + srcFile + " srclen " + srcStat.getLen() + " parityfile " + parityFile + " paritylen " + parityStat.getLen() + " stripeindex " + this.stripeStartIdx + " locationindex " + locationIndex + " offsetinblock " + offsetInBlock));
        if (locationIndex < this.codec.parityLength) {
            return this.getParityFileInput(locationIndex, parityFile, parityFs, parityStat, offsetInBlock);
        }
        int blockIdxInStripe = locationIndex - this.codec.parityLength;
        int blockIdx = (int)((long)this.codec.stripeLength * this.stripeStartIdx + (long)blockIdxInStripe);
        long offset = blockSize * (long)blockIdx + offsetInBlock;
        if (offset >= srcStat.getLen()) {
            LOG.info((Object)("Using zeros for " + srcFile + ":" + offset + " for location " + locationIndex));
            return new RaidUtils.ZeroInputStream(blockSize * (long)(blockIdx + 1));
        }
        LOG.info((Object)("Opening " + srcFile + ":" + offset + " for location " + locationIndex));
        FSDataInputStream s = this.fs.open(srcFile, this.conf.getInt("io.file.buffer.size", 65536));
        s.seek(offset);
        return s;
    }
}

