/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.ErasureCode;
import io.hops.erasure_coding.ReedSolomonCode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawErasureCoderFactory;

public class NativeReedSolomonCode
extends ErasureCode {
    public static final Log LOG = LogFactory.getLog(NativeReedSolomonCode.class);
    private int stripeSize;
    private int paritySize;
    NativeRSRawErasureCoderFactory factory;
    NativeRSRawEncoder encoder;
    NativeRSRawDecoder decoder;

    private void init(int stripeSize, int paritySize) {
        this.stripeSize = stripeSize;
        this.paritySize = paritySize;
        this.factory = new NativeRSRawErasureCoderFactory();
        this.encoder = (NativeRSRawEncoder)this.factory.createEncoder(new ErasureCoderOptions(this.stripeSize, this.paritySize));
        this.decoder = (NativeRSRawDecoder)this.factory.createDecoder(new ErasureCoderOptions(this.stripeSize, this.paritySize));
    }

    public void encodeBulk(byte[][] inputs, byte[][] outputs) throws IOException {
        int j;
        int i;
        ByteBuffer[] binputs = new ByteBuffer[inputs.length];
        ByteBuffer[] boutputs = new ByteBuffer[outputs.length];
        int size = inputs[0].length;
        int[] inputOffsets = new int[inputs.length];
        int[] outputOffsets = new int[outputs.length];
        for (i = 0; i < binputs.length; ++i) {
            binputs[i] = ByteBuffer.allocateDirect(size);
            for (j = 0; j < size; ++j) {
                binputs[i].put(inputs[i][j]);
            }
            binputs[i].flip();
        }
        for (i = 0; i < boutputs.length; ++i) {
            boutputs[i] = ByteBuffer.allocateDirect(size);
        }
        this.encoder.performEncodeImpl(binputs, inputOffsets, size, boutputs, outputOffsets);
        for (i = 0; i < boutputs.length; ++i) {
            for (j = 0; j < size; ++j) {
                try {
                    byte b;
                    outputs[i][j] = b = boutputs[i].get();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }

    public void decodeBulk(byte[][] readBufs, byte[][] writeBufs, int[] erasedLocations, int[] locationsToRead, int[] locationsNotToRead) throws IOException {
        int i;
        int j;
        int i2;
        ByteBuffer[] breadBufs = new ByteBuffer[readBufs.length];
        ByteBuffer[] bwriteBufs = new ByteBuffer[locationsNotToRead.length];
        int size = readBufs[0].length;
        int[] inputOffsets = new int[readBufs.length];
        int[] outputOffsets = new int[locationsNotToRead.length];
        for (i2 = 0; i2 < this.paritySize; ++i2) {
            breadBufs[i2 + this.stripeSize] = ByteBuffer.allocateDirect(size);
            for (j = 0; j < size; ++j) {
                breadBufs[i2 + this.stripeSize].put(readBufs[i2][j]);
            }
            breadBufs[i2 + this.stripeSize].flip();
        }
        for (i2 = 0; i2 < this.stripeSize; ++i2) {
            breadBufs[i2] = ByteBuffer.allocateDirect(size);
            for (j = 0; j < size; ++j) {
                breadBufs[i2].put(readBufs[i2 + this.paritySize][j]);
            }
            breadBufs[i2].flip();
        }
        int[] modifiedLocationsNotRead = new int[locationsNotToRead.length];
        for (i = 0; i < locationsNotToRead.length; ++i) {
            int location = locationsNotToRead[i];
            if (location < this.paritySize) {
                breadBufs[location + this.stripeSize] = null;
                modifiedLocationsNotRead[i] = location + this.stripeSize;
                continue;
            }
            breadBufs[location - this.paritySize] = null;
            modifiedLocationsNotRead[i] = location - this.paritySize;
        }
        Arrays.sort(modifiedLocationsNotRead);
        for (i = 0; i < modifiedLocationsNotRead.length; ++i) {
            bwriteBufs[i] = ByteBuffer.allocateDirect(size);
        }
        this.decoder.performDecodeImpl(breadBufs, inputOffsets, size, modifiedLocationsNotRead, bwriteBufs, outputOffsets);
        for (i = 0; i < writeBufs.length; ++i) {
            for (int j2 = 0; j2 < size; ++j2) {
                writeBufs[i][j2] = bwriteBufs[i].get();
            }
        }
    }

    public void encode(int[] message, int[] parity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void decode(int[] data, int[] erasedLocations, int[] erasedValues) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void decode(int[] data, int[] erasedLocations, int[] erasedValues, int[] locationsToRead, int[] locationsNotToRead) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void init(Codec codec) {
        this.init(codec.stripeLength, codec.parityLength);
        LOG.info((Object)("Initialized " + ReedSolomonCode.class + " stripeLength:" + codec.stripeLength + " parityLength:" + codec.parityLength));
    }

    public int stripeSize() {
        return this.stripeSize;
    }

    public int paritySize() {
        return this.paritySize;
    }

    public int symbolSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void releaseEncoder() {
        this.encoder.release();
    }

    public void releaseDecoder() {
        this.decoder.release();
    }
}

