/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.Encoder;
import io.hops.erasure_coding.ParallelStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Progressable;

public class XOREncoder
extends Encoder {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.raid.XOREncoder");

    public XOREncoder(Configuration conf) {
        super(conf, Codec.getCodec((String)"xor"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeStripeImpl(InputStream[] blocks, long stripeStartOffset, long blockSize, OutputStream[] outs, Progressable reporter) throws IOException {
        int boundedBufferCapacity = 1;
        ParallelStreamReader parallelReader = new ParallelStreamReader(reporter, blocks, this.bufSize, this.parallelism, boundedBufferCapacity, blockSize);
        parallelReader.start();
        try {
            this.encodeStripeParallel(blocks, stripeStartOffset, blockSize, outs, reporter, parallelReader);
        }
        finally {
            parallelReader.shutdown();
        }
    }

    protected void encodeStripeParallel(InputStream[] blocks, long stripeStartOffset, long blockSize, OutputStream[] outs, Progressable reporter, ParallelStreamReader parallelReader) throws IOException {
        for (long encoded = 0L; encoded < blockSize; encoded += (long)this.bufSize) {
            ParallelStreamReader.ReadResult readResult;
            try {
                readResult = parallelReader.getReadResult();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while waiting for read result");
            }
            IOException readEx = readResult.getException();
            if (readEx != null) {
                throw readEx;
            }
            XOREncoder.xor(readResult.readBufs, this.writeBufs[0]);
            reporter.progress();
            outs[0].write(this.writeBufs[0], 0, this.bufSize);
            reporter.progress();
        }
    }

    static void xor(byte[][] inputs, byte[] output) {
        int bufSize = output.length;
        for (int j = 0; j < bufSize; ++j) {
            output[j] = inputs[0][j];
        }
        for (int i = 1; i < inputs.length; ++i) {
            for (int j = 0; j < bufSize; ++j) {
                int n = j;
                output[n] = (byte)(output[n] ^ inputs[i][j]);
            }
        }
    }
}

