/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.hops.erasure_coding.BaseEncodingManager;
import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.Decoder;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.util.ReflectionUtils;

public class ErasureCodingFileSystem
extends FilterFileSystem {
    public static final int SKIP_BUF_SIZE = 2048;
    Configuration conf;

    ErasureCodingFileSystem() throws IOException {
    }

    ErasureCodingFileSystem(FileSystem fs) throws IOException {
        super(fs);
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        this.conf = conf;
        Codec.initializeCodecs((Configuration)conf);
        Class clazz = conf.getClass("fs.raid.underlyingfs.impl", DistributedFileSystem.class);
        if (clazz == null) {
            throw new IOException("No FileSystem for fs.raid.underlyingfs.impl.");
        }
        this.fs = (FileSystem)ReflectionUtils.newInstance((Class)clazz, null);
        super.initialize(name, conf);
    }

    public FileSystem getFileSystem() throws IOException {
        return this.fs;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        if (this.fs instanceof DistributedFileSystem) {
            DistributedFileSystem underlyingDfs = (DistributedFileSystem)this.fs;
            FileStatus fileStatus = underlyingDfs.getFileStatus(f);
            EncodingStatus encodingStatus = underlyingDfs.getEncodingStatus(f.toUri().getPath());
            if (encodingStatus.isEncoded()) {
                long fileSize = fileStatus.getLen();
                if (fileSize > 0L) {
                    System.out.println("Using recovery stream");
                    return new ExtFSDataInputStream(this.conf, this, f, fileSize, fileStatus.getBlockSize(), bufferSize);
                }
                System.out.println("Wrong file size " + fileSize);
            }
            System.out.println("Wrong encoding status " + encodingStatus.getStatus());
        } else {
            System.out.println("Wrong file system");
        }
        return this.fs.open(f, bufferSize);
    }

    public void close() throws IOException {
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        return this.fs.listLocatedStatus(f, filter);
    }

    private static class ExtFSDataInputStream
    extends FSDataInputStream {
        public ExtFSDataInputStream(Configuration conf, ErasureCodingFileSystem lfs, Path p, long fileSize, long blockSize, int buffersize) throws IOException {
            super((InputStream)((Object)new ExtFsInputStream(conf, lfs, p, fileSize, blockSize, buffersize)));
        }

        private static class ExtFsInputStream
        extends FSInputStream {
            private UnderlyingBlock[] underlyingBlocks;
            private long currentOffset;
            private FSDataInputStream currentStream;
            private Decoder.DecoderInputStream recoveryStream;
            private boolean useRecoveryStream;
            private UnderlyingBlock currentBlock;
            private byte[] oneBytebuff = new byte[1];
            private byte[] skipbuf = new byte[2048];
            private int nextLocation;
            private ErasureCodingFileSystem lfs;
            private Path path;
            private final long fileSize;
            private final long blockSize;
            private final int buffersize;
            private final Configuration conf;
            private Configuration innerConf;

            ExtFsInputStream(Configuration conf, ErasureCodingFileSystem lfs, Path path, long fileSize, long blockSize, int buffersize) throws IOException {
                this.path = path;
                this.nextLocation = 0;
                this.blockSize = blockSize;
                this.fileSize = fileSize;
                long numBlocks = this.fileSize % this.blockSize == 0L ? this.fileSize / this.blockSize : 1L + this.fileSize / this.blockSize;
                this.underlyingBlocks = new UnderlyingBlock[(int)numBlocks];
                int i = 0;
                while ((long)i < numBlocks) {
                    long actualFileOffset = (long)i * blockSize;
                    long originalFileOffset = (long)i * blockSize;
                    long length = Math.min(blockSize, fileSize - originalFileOffset);
                    this.underlyingBlocks[i] = new UnderlyingBlock(path, actualFileOffset, originalFileOffset, length);
                    ++i;
                }
                this.currentOffset = 0L;
                this.currentBlock = null;
                this.buffersize = buffersize;
                this.conf = conf;
                this.lfs = lfs;
                this.innerConf = new Configuration(conf);
                Class clazz = conf.getClass("fs.raid.underlyingfs.impl", DistributedFileSystem.class);
                this.innerConf.set("fs.hdfs.impl", clazz.getName());
                this.innerConf.setBoolean("fs.hdfs.impl.disable.cache", true);
                this.openCurrentStream();
            }

            private void closeCurrentStream() throws IOException {
                if (this.currentStream != null) {
                    this.currentStream.close();
                    this.currentStream = null;
                }
            }

            private void closeRecoveryStream() throws IOException {
                if (null != this.recoveryStream) {
                    this.recoveryStream.close();
                    this.recoveryStream = null;
                }
            }

            private void openCurrentStream() throws IOException {
                if (this.recoveryStream != null && this.recoveryStream.getCurrentOffset() == this.currentOffset && this.recoveryStream.getAvailable() > 0L) {
                    this.useRecoveryStream = true;
                    this.closeCurrentStream();
                    return;
                }
                this.useRecoveryStream = false;
                this.closeRecoveryStream();
                int blockIdx = this.currentOffset < this.fileSize ? (int)(this.currentOffset / this.blockSize) : this.underlyingBlocks.length - 1;
                UnderlyingBlock block = this.underlyingBlocks[blockIdx];
                if (this.currentBlock == block || this.currentBlock != null && this.currentBlock.path == block.path) {
                    if (this.currentStream != null) {
                        this.currentBlock = block;
                        return;
                    }
                } else {
                    this.closeCurrentStream();
                }
                this.currentBlock = block;
                this.currentStream = this.lfs.fs.open(this.currentBlock.path, this.buffersize);
                long offset = block.actualFileOffset + (this.currentOffset - block.originalFileOffset);
                this.currentStream.seek(offset);
            }

            private int blockAvailable() {
                return (int)(this.currentBlock.length - (this.currentOffset - this.currentBlock.originalFileOffset));
            }

            public synchronized int available() throws IOException {
                this.nextLocation = 0;
                return Math.min(this.blockAvailable(), this.currentStream.available());
            }

            public synchronized void close() throws IOException {
                this.closeCurrentStream();
                this.closeRecoveryStream();
                super.close();
            }

            public boolean markSupported() {
                return false;
            }

            public void mark(int readLimit) {
                this.nextLocation = 0;
            }

            public void reset() throws IOException {
                this.nextLocation = 0;
            }

            public synchronized int read() throws IOException {
                int value = this.read(this.oneBytebuff, 0, 1);
                if (value < 0) {
                    return value;
                }
                return 0xFF & this.oneBytebuff[0];
            }

            public synchronized int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            public synchronized int read(byte[] b, int offset, int len) throws IOException {
                int value;
                if (this.currentOffset >= this.fileSize) {
                    return -1;
                }
                this.openCurrentStream();
                int limit = Math.min(this.blockAvailable(), len);
                if (this.useRecoveryStream) {
                    value = this.recoveryStream.read(b, offset, limit);
                } else {
                    try {
                        value = this.currentStream.read(b, offset, limit);
                    }
                    catch (BlockMissingException e) {
                        value = this.readViaCodec(b, offset, limit, this.blockAvailable(), (IOException)((Object)e));
                    }
                    catch (ChecksumException e) {
                        value = this.readViaCodec(b, offset, limit, this.blockAvailable(), (IOException)((Object)e));
                    }
                }
                this.currentOffset += (long)value;
                this.nextLocation = 0;
                return value;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized int read(long position, byte[] b, int offset, int len) throws IOException {
                long oldPos = this.currentOffset;
                this.seek(position);
                try {
                    int value;
                    if (this.currentOffset >= this.fileSize) {
                        int n = -1;
                        return n;
                    }
                    this.openCurrentStream();
                    int limit = Math.min(this.blockAvailable(), len);
                    if (this.useRecoveryStream) {
                        value = this.recoveryStream.read(b, offset, limit);
                    } else {
                        try {
                            value = this.currentStream.read(b, offset, limit);
                        }
                        catch (BlockMissingException e) {
                            value = this.readViaCodec(b, offset, limit, limit, (IOException)((Object)e));
                        }
                        catch (ChecksumException e) {
                            value = this.readViaCodec(b, offset, limit, limit, (IOException)((Object)e));
                        }
                    }
                    this.currentOffset += (long)value;
                    this.nextLocation = 0;
                    int n = value;
                    return n;
                }
                finally {
                    this.seek(oldPos);
                }
            }

            private int readViaCodec(byte[] b, int offset, int len, int streamLimit, IOException e) throws IOException {
                if (null == this.recoveryStream || this.recoveryStream.getCurrentOffset() != this.currentOffset) {
                    this.recoveryStream = this.getAlternateInputStream(e, this.currentOffset, streamLimit);
                }
                if (null == this.recoveryStream) {
                    throw e;
                }
                try {
                    int value = this.recoveryStream.read(b, offset, len);
                    this.closeCurrentStream();
                    return value;
                }
                catch (IOException ex) {
                    throw e;
                }
            }

            public synchronized long skip(long n) throws IOException {
                int toSkip;
                long skipped;
                int val;
                long startPos = this.getPos();
                for (skipped = 0L; skipped < n && (val = this.read(this.skipbuf, 0, toSkip = (int)Math.min(2048L, n - skipped))) >= 0; skipped += (long)val) {
                }
                this.nextLocation = 0;
                long newPos = this.getPos();
                if (newPos - startPos > n) {
                    throw new IOException("skip(" + n + ") went from " + startPos + " to " + newPos);
                }
                if (skipped != newPos - startPos) {
                    throw new IOException("skip(" + n + ") went from " + startPos + " to " + newPos + " but skipped=" + skipped);
                }
                return skipped;
            }

            public synchronized long getPos() throws IOException {
                this.nextLocation = 0;
                return this.currentOffset;
            }

            public synchronized void seek(long pos) throws IOException {
                if (pos > this.fileSize) {
                    throw new EOFException("Cannot seek to " + pos + ", file length is " + this.fileSize);
                }
                if (pos != this.currentOffset) {
                    this.closeCurrentStream();
                    this.currentOffset = pos;
                    this.openCurrentStream();
                }
                this.nextLocation = 0;
            }

            public boolean seekToNewSource(long targetPos) throws IOException {
                this.seek(targetPos);
                boolean value = this.currentStream.seekToNewSource(this.currentStream.getPos());
                this.nextLocation = 0;
                return value;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void readFully(long pos, byte[] b, int offset, int length) throws IOException {
                long oldPos = this.currentOffset;
                try {
                    long curPos = pos;
                    while (length > 0) {
                        int n = this.read(curPos, b, offset, length);
                        if (n < 0) {
                            throw new IOException("Premature EOF");
                        }
                        offset += n;
                        length -= n;
                        curPos += (long)n;
                    }
                    this.nextLocation = 0;
                    return;
                }
                finally {
                    this.seek(oldPos);
                }
            }

            public void readFully(long pos, byte[] b) throws IOException {
                this.readFully(pos, b, 0, b.length);
                this.nextLocation = 0;
            }

            private Decoder.DecoderInputStream getAlternateInputStream(IOException curexp, long offset, long readLimit) throws IOException {
                long corruptOffset = offset / this.blockSize * this.blockSize;
                long fileLen = this.lfs.getFileStatus(this.path).getLen();
                long limit = Math.min(readLimit, this.blockSize - (offset - corruptOffset));
                limit = Math.min(limit, fileLen);
                while (this.nextLocation < Codec.getCodecs().size()) {
                    try {
                        int idx;
                        ++this.nextLocation;
                        Codec codec = (Codec)Codec.getCodecs().get(idx);
                        Decoder.DecoderInputStream recoveryStream = BaseEncodingManager.unRaidCorruptInputStream(this.innerConf, this.path, this.blockSize, offset, limit);
                        if (null == recoveryStream) continue;
                        return recoveryStream;
                    }
                    catch (Exception e) {
                        FileSystem.LOG.info((Object)("Ignoring error in using alternate path " + this.path), (Throwable)e);
                    }
                }
                FileSystem.LOG.warn((Object)("Could not reconstruct block " + this.path + ":" + offset));
                throw curexp;
            }

            private FileSystem getUnderlyingFileSystem(Configuration conf) {
                Class clazz = conf.getClass("fs.raid.underlyingfs.impl", DistributedFileSystem.class);
                FileSystem fs = (FileSystem)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
                return fs;
            }
        }

        private static class UnderlyingBlock {
            public Path path;
            public long actualFileOffset;
            public long originalFileOffset;
            public long length;

            public UnderlyingBlock(Path path, long actualFileOffset, long originalFileOffset, long length) {
                this.path = path;
                this.actualFileOffset = actualFileOffset;
                this.originalFileOffset = originalFileOffset;
                this.length = length;
            }
        }
    }
}

