/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.BaseEncodingManager;
import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.ErasureCode;
import io.hops.erasure_coding.ParallelStreamReader;
import io.hops.erasure_coding.RaidUtils;
import io.hops.erasure_coding.StripeReader;
import io.hops.erasure_coding.TooManyErasedLocations;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.json.JSONException;
import org.json.JSONObject;

public class Decoder {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.raid.Decoder");
    private final Log DECODER_METRICS_LOG = LogFactory.getLog((String)"RaidMetrics");
    public static final int DEFAULT_PARALLELISM = 4;
    protected Configuration conf;
    protected int parallelism;
    protected Codec codec;
    protected ErasureCode code;
    protected Random rand;
    protected int bufSize;
    protected byte[][] readBufs;
    protected byte[][] writeBufs;
    private int numMissingBlocksInStripe;
    private long numReadBytes;

    public Decoder(Configuration conf, Codec codec) {
        this.conf = conf;
        this.parallelism = conf.getInt("raid.encoder.parallelism", 4);
        this.codec = codec;
        this.code = codec.createErasureCode(conf);
        this.rand = new Random();
        this.bufSize = conf.getInt("raid.decoder.bufsize", 0x100000);
        this.writeBufs = new byte[codec.parityLength][];
        this.readBufs = new byte[codec.parityLength + codec.stripeLength][];
    }

    public int getNumMissingBlocksInStripe() {
        return this.numMissingBlocksInStripe;
    }

    public long getNumReadBytes() {
        return this.numReadBytes;
    }

    private void allocateBuffers() {
        for (int i = 0; i < this.writeBufs.length; ++i) {
            this.writeBufs[i] = new byte[this.bufSize];
        }
    }

    private void configureBuffers(long blockSize) {
        if ((long)this.bufSize > blockSize) {
            this.bufSize = (int)blockSize;
            this.allocateBuffers();
        } else if (blockSize % (long)this.bufSize != 0L) {
            this.bufSize = (int)(blockSize / 256L);
            if (this.bufSize == 0) {
                this.bufSize = 1024;
            }
            this.bufSize = Math.min(this.bufSize, 0x100000);
            this.allocateBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverParityBlockToFile(FileSystem srcFs, Path srcPath, FileSystem parityFs, Path parityPath, long blockSize, long blockOffset, File localBlockFile, Mapper.Context context) throws IOException, InterruptedException {
        DistributedFileSystem dfs = (DistributedFileSystem)srcFs;
        long crc32 = dfs.getClient().getBlockChecksum(parityPath.toUri().toString(), (int)(blockOffset / blockSize));
        try (FileOutputStream out = null;){
            out = new FileOutputStream(localBlockFile);
            this.fixErasedBlock(srcFs, srcPath, parityFs, parityPath, false, blockSize, blockOffset, blockSize, false, out, context, false, crc32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverBlockToFile(FileSystem srcFs, Path srcPath, FileSystem parityFs, Path parityPath, long blockSize, long blockOffset, File localBlockFile, long limit, Mapper.Context context) throws IOException, InterruptedException {
        DistributedFileSystem dfs = (DistributedFileSystem)srcFs;
        long crc32 = dfs.getClient().getBlockChecksum(srcPath.toUri().getPath(), (int)(blockOffset / blockSize));
        try (FileOutputStream out = null;){
            out = new FileOutputStream(localBlockFile);
            this.fixErasedBlock(srcFs, srcPath, parityFs, parityPath, true, blockSize, blockOffset, limit, false, out, context, false, crc32);
        }
    }

    DecoderInputStream generateAlternateStream(FileSystem srcFs, Path srcFile, FileSystem parityFs, Path parityFile, long blockSize, long errorOffset, long limit, Mapper.Context context) {
        this.configureBuffers(blockSize);
        Mapper.Context reporter = context;
        if (reporter == null) {
            reporter = RaidUtils.NULL_PROGRESSABLE;
        }
        DecoderInputStream decoderInputStream = new DecoderInputStream((Progressable)reporter, limit, blockSize, errorOffset, srcFs, srcFile, parityFs, parityFile);
        return decoderInputStream;
    }

    void fixErasedBlock(FileSystem srcFs, Path srcFile, FileSystem parityFs, Path parityFile, boolean fixSource, long blockSize, long errorOffset, long limit, boolean partial, OutputStream out, Mapper.Context context, boolean skipVerify, long oldCrc) throws IOException, InterruptedException {
        Mapper.Context reporter = context;
        if (reporter == null) {
            reporter = RaidUtils.NULL_PROGRESSABLE;
        }
        CRC32 crc = new CRC32();
        this.fixErasedBlockImpl(srcFs, srcFile, parityFs, parityFile, fixSource, blockSize, errorOffset, limit, partial, out, (Progressable)reporter, crc);
        if (crc.getValue() != oldCrc) {
            throw new BlockChecksumException(String.format("Repair of %s at offset %d failed. Checksum differs from stored checksum", fixSource ? srcFile : parityFile, errorOffset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long fixErasedBlockImpl(FileSystem srcFs, Path srcFile, FileSystem parityFs, Path parityFile, boolean fixSource, long blockSize, long errorOffset, long limit, boolean partial, OutputStream out, Progressable reporter, CRC32 crc) throws IOException {
        int erasedLocationToFix;
        long startTime = System.currentTimeMillis();
        if (crc != null) {
            crc.reset();
        }
        int blockIdx = (int)(errorOffset / blockSize);
        StripeReader.LocationPair lp = null;
        if (fixSource) {
            lp = StripeReader.getBlockLocation(this.codec, blockIdx);
            erasedLocationToFix = this.codec.parityLength + lp.getBlockIdxInStripe();
        } else {
            lp = StripeReader.getParityBlockLocation(this.codec, blockIdx);
            erasedLocationToFix = lp.getBlockIdxInStripe();
        }
        FileStatus srcStat = srcFs.getFileStatus(srcFile);
        FileStatus parityStat = parityFs.getFileStatus(parityFile);
        InputStream[] inputs = null;
        ArrayList<Integer> erasedLocations = new ArrayList<Integer>();
        erasedLocations.add(erasedLocationToFix);
        ArrayList<Integer> locationsToRead = new ArrayList<Integer>(this.codec.parityLength + this.codec.stripeLength);
        int boundedBufferCapacity = 2;
        ParallelStreamReader parallelReader = null;
        LOG.info((Object)("Need to write " + limit + " bytes for erased location index " + erasedLocationToFix));
        long startOffsetInBlock = 0L;
        if (partial) {
            startOffsetInBlock = errorOffset % blockSize;
        }
        int[] erasedLocationsArray = new int[]{};
        int[] locationsToReadArray = new int[]{};
        int[] locationsNotToReadArray = new int[]{};
        try {
            this.numReadBytes = 0L;
            long written = 0L;
            block5: while (written < limit) {
                try {
                    if (parallelReader == null) {
                        int loc;
                        long offsetInBlock = written + startOffsetInBlock;
                        StripeReader sReader = StripeReader.getStripeReader(this.codec, this.conf, blockSize, srcFs, lp.getStripeIdx(), srcStat);
                        inputs = sReader.buildInputs(srcFs, srcFile, srcStat, parityFs, parityFile, parityStat, lp.getStripeIdx(), offsetInBlock, erasedLocations, locationsToRead, this.code);
                        LOG.info((Object)("Erased locations: " + ((Object)erasedLocations).toString() + "\nLocations to Read for repair:" + ((Object)locationsToRead).toString()));
                        int i = 0;
                        erasedLocationsArray = new int[erasedLocations.size()];
                        for (loc = 0; loc < this.codec.stripeLength + this.codec.parityLength; ++loc) {
                            if (erasedLocations.indexOf(loc) < 0) continue;
                            erasedLocationsArray[i] = loc;
                            ++i;
                        }
                        i = 0;
                        locationsToReadArray = new int[locationsToRead.size()];
                        for (loc = 0; loc < this.codec.stripeLength + this.codec.parityLength; ++loc) {
                            if (locationsToRead.indexOf(loc) < 0) continue;
                            locationsToReadArray[i] = loc;
                            ++i;
                        }
                        i = 0;
                        locationsNotToReadArray = new int[this.codec.stripeLength + this.codec.parityLength - locationsToRead.size()];
                        for (loc = 0; loc < this.codec.stripeLength + this.codec.parityLength; ++loc) {
                            if (locationsToRead.indexOf(loc) != -1 && erasedLocations.indexOf(loc) == -1) continue;
                            locationsNotToReadArray[i] = loc;
                            ++i;
                        }
                        this.writeBufs = new byte[erasedLocations.size()][];
                        this.allocateBuffers();
                        assert (parallelReader == null);
                        parallelReader = new ParallelStreamReader(reporter, inputs, (int)Math.min((long)this.bufSize, limit), this.parallelism, boundedBufferCapacity, Math.min(limit, blockSize));
                        parallelReader.start();
                    }
                    ParallelStreamReader.ReadResult readResult = this.readFromInputs(erasedLocations, limit, reporter, parallelReader);
                    this.code.decodeBulk(readResult.readBufs, this.writeBufs, erasedLocationsArray, locationsToReadArray, locationsNotToReadArray);
                    for (int readNum : readResult.numRead) {
                        this.numReadBytes += (long)readNum;
                    }
                    int toWrite = (int)Math.min((long)this.bufSize, limit - written);
                    for (int i = 0; i < erasedLocationsArray.length; ++i) {
                        if (erasedLocationsArray[i] != erasedLocationToFix) continue;
                        if (out != null) {
                            out.write(this.writeBufs[i], 0, toWrite);
                        }
                        if (crc != null) {
                            crc.update(this.writeBufs[i], 0, toWrite);
                        }
                        written += (long)toWrite;
                        continue block5;
                    }
                }
                catch (IOException e) {
                    if (e instanceof TooManyErasedLocations) {
                        this.logRaidReconstructionMetrics("FAILURE", 0L, this.codec, System.currentTimeMillis() - startTime, erasedLocations.size(), this.numReadBytes, srcFile, errorOffset, BaseEncodingManager.LOGTYPES.OFFLINE_RECONSTRUCTION, srcFs);
                        throw e;
                    }
                    if (parallelReader != null) {
                        parallelReader.shutdown();
                        parallelReader = null;
                    }
                    RaidUtils.closeStreams(inputs);
                }
            }
            this.logRaidReconstructionMetrics("SUCCESS", written, this.codec, System.currentTimeMillis() - startTime, erasedLocations.size(), this.numReadBytes, srcFile, errorOffset, BaseEncodingManager.LOGTYPES.OFFLINE_RECONSTRUCTION, srcFs);
            long l = written;
            return l;
        }
        finally {
            this.numMissingBlocksInStripe = erasedLocations.size();
            if (parallelReader != null) {
                parallelReader.shutdown();
            }
            RaidUtils.closeStreams(inputs);
        }
    }

    ParallelStreamReader.ReadResult readFromInputs(List<Integer> erasedLocations, long limit, Progressable reporter, ParallelStreamReader parallelReader) throws IOException {
        ParallelStreamReader.ReadResult readResult;
        try {
            long start = System.currentTimeMillis();
            readResult = parallelReader.getReadResult();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for read result");
        }
        IOException exceptionToThrow = null;
        for (int i = 0; i < readResult.ioExceptions.length; ++i) {
            IOException e = readResult.ioExceptions[i];
            if (e == null) continue;
            if (e instanceof BlockMissingException) {
                LOG.warn((Object)("Encountered BlockMissingException in stream " + i));
            } else if (e instanceof ChecksumException) {
                LOG.warn((Object)("Encountered ChecksumException in stream " + i));
            } else {
                throw e;
            }
            int newErasedLocation = i;
            erasedLocations.add(newErasedLocation);
            exceptionToThrow = e;
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        return readResult;
    }

    public void logRaidReconstructionMetrics(String result, long bytes, Codec codec, long delay, int numMissingBlocks, long numReadBytes, Path srcFile, long errorOffset, BaseEncodingManager.LOGTYPES type, FileSystem fs) {
        try {
            JSONObject json = new JSONObject();
            json.put("result", (Object)result);
            json.put("constructedbytes", bytes);
            json.put("code", (Object)codec.id);
            json.put("delay", delay);
            json.put("missingblocks", numMissingBlocks);
            json.put("readbytes", numReadBytes);
            json.put("file", (Object)srcFile.toString());
            json.put("offset", errorOffset);
            json.put("type", (Object)type.name());
            json.put("cluster", (Object)fs.getUri().getAuthority());
            this.DECODER_METRICS_LOG.info((Object)json.toString());
        }
        catch (JSONException e) {
            LOG.warn((Object)("Exception when logging the Raid metrics: " + e.getMessage()), (Throwable)e);
        }
    }

    public class DecoderInputStream
    extends InputStream {
        private long limit;
        private ParallelStreamReader parallelReader = null;
        private byte[] buffer;
        private long bufferLen;
        private int position;
        private long streamOffset = 0L;
        private final Progressable reporter;
        private InputStream[] inputs;
        private final int boundedBufferCapacity = 2;
        private final long blockSize;
        private final long errorOffset;
        private long startOffsetInBlock;
        private final FileSystem srcFs;
        private final Path srcFile;
        private final FileSystem parityFs;
        private final Path parityFile;
        private int blockIdx;
        private int erasedLocationToFix;
        private StripeReader.LocationPair locationPair;
        private long currentOffset;
        private long dfsNumRead = 0L;
        private final List<Integer> locationsToRead = new ArrayList<Integer>();
        private final List<Integer> erasedLocations = new ArrayList<Integer>();
        int[] erasedLocationsArray;
        int[] locationsToReadArray;
        int[] locationsNotToReadArray;

        public DecoderInputStream(Progressable reporter, long limit, long blockSize, long errorOffset, FileSystem srcFs, Path srcFile, FileSystem parityFs, Path parityFile) {
            this.reporter = reporter;
            this.limit = limit;
            this.blockSize = blockSize;
            this.errorOffset = errorOffset;
            this.srcFile = srcFile;
            this.srcFs = srcFs;
            this.parityFile = parityFile;
            this.parityFs = parityFs;
            this.blockIdx = (int)(errorOffset / blockSize);
            this.startOffsetInBlock = errorOffset % blockSize;
            this.currentOffset = errorOffset;
        }

        public long getCurrentOffset() {
            return this.currentOffset;
        }

        public long getAvailable() {
            return this.limit - this.streamOffset;
        }

        private void init() throws IOException {
            if (this.streamOffset >= this.limit) {
                this.buffer = null;
                return;
            }
            if (null == this.locationPair) {
                this.locationPair = StripeReader.getBlockLocation(Decoder.this.codec, this.blockIdx);
                this.erasedLocationToFix = Decoder.this.codec.parityLength + this.locationPair.getBlockIdxInStripe();
                this.erasedLocations.add(this.erasedLocationToFix);
            }
            if (null == this.parallelReader) {
                int loc;
                long offsetInBlock = this.streamOffset + this.startOffsetInBlock;
                FileStatus srcStat = this.srcFs.getFileStatus(this.srcFile);
                FileStatus parityStat = this.parityFs.getFileStatus(this.parityFile);
                StripeReader sReader = StripeReader.getStripeReader(Decoder.this.codec, Decoder.this.conf, this.blockSize, this.srcFs, this.locationPair.getStripeIdx(), srcStat);
                this.inputs = sReader.buildInputs(this.srcFs, this.srcFile, srcStat, this.parityFs, this.parityFile, parityStat, this.locationPair.getStripeIdx(), offsetInBlock, this.erasedLocations, this.locationsToRead, Decoder.this.code);
                LOG.info((Object)("Erased locations: " + this.erasedLocations.toString() + "\nLocations to Read for repair:" + this.locationsToRead.toString()));
                int i = 0;
                this.erasedLocationsArray = new int[this.erasedLocations.size()];
                for (loc = 0; loc < Decoder.this.codec.stripeLength + Decoder.this.codec.parityLength; ++loc) {
                    if (this.erasedLocations.indexOf(loc) < 0) continue;
                    this.erasedLocationsArray[i] = loc;
                    ++i;
                }
                i = 0;
                this.locationsToReadArray = new int[this.locationsToRead.size()];
                for (loc = 0; loc < Decoder.this.codec.stripeLength + Decoder.this.codec.parityLength; ++loc) {
                    if (this.locationsToRead.indexOf(loc) < 0) continue;
                    this.locationsToReadArray[i] = loc;
                    ++i;
                }
                i = 0;
                this.locationsNotToReadArray = new int[Decoder.this.codec.stripeLength + Decoder.this.codec.parityLength - this.locationsToRead.size()];
                for (loc = 0; loc < Decoder.this.codec.stripeLength + Decoder.this.codec.parityLength; ++loc) {
                    if (this.locationsToRead.indexOf(loc) != -1 && this.erasedLocations.indexOf(loc) == -1) continue;
                    this.locationsNotToReadArray[i] = loc;
                    ++i;
                }
                Decoder.this.writeBufs = new byte[this.erasedLocations.size()][];
                Decoder.this.allocateBuffers();
                assert (this.parallelReader == null);
                this.parallelReader = new ParallelStreamReader(this.reporter, this.inputs, (int)Math.min((long)Decoder.this.bufSize, this.limit), Decoder.this.parallelism, 2, this.limit);
                this.parallelReader.start();
            }
            if (null != this.buffer && (long)this.position == this.bufferLen) {
                this.buffer = null;
            }
            if (null == this.buffer) {
                ParallelStreamReader.ReadResult readResult = Decoder.this.readFromInputs(this.erasedLocations, this.limit, this.reporter, this.parallelReader);
                for (int readNum : readResult.numRead) {
                    this.dfsNumRead += (long)readNum;
                }
                Decoder.this.code.decodeBulk(readResult.readBufs, Decoder.this.writeBufs, this.erasedLocationsArray, this.locationsToReadArray, this.locationsNotToReadArray);
                for (int i = 0; i < this.erasedLocationsArray.length; ++i) {
                    if (this.erasedLocationsArray[i] != this.erasedLocationToFix) continue;
                    this.buffer = Decoder.this.writeBufs[i];
                    this.validateBlockChecksum(this.srcFile.toUri().getPath(), this.blockIdx, this.buffer);
                    this.bufferLen = Math.min((long)Decoder.this.bufSize, this.limit - this.streamOffset);
                    this.position = 0;
                    break;
                }
            }
        }

        private void validateBlockChecksum(String src, int blockIndex, byte[] buffer) throws IOException {
            long checksum = ((DistributedFileSystem)this.srcFs).getClient().getBlockChecksum(src, blockIndex);
            CRC32 crc = new CRC32();
            crc.update(buffer);
            if (checksum != crc.getValue()) {
                throw new BlockChecksumException("Repair failed. Checksum of repaired block differs from original");
            }
        }

        private void checkBuffer() throws IOException {
            while (this.streamOffset <= this.limit) {
                try {
                    this.init();
                    break;
                }
                catch (IOException e) {
                    if (e instanceof TooManyErasedLocations || e instanceof BlockChecksumException) {
                        throw e;
                    }
                    if (this.parallelReader != null) {
                        this.parallelReader.shutdown();
                        this.parallelReader = null;
                    }
                    if (this.inputs == null) continue;
                    RaidUtils.closeStreams(this.inputs);
                }
            }
        }

        @Override
        public int read() throws IOException {
            this.checkBuffer();
            if (null == this.buffer) {
                return -1;
            }
            int result = this.buffer[this.position] & 0xFF;
            ++this.position;
            ++this.streamOffset;
            ++this.currentOffset;
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int numRead;
            int numBytesToCopy;
            long startTime = System.currentTimeMillis();
            this.dfsNumRead = 0L;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            for (numRead = 0; numRead < len; numRead += numBytesToCopy) {
                try {
                    this.checkBuffer();
                }
                catch (IOException e) {
                    long delay = System.currentTimeMillis() - startTime;
                    Decoder.this.logRaidReconstructionMetrics("FAILURE", 0L, Decoder.this.codec, delay, this.erasedLocations.size(), this.dfsNumRead, this.srcFile, this.errorOffset, BaseEncodingManager.LOGTYPES.ONLINE_RECONSTRUCTION, this.srcFs);
                    throw e;
                }
                if (null == this.buffer) {
                    if (numRead > 0) {
                        Decoder.this.logRaidReconstructionMetrics("SUCCESS", numRead, Decoder.this.codec, System.currentTimeMillis() - startTime, this.erasedLocations.size(), this.dfsNumRead, this.srcFile, this.errorOffset, BaseEncodingManager.LOGTYPES.ONLINE_RECONSTRUCTION, this.srcFs);
                        return numRead;
                    }
                    return -1;
                }
                numBytesToCopy = (int)Math.min(this.bufferLen - (long)this.position, (long)(len - numRead));
                System.arraycopy(this.buffer, this.position, b, off, numBytesToCopy);
                this.position += numBytesToCopy;
                this.currentOffset += (long)numBytesToCopy;
                this.streamOffset += (long)numBytesToCopy;
                off += numBytesToCopy;
            }
            if (numRead > 0) {
                Decoder.this.logRaidReconstructionMetrics("SUCCESS", numRead, Decoder.this.codec, System.currentTimeMillis() - startTime, this.erasedLocations.size(), this.dfsNumRead, this.srcFile, this.errorOffset, BaseEncodingManager.LOGTYPES.ONLINE_RECONSTRUCTION, this.srcFs);
            }
            return numRead;
        }

        @Override
        public void close() throws IOException {
            if (this.parallelReader != null) {
                this.parallelReader.shutdown();
                this.parallelReader = null;
            }
            if (this.inputs != null) {
                RaidUtils.closeStreams(this.inputs);
            }
            super.close();
        }
    }

    public static class BlockChecksumException
    extends IOException {
        public BlockChecksumException() {
        }

        public BlockChecksumException(String message) {
            super(message);
        }

        public BlockChecksumException(String message, Throwable cause) {
            super(message, cause);
        }

        public BlockChecksumException(Throwable cause) {
            super(cause);
        }
    }
}

