/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import java.util.HashMap;
import java.util.Map;

public class GaloisField {
    private final int[] logTable;
    private final int[] powTable;
    private final int[][] mulTable;
    private final int[][] divTable;
    private final int fieldSize;
    private final int primitivePeriod;
    private final int primitivePolynomial;
    private static final int DEFAULT_FIELD_SIZE = 256;
    private static final int DEFAULT_PRIMITIVE_POLYNOMIAL = 285;
    private static final Map<Integer, GaloisField> instances = new HashMap<Integer, GaloisField>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GaloisField getInstance(int fieldSize, int primitivePolynomial) {
        GaloisField gf;
        int key = (fieldSize << 16 & 0xFFFF0000) + (primitivePolynomial & 0xFFFF);
        Map<Integer, GaloisField> map = instances;
        synchronized (map) {
            gf = instances.get(key);
            if (gf == null) {
                gf = new GaloisField(fieldSize, primitivePolynomial);
                instances.put(key, gf);
            }
        }
        return gf;
    }

    public static GaloisField getInstance() {
        return GaloisField.getInstance(256, 285);
    }

    private GaloisField(int fieldSize, int primitivePolynomial) {
        int z;
        int j;
        int i;
        this.fieldSize = fieldSize;
        this.primitivePeriod = fieldSize - 1;
        this.primitivePolynomial = primitivePolynomial;
        this.logTable = new int[fieldSize];
        this.powTable = new int[fieldSize];
        this.mulTable = new int[fieldSize][fieldSize];
        this.divTable = new int[fieldSize][fieldSize];
        int value = 1;
        for (int pow = 0; pow < fieldSize - 1; ++pow) {
            this.powTable[pow] = value;
            this.logTable[value] = pow;
            if ((value *= 2) < fieldSize) continue;
            value ^= primitivePolynomial;
        }
        for (i = 0; i < fieldSize; ++i) {
            for (j = 0; j < fieldSize; ++j) {
                if (i == 0 || j == 0) {
                    this.mulTable[i][j] = 0;
                    continue;
                }
                z = this.logTable[i] + this.logTable[j];
                z = z >= this.primitivePeriod ? z - this.primitivePeriod : z;
                this.mulTable[i][j] = z = this.powTable[z];
            }
        }
        for (i = 0; i < fieldSize; ++i) {
            for (j = 1; j < fieldSize; ++j) {
                if (i == 0) {
                    this.divTable[i][j] = 0;
                    continue;
                }
                z = this.logTable[i] - this.logTable[j];
                z = z < 0 ? z + this.primitivePeriod : z;
                this.divTable[i][j] = z = this.powTable[z];
            }
        }
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public int getPrimitivePolynomial() {
        return this.primitivePolynomial;
    }

    public int add(int x, int y) {
        assert (x >= 0 && x < this.getFieldSize() && y >= 0 && y < this.getFieldSize());
        return x ^ y;
    }

    public int multiply(int x, int y) {
        assert (x >= 0 && x < this.getFieldSize() && y >= 0 && y < this.getFieldSize());
        return this.mulTable[x][y];
    }

    public int divide(int x, int y) {
        assert (x >= 0 && x < this.getFieldSize() && y >= 0 && y < this.getFieldSize());
        return this.divTable[x][y];
    }

    public int power(int x, int n) {
        assert (x >= 0 && x < this.getFieldSize());
        if (n == 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        if ((x = this.logTable[x] * n) < this.primitivePeriod) {
            return this.powTable[x];
        }
        return this.powTable[x %= this.primitivePeriod];
    }

    public void solveVandermondeSystem(int[] x, int[] y) {
        this.solveVandermondeSystem(x, y, x.length);
    }

    public void solveVandermondeSystem(int[] x, int[] y, int len) {
        int j;
        int i;
        for (i = 0; i < len - 1; ++i) {
            for (j = len - 1; j > i; --j) {
                y[j] = y[j] ^ this.mulTable[x[i]][y[j - 1]];
            }
        }
        for (i = len - 1; i >= 0; --i) {
            for (j = i + 1; j < len; ++j) {
                y[j] = this.divTable[y[j]][x[j] ^ x[j - i - 1]];
            }
            for (j = i; j < len - 1; ++j) {
                y[j] = y[j] ^ y[j + 1];
            }
        }
    }

    public void solveVandermondeSystem(int[] x, byte[][] y, int len, int dataLen) {
        int k;
        int j;
        int i;
        for (i = 0; i < len - 1; ++i) {
            for (j = len - 1; j > i; --j) {
                for (k = 0; k < dataLen; ++k) {
                    y[j][k] = (byte)(y[j][k] ^ this.mulTable[x[i]][y[j - 1][k] & 0xFF]);
                }
            }
        }
        for (i = len - 1; i >= 0; --i) {
            for (j = i + 1; j < len; ++j) {
                for (k = 0; k < dataLen; ++k) {
                    y[j][k] = (byte)this.divTable[y[j][k] & 0xFF][x[j] ^ x[j - i - 1]];
                }
            }
            for (j = i; j < len - 1; ++j) {
                for (k = 0; k < dataLen; ++k) {
                    y[j][k] = (byte)(y[j][k] ^ y[j + 1][k]);
                }
            }
        }
    }

    public int[] multiply(int[] p, int[] q) {
        int i;
        int len = p.length + q.length - 1;
        int[] result = new int[len];
        for (i = 0; i < len; ++i) {
            result[i] = 0;
        }
        for (i = 0; i < p.length; ++i) {
            for (int j = 0; j < q.length; ++j) {
                result[i + j] = this.add(result[i + j], this.multiply(p[i], q[j]));
            }
        }
        return result;
    }

    public void remainder(int[] dividend, int[] divisor) {
        for (int i = dividend.length - divisor.length; i >= 0; --i) {
            int ratio = this.divTable[dividend[i + divisor.length - 1]][divisor[divisor.length - 1]];
            for (int j = 0; j < divisor.length; ++j) {
                int k = j + i;
                dividend[k] = dividend[k] ^ this.mulTable[ratio][divisor[j]];
            }
        }
    }

    public void remainder(byte[][] dividend, int[] divisor) {
        for (int i = dividend.length - divisor.length; i >= 0; --i) {
            for (int j = 0; j < divisor.length; ++j) {
                for (int k = 0; k < dividend[i].length; ++k) {
                    int ratio = this.divTable[dividend[i + divisor.length - 1][k] & 0xFF][divisor[divisor.length - 1]];
                    dividend[j + i][k] = (byte)(dividend[j + i][k] & 0xFF ^ this.mulTable[ratio][divisor[j]]);
                }
            }
        }
    }

    public int[] add(int[] p, int[] q) {
        int len = Math.max(p.length, q.length);
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = i < p.length && i < q.length ? this.add(p[i], q[i]) : (i < p.length ? p[i] : q[i]);
        }
        return result;
    }

    public int substitute(int[] p, int x) {
        int result = 0;
        int y = 1;
        for (int i = 0; i < p.length; ++i) {
            result ^= this.mulTable[p[i]][y];
            y = this.mulTable[x][y];
        }
        return result;
    }

    public void substitute(byte[][] p, byte[] q, int x) {
        int y = 1;
        for (int i = 0; i < p.length; ++i) {
            byte[] pi = p[i];
            for (int j = 0; j < pi.length; ++j) {
                int pij = pi[j] & 0xFF;
                q[j] = (byte)(q[j] ^ this.mulTable[pij][y]);
            }
            y = this.mulTable[x][y];
        }
    }

    public void gaussianElimination(int[][] matrix) {
        int i;
        assert (matrix != null && matrix.length > 0 && matrix[0].length > 0 && matrix.length < matrix[0].length);
        int height = matrix.length;
        int width = matrix[0].length;
        for (i = 0; i < height; ++i) {
            int j;
            boolean pivotFound = false;
            for (int j2 = i; j2 < height; ++j2) {
                if (matrix[i][j2] == 0) continue;
                int[] tmp = matrix[i];
                matrix[i] = matrix[j2];
                matrix[j2] = tmp;
                pivotFound = true;
                break;
            }
            if (!pivotFound) continue;
            int pivot = matrix[i][i];
            for (j = i; j < width; ++j) {
                matrix[i][j] = this.divide(matrix[i][j], pivot);
            }
            for (j = i + 1; j < height; ++j) {
                int lead = matrix[j][i];
                for (int k = i; k < width; ++k) {
                    matrix[j][k] = this.add(matrix[j][k], this.multiply(lead, matrix[i][k]));
                }
            }
        }
        for (i = height - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                int lead = matrix[j][i];
                for (int k = i; k < width; ++k) {
                    matrix[j][k] = this.add(matrix[j][k], this.multiply(lead, matrix[i][k]));
                }
            }
        }
    }
}

