/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.BaseEncodingManager;
import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.PolicyInfo;
import io.hops.erasure_coding.Report;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class LocalEncodingManager
extends BaseEncodingManager {
    public static final Log LOG = LogFactory.getLog(LocalEncodingManager.class);

    public LocalEncodingManager(Configuration conf) throws IOException {
        super(conf);
        LOG.info((Object)"created");
    }

    public void encodeFile(EncodingPolicy policy, Path sourceFile, Path parityFile, boolean copy) {
        Codec codec = Codec.getCodec((String)policy.getCodec());
        PolicyInfo policyInfo = new PolicyInfo();
        try {
            policyInfo.setSrcPath(sourceFile.toUri().getPath());
            policyInfo.setCodecId(codec.getId());
            policyInfo.setProperty(PolicyInfo.PROPERTY_PARITY_PATH, parityFile.toUri().getPath());
            policyInfo.setProperty(PolicyInfo.PROPERTY_REPLICATION, String.valueOf(policy.getTargetReplication()));
            policyInfo.setProperty(PolicyInfo.PROPERTY_PARITY_REPLICATION, String.valueOf(1));
            policyInfo.setProperty(PolicyInfo.PROPERTY_COPY, String.valueOf(copy));
            this.doRaid(this.conf, policyInfo);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
    }

    public List<Report> computeReports() {
        throw new NotImplementedException("not implemented");
    }

    public void cancelAll() {
        throw new NotImplementedException("not implemented");
    }

    public void cancel(String toCancel) {
        throw new NotImplementedException("not implemented");
    }
}

