/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class PolicyInfo
implements Writable {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.raid.protocol.PolicyInfo");
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Path srcPath;
    private String policyName;
    private String codecId;
    private String description;
    private Configuration conf;
    public static String PROPERTY_PARITY_PATH = "parityPath";
    public static String PROPERTY_REPLICATION = "targetReplication";
    public static String PROPERTY_PARITY_REPLICATION = "metaReplication";
    public static String PROPERTY_COPY = "copy";
    private Properties properties;

    public PolicyInfo() {
        this.conf = null;
        this.policyName = "";
        this.description = "";
        this.srcPath = null;
        this.properties = new Properties();
    }

    public PolicyInfo(String policyName, Configuration conf) {
        this.conf = conf;
        this.policyName = policyName;
        this.description = "";
        this.srcPath = null;
        this.properties = new Properties();
    }

    public void copyFrom(PolicyInfo other) {
        if (other.conf != null) {
            this.conf = other.conf;
        }
        if (other.policyName != null && other.policyName.length() > 0) {
            this.policyName = other.policyName;
        }
        if (other.description != null && other.description.length() > 0) {
            this.description = other.description;
        }
        if (other.codecId != null) {
            this.codecId = other.codecId;
        }
        if (other.srcPath != null) {
            this.srcPath = other.srcPath;
        }
        for (Object key : other.properties.keySet()) {
            String skey = (String)key;
            this.properties.setProperty(skey, other.properties.getProperty(skey));
        }
        LOG.info((Object)(this.policyName + ".codecId " + this.codecId));
        LOG.info((Object)(this.policyName + ".srcpath " + this.srcPath));
    }

    public void setSrcPath(String in) throws IOException {
        this.srcPath = new Path(in);
    }

    public void setCodecId(String id) {
        this.codecId = id;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getName() {
        return this.policyName;
    }

    public String getCodecId() {
        return this.codecId;
    }

    public Path getSrcPath() {
        return this.srcPath;
    }

    private String normalizePath(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Policy Name:\t" + this.policyName + " --------------------\n");
        buff.append("Source Path:\t" + this.srcPath + "\n");
        buff.append("Codec:\t" + this.codecId + "\n");
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            buff.append(name + ":\t" + this.properties.getProperty(name) + "\n");
        }
        if (this.description.length() > 0) {
            int len = Math.min(this.description.length(), 80);
            String sub = this.description.substring(0, len).trim();
            sub = sub.replaceAll("\n", " ");
            buff.append("Description:\t" + sub + "...\n");
        }
        return buff.toString();
    }

    public void write(DataOutput out) throws IOException {
        if (this.srcPath == null) {
            Text.writeString((DataOutput)out, (String)"");
        } else {
            Text.writeString((DataOutput)out, (String)this.srcPath.toString());
        }
        Text.writeString((DataOutput)out, (String)this.policyName);
        Text.writeString((DataOutput)out, (String)this.codecId);
        Text.writeString((DataOutput)out, (String)this.description);
        out.writeInt(this.properties.size());
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Text.writeString((DataOutput)out, (String)name);
            Text.writeString((DataOutput)out, (String)this.properties.getProperty(name));
        }
    }

    public void readFields(DataInput in) throws IOException {
        String text = Text.readString((DataInput)in);
        this.srcPath = text.length() == 0 ? null : new Path(text);
        this.policyName = Text.readString((DataInput)in);
        this.codecId = Text.readString((DataInput)in);
        this.description = Text.readString((DataInput)in);
        for (int n = in.readInt(); n > 0; --n) {
            String name = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.properties.setProperty(name, value);
        }
    }

    static {
        WritableFactories.setFactory(PolicyInfo.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new PolicyInfo();
            }
        });
    }
}

