/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.ErasureCode;
import io.hops.erasure_coding.GaloisField;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReedSolomonCode
extends ErasureCode {
    public static final Log LOG = LogFactory.getLog(ReedSolomonCode.class);
    private int stripeSize;
    private int paritySize;
    private int[] generatingPolynomial;
    private int PRIMITIVE_ROOT = 2;
    private int[] primitivePower;
    private GaloisField GF = GaloisField.getInstance();
    private int[] errSignature;
    private int[] paritySymbolLocations;
    private int[] dataBuff;

    @Deprecated
    public ReedSolomonCode(int stripeSize, int paritySize) {
        this.init(stripeSize, paritySize);
    }

    public ReedSolomonCode() {
    }

    public void init(Codec codec) {
        this.init(codec.stripeLength, codec.parityLength);
        LOG.info((Object)("Initialized " + ReedSolomonCode.class + " stripeLength:" + codec.stripeLength + " parityLength:" + codec.parityLength));
    }

    private void init(int stripeSize, int paritySize) {
        int i;
        assert (stripeSize + paritySize < this.GF.getFieldSize());
        this.stripeSize = stripeSize;
        this.paritySize = paritySize;
        this.errSignature = new int[paritySize];
        this.paritySymbolLocations = new int[paritySize];
        this.dataBuff = new int[paritySize + stripeSize];
        for (i = 0; i < paritySize; ++i) {
            this.paritySymbolLocations[i] = i;
        }
        this.primitivePower = new int[stripeSize + paritySize];
        for (i = 0; i < stripeSize + paritySize; ++i) {
            this.primitivePower[i] = this.GF.power(this.PRIMITIVE_ROOT, i);
        }
        int[] gen = new int[]{1};
        int[] poly = new int[2];
        for (int i2 = 0; i2 < paritySize; ++i2) {
            poly[0] = this.primitivePower[i2];
            poly[1] = 1;
            gen = this.GF.multiply(gen, poly);
        }
        this.generatingPolynomial = gen;
    }

    public void encode(int[] message, int[] parity) {
        int i;
        assert (message.length == this.stripeSize && parity.length == this.paritySize);
        for (i = 0; i < this.paritySize; ++i) {
            this.dataBuff[i] = 0;
        }
        for (i = 0; i < this.stripeSize; ++i) {
            this.dataBuff[i + this.paritySize] = message[i];
        }
        this.GF.remainder(this.dataBuff, this.generatingPolynomial);
        for (i = 0; i < this.paritySize; ++i) {
            parity[i] = this.dataBuff[i];
        }
    }

    public void encodeBulk(byte[][] inputs, byte[][] outputs) {
        int i;
        int stripeSize = this.stripeSize();
        int paritySize = this.paritySize();
        assert (stripeSize == inputs.length);
        assert (paritySize == outputs.length);
        for (int i2 = 0; i2 < outputs.length; ++i2) {
            Arrays.fill(outputs[i2], (byte)0);
        }
        byte[][] data = new byte[stripeSize + paritySize][];
        for (i = 0; i < paritySize; ++i) {
            data[i] = outputs[i];
        }
        for (i = 0; i < stripeSize; ++i) {
            data[i + paritySize] = inputs[i];
        }
        this.GF.remainder(data, this.generatingPolynomial);
    }

    public void decode(int[] data, int[] erasedLocations, int[] erasedValues) {
        int i;
        if (erasedLocations.length == 0) {
            return;
        }
        assert (erasedLocations.length == erasedValues.length);
        for (i = 0; i < erasedLocations.length; ++i) {
            data[erasedLocations[i]] = 0;
        }
        for (i = 0; i < erasedLocations.length; ++i) {
            this.errSignature[i] = this.primitivePower[erasedLocations[i]];
            erasedValues[i] = this.GF.substitute(data, this.primitivePower[i]);
        }
        this.GF.solveVandermondeSystem(this.errSignature, erasedValues, erasedLocations.length);
    }

    public void decode(int[] data, int[] erasedLocations, int[] erasedValues, int[] locationsToRead, int[] locationsNotToRead) {
        int[] recovValue = new int[locationsNotToRead.length];
        this.decode(data, locationsNotToRead, recovValue);
        block0: for (int i = 0; i < erasedLocations.length; ++i) {
            for (int j = 0; j < locationsNotToRead.length; ++j) {
                if (erasedLocations[i] != locationsNotToRead[j]) continue;
                erasedValues[i] = recovValue[j];
                continue block0;
            }
        }
    }

    public void decodeBulk(byte[][] readBufs, byte[][] writeBufs, int[] erasedLocation) {
        int i;
        if (erasedLocation.length == 0) {
            return;
        }
        for (i = 0; i < writeBufs.length; ++i) {
            Arrays.fill(writeBufs[i], (byte)0);
        }
        for (i = 0; i < erasedLocation.length; ++i) {
            this.errSignature[i] = this.primitivePower[erasedLocation[i]];
            this.GF.substitute(readBufs, writeBufs[i], this.primitivePower[i]);
        }
        this.GF.solveVandermondeSystem(this.errSignature, writeBufs, erasedLocation.length, readBufs[0].length);
    }

    public void decodeBulk(byte[][] readBufs, byte[][] writeBufs, int[] erasedLocations, int[] locationsToRead, int[] locationsNotToRead) {
        int[] tmpInput = new int[readBufs.length];
        int[] tmpOutput = new int[erasedLocations.length];
        int numBytes = readBufs[0].length;
        for (int idx = 0; idx < numBytes; ++idx) {
            int i;
            for (i = 0; i < tmpOutput.length; ++i) {
                tmpOutput[i] = 0;
            }
            for (i = 0; i < tmpInput.length; ++i) {
                tmpInput[i] = readBufs[i][idx] & 0xFF;
            }
            this.decode(tmpInput, erasedLocations, tmpOutput, locationsToRead, locationsNotToRead);
            for (i = 0; i < tmpOutput.length; ++i) {
                writeBufs[i][idx] = (byte)tmpOutput[i];
            }
        }
    }

    public int stripeSize() {
        return this.stripeSize;
    }

    public int paritySize() {
        return this.paritySize;
    }

    public int symbolSize() {
        return (int)Math.round(Math.log(this.GF.getFieldSize()) / Math.log(2.0));
    }

    public boolean computeErrorLocations(int[] data, Set<Integer> errorLocations) {
        int i;
        assert (data.length == this.paritySize + this.stripeSize && errorLocations != null);
        errorLocations.clear();
        int maxError = this.paritySize / 2;
        int[][] syndromeMatrix = new int[maxError][];
        for (int i2 = 0; i2 < syndromeMatrix.length; ++i2) {
            syndromeMatrix[i2] = new int[maxError + 1];
        }
        int[] syndrome = new int[this.paritySize];
        if (this.computeSyndrome(data, syndrome)) {
            return true;
        }
        for (int i3 = 0; i3 < maxError; ++i3) {
            for (int j = 0; j < maxError + 1; ++j) {
                syndromeMatrix[i3][j] = syndrome[i3 + j];
            }
        }
        this.GF.gaussianElimination(syndromeMatrix);
        int[] polynomial = new int[maxError + 1];
        polynomial[0] = 1;
        for (i = 0; i < maxError; ++i) {
            polynomial[i + 1] = syndromeMatrix[maxError - 1 - i][maxError];
        }
        for (i = 0; i < this.paritySize + this.stripeSize; ++i) {
            int possibleRoot = this.GF.divide(1, this.primitivePower[i]);
            if (this.GF.substitute(polynomial, possibleRoot) != 0) continue;
            errorLocations.add(i);
        }
        int[] locations = new int[errorLocations.size()];
        int k = 0;
        for (int loc : errorLocations) {
            locations[k++] = loc;
        }
        int[] erasedValue = new int[locations.length];
        this.decode(data, locations, erasedValue);
        for (int i4 = 0; i4 < locations.length; ++i4) {
            data[locations[i4]] = erasedValue[i4];
        }
        return this.computeSyndrome(data, syndrome);
    }

    private boolean computeSyndrome(int[] data, int[] syndrome) {
        boolean corruptionFound = false;
        for (int i = 0; i < this.paritySize; ++i) {
            syndrome[i] = this.GF.substitute(data, this.primitivePower[i]);
            if (syndrome[i] == 0) continue;
            corruptionFound = true;
        }
        return !corruptionFound;
    }
}

