/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.BaseEncodingManager;
import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.ErasureCode;
import io.hops.erasure_coding.FileStripeReader;
import io.hops.erasure_coding.RaidUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;

public abstract class StripeReader {
    public static final Log LOG = LogFactory.getLog(BaseEncodingManager.class);
    Codec codec;
    Configuration conf;
    FileSystem fs;
    long stripeStartIdx;
    int bufferSize;

    public StripeReader(Configuration conf, Codec codec, FileSystem fs, long stripeStartIdx) {
        this.codec = codec;
        this.conf = conf;
        this.fs = fs;
        this.stripeStartIdx = stripeStartIdx;
        this.bufferSize = conf.getInt("io.file.buffer.size", 65536);
    }

    public abstract boolean hasNext();

    public abstract InputStream[] getNextStripeInputs() throws IOException;

    public InputStream[] buildInputs(FileSystem srcFs, Path srcFile, FileStatus srcStat, FileSystem parityFs, Path parityFile, FileStatus parityStat, int stripeIdx, long offsetInBlock, List<Integer> erasedLocations, List<Integer> locationsToRead, ErasureCode code) throws IOException {
        InputStream[] inputs = new InputStream[this.codec.stripeLength + this.codec.parityLength];
        boolean redo = false;
        block2: do {
            locationsToRead.clear();
            locationsToRead.addAll(code.locationsToReadForDecode(erasedLocations));
            for (int i = 0; i < inputs.length; ++i) {
                boolean isErased = erasedLocations.indexOf(i) != -1;
                boolean shouldRead = locationsToRead.indexOf(i) != -1;
                try {
                    InputStream stm = null;
                    if (isErased || !shouldRead) {
                        if (isErased) {
                            LOG.info((Object)("Location " + i + " is erased, using zeros"));
                        } else {
                            LOG.info((Object)("Location " + i + " need not be read, using zeros"));
                        }
                        stm = new RaidUtils.ZeroInputStream(srcStat.getBlockSize() * (long)(i < this.codec.parityLength ? stripeIdx * this.codec.parityLength + i : stripeIdx * this.codec.stripeLength + i - this.codec.parityLength));
                    } else {
                        stm = this.buildOneInput(i, offsetInBlock, srcFs, srcFile, srcStat, parityFs, parityFile, parityStat);
                    }
                    inputs[i] = stm;
                    continue;
                }
                catch (IOException e) {
                    if (e instanceof BlockMissingException || e instanceof ChecksumException) {
                        erasedLocations.add(i);
                        redo = true;
                        RaidUtils.closeStreams(inputs);
                        continue block2;
                    }
                    throw e;
                }
            }
        } while (redo);
        return inputs;
    }

    public static LocationPair getBlockLocation(Codec codec, int blockIdxInFile) throws IOException {
        int blockIdx = blockIdxInFile;
        int stripeIdx = blockIdx / codec.stripeLength;
        int blockIdxInStripe = blockIdx % codec.stripeLength;
        return new LocationPair(stripeIdx, blockIdxInStripe);
    }

    public static LocationPair getParityBlockLocation(Codec codec, int blockIdxInFile) {
        int stripeIdx = blockIdxInFile / codec.parityLength;
        int blockIdxInStripe = blockIdxInFile % codec.parityLength;
        return new LocationPair(stripeIdx, blockIdxInStripe);
    }

    public static StripeReader getStripeReader(Codec codec, Configuration conf, long blockSize, FileSystem fs, long stripeIdx, FileStatus srcStat) throws IOException {
        return new FileStripeReader(conf, blockSize, codec, fs, stripeIdx, srcStat.getPath(), srcStat.getLen());
    }

    protected abstract InputStream buildOneInput(int var1, long var2, FileSystem var4, Path var5, FileStatus var6, FileSystem var7, Path var8, FileStatus var9) throws IOException;

    protected InputStream getParityFileInput(int locationIndex, Path parityFile, FileSystem parityFs, FileStatus parityStat, long offsetInBlock) throws IOException {
        int parityBlockIdx = (int)((long)this.codec.parityLength * this.stripeStartIdx + (long)locationIndex);
        long offset = parityStat.getBlockSize() * (long)parityBlockIdx + offsetInBlock;
        assert (offset < parityStat.getLen());
        LOG.info((Object)("Opening " + parityFile + ":" + offset + " for location " + locationIndex));
        FSDataInputStream s = parityFs.open(parityFile, this.conf.getInt("io.file.buffer.size", 65536));
        s.seek(offset);
        return s;
    }

    public static class LocationPair {
        private int stripeIdx;
        private int blockIdxInStripe;

        public LocationPair(int stripeIdx, int blockIdxInStripe) {
            this.stripeIdx = stripeIdx;
            this.blockIdxInStripe = blockIdxInStripe;
        }

        int getStripeIdx() {
            return this.stripeIdx;
        }

        int getBlockIdxInStripe() {
            return this.blockIdxInStripe;
        }
    }
}

