/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.ErasureCode;
import io.hops.erasure_coding.GaloisField;
import io.hops.erasure_coding.TooManyErasedLocations;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;

public class SimpleRegeneratingCode
extends ErasureCode {
    public static final Log LOG = LogFactory.getLog(SimpleRegeneratingCode.class);
    private int stripeSize;
    private int paritySize;
    private int paritySizeSRC;
    private int paritySizeRS;
    private int simpleParityDegree;
    private int[] generatingPolynomial;
    private int PRIMITIVE_ROOT = 2;
    private int[] primitivePower;
    private GaloisField GF = GaloisField.getInstance();
    private int[] errSignature;
    private int[] dataBuff;
    private int[][] groupsTable;

    @Deprecated
    public SimpleRegeneratingCode(int stripeSize, int paritySize) {
        this.init(stripeSize, paritySize);
    }

    public SimpleRegeneratingCode() {
    }

    public void init(Codec codec) {
        try {
            this.paritySizeSRC = codec.json.getInt("parity_length_src");
        }
        catch (JSONException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        this.init(codec.stripeLength, codec.parityLength);
        LOG.info((Object)(" Initialized " + SimpleRegeneratingCode.class + " stripeLength:" + codec.stripeLength + " parityLength:" + codec.parityLength + " SRC parities:" + this.paritySizeSRC));
    }

    private void init(int stripeSize, int paritySize) {
        int i;
        this.stripeSize = stripeSize;
        this.paritySize = paritySize;
        this.paritySizeRS = paritySize - this.paritySizeSRC;
        assert (stripeSize + this.paritySizeRS < this.GF.getFieldSize());
        assert (paritySize >= this.paritySizeSRC);
        this.simpleParityDegree = (int)Math.ceil((double)(stripeSize + this.paritySizeRS) / (double)(this.paritySizeSRC + 1));
        while (this.simpleParityDegree * this.paritySizeSRC >= stripeSize + this.paritySizeRS) {
            LOG.info((Object)("\nInvalid code parameters. Reducing SRC parities to " + (this.paritySizeSRC - 1) + " Increasing RS parities to " + (this.paritySizeRS + 1)));
            --this.paritySizeSRC;
            ++this.paritySizeRS;
            this.simpleParityDegree = (int)Math.ceil((double)(stripeSize + this.paritySizeRS) / (double)(this.paritySizeSRC + 1));
        }
        this.errSignature = new int[this.paritySizeRS];
        this.dataBuff = new int[this.paritySizeRS + stripeSize];
        this.primitivePower = new int[stripeSize + this.paritySizeRS];
        for (int i2 = 0; i2 < stripeSize + this.paritySizeRS; ++i2) {
            this.primitivePower[i2] = this.GF.power(this.PRIMITIVE_ROOT, i2);
        }
        int[] gen = new int[]{1};
        int[] poly = new int[2];
        for (i = 0; i < this.paritySizeRS; ++i) {
            poly[0] = this.primitivePower[i];
            poly[1] = 1;
            gen = this.GF.multiply(gen, poly);
        }
        this.generatingPolynomial = gen;
        this.groupsTable = new int[paritySize + stripeSize][];
        for (i = 0; i < this.groupsTable.length; ++i) {
            List<Integer> locationsInGroup = this.getSRCGroupNeighbors(i);
            this.groupsTable[i] = new int[locationsInGroup.size()];
            int k = 0;
            for (int loc : locationsInGroup) {
                this.groupsTable[i][k++] = loc;
            }
        }
    }

    public void encode(int[] message, int[] parity) {
        int i;
        assert (message.length == this.stripeSize && parity.length == this.paritySize);
        for (i = 0; i < this.paritySizeRS; ++i) {
            this.dataBuff[i] = 0;
        }
        for (i = 0; i < this.stripeSize; ++i) {
            this.dataBuff[i + this.paritySizeRS] = message[i];
        }
        this.GF.remainder(this.dataBuff, this.generatingPolynomial);
        for (i = 0; i < this.paritySizeRS; ++i) {
            parity[i + this.paritySizeSRC] = this.dataBuff[i];
        }
        for (i = 0; i < this.stripeSize; ++i) {
            this.dataBuff[i + this.paritySizeRS] = message[i];
        }
        for (i = 0; i < this.paritySizeSRC; ++i) {
            parity[i] = 0;
            for (int j = this.simpleParityDegree * i; j < this.simpleParityDegree * (i + 1); ++j) {
                parity[i] = this.GF.add(this.dataBuff[j], parity[i]);
            }
        }
    }

    private void decodeReedSolomon(int[] data, int[] erasedLocations, int[] erasedValues) {
        int i;
        if (erasedLocations.length == 0) {
            return;
        }
        assert (erasedLocations.length == erasedValues.length);
        assert (erasedLocations.length <= this.paritySizeRS);
        for (i = 0; i < erasedLocations.length; ++i) {
            data[erasedLocations[i]] = 0;
        }
        for (i = 0; i < erasedLocations.length; ++i) {
            this.errSignature[i] = this.primitivePower[erasedLocations[i]];
            erasedValues[i] = this.GF.substitute(data, this.primitivePower[i]);
        }
        this.GF.solveVandermondeSystem(this.errSignature, erasedValues, erasedLocations.length);
    }

    public void decode(int[] data, int[] erasedLocations, int[] erasedValues) {
        this.decodeReedSolomon(data, erasedLocations, erasedValues);
    }

    public void decode(int[] data, int[] erasedLocations, int[] erasedValues, int[] locationsToRead, int[] locationsNotToRead) {
        int i;
        assert (erasedLocations.length == erasedValues.length);
        if (erasedLocations.length == 1) {
            erasedValues[0] = 0;
            for (int i2 = 0; i2 < locationsToRead.length; ++i2) {
                erasedValues[0] = this.GF.add(data[locationsToRead[i2]], erasedValues[0]);
            }
            return;
        }
        if (!this.groupConflict(erasedLocations)) {
            for (int i3 = 0; i3 < erasedLocations.length; ++i3) {
                int[] singleErasedLocation = new int[]{erasedLocations[i3]};
                int[] singleErasedValue = new int[]{0};
                this.decode(data, singleErasedLocation, singleErasedValue, this.groupsTable[erasedLocations[i3]], null);
                erasedValues[i3] = singleErasedValue[0];
            }
            return;
        }
        assert (locationsToRead.length == this.stripeSize);
        assert (locationsNotToRead.length == this.stripeSize + this.paritySize - locationsToRead.length);
        int numOferasedSRCparities = 0;
        for (int i4 = 0; i4 < erasedLocations.length; ++i4) {
            if (erasedLocations[i4] >= this.paritySizeSRC) continue;
            ++numOferasedSRCparities;
        }
        int[] dataRS = new int[this.paritySizeRS + this.stripeSize];
        for (int i5 = 0; i5 < this.paritySizeRS + this.stripeSize; ++i5) {
            dataRS[i5] = data[i5 + this.paritySizeSRC];
        }
        int[] erasedLocationsRS = new int[locationsNotToRead.length - this.paritySizeSRC];
        int k = 0;
        for (int i6 = 0; i6 < locationsNotToRead.length; ++i6) {
            if (locationsNotToRead[i6] < this.paritySizeSRC) continue;
            erasedLocationsRS[k++] = locationsNotToRead[i6] - this.paritySizeSRC;
        }
        int[] erasedValuesRS = new int[erasedLocationsRS.length];
        this.decodeReedSolomon(dataRS, erasedLocationsRS, erasedValuesRS);
        for (i = 0; i < erasedLocationsRS.length; ++i) {
            data[this.paritySizeSRC + erasedLocationsRS[i]] = erasedValuesRS[i];
        }
        for (i = 0; i < erasedLocations.length; ++i) {
            if (erasedLocations[i] >= this.paritySizeSRC) continue;
            int par = erasedLocations[i];
            data[par] = 0;
            for (int j = 0; j < this.groupsTable[erasedLocations[i]].length; ++j) {
                data[par] = this.GF.add(data[this.groupsTable[erasedLocations[i]][j]], data[par]);
            }
        }
        for (i = 0; i < erasedLocations.length; ++i) {
            erasedValues[i] = data[erasedLocations[i]];
        }
    }

    public int stripeSize() {
        return this.stripeSize;
    }

    public int paritySize() {
        return this.paritySize;
    }

    public int symbolSize() {
        return (int)Math.round(Math.log(this.GF.getFieldSize()) / Math.log(2.0));
    }

    public List<Integer> locationsToReadForDecode(List<Integer> erasedLocations) throws TooManyErasedLocations {
        if (erasedLocations.size() == 1) {
            int loc = erasedLocations.get(0);
            ArrayList<Integer> locationsToRead = new ArrayList<Integer>(this.groupsTable[loc].length);
            for (int i = 0; i < this.groupsTable[loc].length; ++i) {
                locationsToRead.add(this.groupsTable[loc][i]);
            }
            return locationsToRead;
        }
        int[] erasedLocationsArray = new int[erasedLocations.size()];
        for (int i = 0; i < erasedLocations.size(); ++i) {
            erasedLocationsArray[i] = erasedLocations.get(i);
        }
        if (!this.groupConflict(erasedLocationsArray)) {
            ArrayList<Integer> locationsToRead = new ArrayList<Integer>(erasedLocations.size() * this.simpleParityDegree);
            for (int loc : erasedLocations) {
                for (int i = 0; i < this.groupsTable[loc].length; ++i) {
                    if (locationsToRead.contains(this.groupsTable[loc][i])) continue;
                    locationsToRead.add(this.groupsTable[loc][i]);
                }
            }
            return locationsToRead;
        }
        ArrayList<Integer> locationsToRead = new ArrayList<Integer>(this.stripeSize());
        int limit = this.stripeSize() + this.paritySize();
        for (int loc = this.paritySizeSRC; loc < limit; ++loc) {
            if (erasedLocations.indexOf(loc) != -1) continue;
            locationsToRead.add(loc);
            if (this.stripeSize() == locationsToRead.size()) break;
        }
        if (locationsToRead.size() != this.stripeSize()) {
            String locationsStr = "";
            for (Integer erasedLocation : erasedLocations) {
                locationsStr = locationsStr + " " + erasedLocation;
            }
            throw new TooManyErasedLocations("Locations " + locationsStr);
        }
        return locationsToRead;
    }

    private List<Integer> getSRCGroupNeighbors(int loc) {
        int limit = this.stripeSize() + this.paritySize();
        ArrayList<Integer> neighbors = new ArrayList<Integer>(this.simpleParityDegree);
        int group = this.getSRCGroup(loc);
        if (group < this.paritySizeSRC) {
            if (group != loc) {
                neighbors.add(group);
            }
            for (int i = this.paritySizeSRC + group * this.simpleParityDegree; i < this.paritySizeSRC + (group + 1) * this.simpleParityDegree; ++i) {
                if (i == loc) continue;
                neighbors.add(i);
            }
        } else {
            int i;
            assert (loc >= this.paritySizeSRC);
            for (i = 0; i < this.paritySizeSRC; ++i) {
                neighbors.add(i);
            }
            for (i = this.paritySizeSRC + group * this.simpleParityDegree; i < limit; ++i) {
                if (i == loc) continue;
                neighbors.add(i);
            }
        }
        return neighbors;
    }

    private int getSRCGroup(int loc) {
        int group = -1;
        group = 0 <= loc && loc < this.paritySizeSRC ? loc : (this.paritySizeSRC <= loc && loc < this.stripeSize + this.paritySize ? (loc - this.paritySizeSRC) / this.simpleParityDegree : -1);
        return group;
    }

    private boolean groupConflict(int[] locs) {
        int i;
        int[] groups = new int[this.paritySizeSRC + 1];
        for (i = 0; i < groups.length; ++i) {
            groups[i] = 0;
        }
        for (i = 0; i < locs.length; ++i) {
            if (locs[i] >= this.paritySizeSRC) continue;
            groups[this.paritySizeSRC] = 1;
            break;
        }
        for (i = 0; i < locs.length; ++i) {
            int n = this.getSRCGroup(locs[i]);
            int n2 = groups[n];
            groups[n] = n2 + 1;
            if (n2 <= 0) continue;
            return true;
        }
        return false;
    }
}

