/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.slf4j.Logger;

class RegisterApplicationMasterResponseReflector {
    private final Logger logger;
    private Method method;

    RegisterApplicationMasterResponseReflector(Logger log) {
        this(log, RegisterApplicationMasterResponse.class);
    }

    @VisibleForTesting
    RegisterApplicationMasterResponseReflector(Logger log, Class<?> clazz) {
        this.logger = Objects.requireNonNull(log);
        Objects.requireNonNull(clazz);
        try {
            this.method = clazz.getMethod("getContainersFromPreviousAttempts", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.logger.info("Cannot reconnect to previously allocated containers. This YARN version does not support 'getContainersFromPreviousAttempts()'");
        }
    }

    List<Container> getContainersFromPreviousAttempts(RegisterApplicationMasterResponse response) {
        return this.getContainersFromPreviousAttemptsUnsafe(response);
    }

    @VisibleForTesting
    List<Container> getContainersFromPreviousAttemptsUnsafe(Object response) {
        if (this.method != null && response != null) {
            try {
                List containers = (List)this.method.invoke(response, new Object[0]);
                if (containers != null && !containers.isEmpty()) {
                    return containers;
                }
            }
            catch (Exception t) {
                this.logger.error("Error invoking 'getContainersFromPreviousAttempts()'", (Throwable)t);
            }
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    Method getMethod() {
        return this.method;
    }
}

