/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.AbstractContainerizedClusterClientFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.YarnClientYarnClusterInformationRetriever;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;

@Internal
public class YarnClusterClientFactory
extends AbstractContainerizedClusterClientFactory<ApplicationId> {
    public static final String ERROR_MESSAGE = "No Executor found. Please make sure to export the HADOOP_CLASSPATH environment variable or have hadoop in your classpath. For more information refer to the \"Deployment & Operations\" section of the official Apache Flink documentation.";

    public boolean isCompatibleWith(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String deploymentTarget = configuration.getString(DeploymentOptions.TARGET);
        return "yarn-per-job".equalsIgnoreCase(deploymentTarget) || "yarn-session".equalsIgnoreCase(deploymentTarget);
    }

    public YarnClusterDescriptor createClusterDescriptor(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return this.getClusterDescriptor(configuration);
    }

    @Nullable
    public ApplicationId getClusterId(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String clusterId = configuration.getString(YarnConfigOptions.APPLICATION_ID);
        return clusterId != null ? ConverterUtils.toApplicationId((String)clusterId) : null;
    }

    private YarnClusterDescriptor getClusterDescriptor(Configuration configuration) {
        YarnClient yarnClient = YarnClient.createYarnClient();
        YarnConfiguration yarnConfiguration = new YarnConfiguration();
        yarnClient.init((org.apache.hadoop.conf.Configuration)yarnConfiguration);
        yarnClient.start();
        return new YarnClusterDescriptor(configuration, yarnConfiguration, yarnClient, YarnClientYarnClusterInformationRetriever.create(yarnClient), false);
    }
}

