/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.AbstractCustomCommandLine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.yarn.configuration.YarnConfigOptions;

@Internal
public class FallbackYarnSessionCli
extends AbstractCustomCommandLine {
    public static final String ID = "yarn-cluster";
    private final Option applicationId = new Option("yid", "yarnapplicationId", true, "Attach to running YARN session");

    public FallbackYarnSessionCli(Configuration configuration) {
        super(configuration);
    }

    public void addGeneralOptions(Options baseOptions) {
        super.addGeneralOptions(baseOptions);
        baseOptions.addOption(this.applicationId);
    }

    public boolean isActive(CommandLine commandLine) {
        if (this.originalIsActive(commandLine)) {
            throw new IllegalStateException("No Executor found. Please make sure to export the HADOOP_CLASSPATH environment variable or have hadoop in your classpath. For more information refer to the \"Deployment & Operations\" section of the official Apache Flink documentation.");
        }
        return false;
    }

    private boolean originalIsActive(CommandLine commandLine) {
        String jobManagerOption = commandLine.getOptionValue(this.addressOption.getOpt(), null);
        boolean yarnJobManager = ID.equals(jobManagerOption);
        boolean hasYarnAppId = commandLine.hasOption(this.applicationId.getOpt()) || this.configuration.getOptional(YarnConfigOptions.APPLICATION_ID).isPresent();
        boolean hasYarnExecutor = "yarn-session".equalsIgnoreCase((String)this.configuration.get(DeploymentOptions.TARGET)) || "yarn-per-job".equalsIgnoreCase((String)this.configuration.get(DeploymentOptions.TARGET));
        return hasYarnExecutor || yarnJobManager || hasYarnAppId;
    }

    public String getId() {
        return ID;
    }
}

