/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.executors;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.yarn.executors.YarnJobClusterExecutor;

@Internal
public class YarnJobClusterExecutorFactory
implements PipelineExecutorFactory {
    public String getName() {
        return "yarn-per-job";
    }

    public boolean isCompatibleWith(@Nonnull Configuration configuration) {
        return "yarn-per-job".equalsIgnoreCase((String)configuration.get(DeploymentOptions.TARGET));
    }

    public PipelineExecutor getExecutor(@Nonnull Configuration configuration) {
        try {
            return new YarnJobClusterExecutor();
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("No Executor found. Please make sure to export the HADOOP_CLASSPATH environment variable or have hadoop in your classpath. For more information refer to the \"Deployment & Operations\" section of the official Apache Flink documentation.");
        }
    }
}

