/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.client.deployment.ClusterRetrieveException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.flink.yarn.YarnTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class AbstractYarnClusterTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ClusterRetrieveException.class)
    public void testClusterClientRetrievalOfFinishedYarnApplication() throws Exception {
        ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)42);
        ApplicationReport applicationReport = this.createApplicationReport(applicationId, YarnApplicationState.FINISHED, FinalApplicationStatus.SUCCEEDED);
        TestingYarnClient yarnClient = new TestingYarnClient(Collections.singletonMap(applicationId, applicationReport));
        YarnConfiguration yarnConfiguration = new YarnConfiguration();
        yarnClient.init((org.apache.hadoop.conf.Configuration)yarnConfiguration);
        yarnClient.start();
        try (YarnClusterDescriptor clusterDescriptor = YarnTestUtils.createClusterDescriptorWithLogging(this.temporaryFolder.newFolder().getAbsolutePath(), new Configuration(), yarnConfiguration, (YarnClient)yarnClient, false);){
            clusterDescriptor.retrieve(applicationId);
        }
    }

    private ApplicationReport createApplicationReport(ApplicationId applicationId, YarnApplicationState yarnApplicationState, FinalApplicationStatus finalApplicationStatus) {
        ApplicationReport applicationReport = (ApplicationReport)Records.newRecord(ApplicationReport.class);
        applicationReport.setApplicationId(applicationId);
        applicationReport.setCurrentApplicationAttemptId(ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)0));
        applicationReport.setUser("user");
        applicationReport.setQueue("queue");
        applicationReport.setName("name");
        applicationReport.setHost("localhost");
        applicationReport.setRpcPort(42);
        applicationReport.setYarnApplicationState(yarnApplicationState);
        applicationReport.setStartTime(1L);
        applicationReport.setFinishTime(2L);
        applicationReport.setFinalApplicationStatus(finalApplicationStatus);
        applicationReport.setProgress(1.0f);
        return applicationReport;
    }

    private static final class TestingYarnClient
    extends YarnClientImpl {
        private final Map<ApplicationId, ApplicationReport> applicationReports;

        private TestingYarnClient(Map<ApplicationId, ApplicationReport> applicationReports) {
            this.applicationReports = (Map)Preconditions.checkNotNull(applicationReports);
        }

        public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
            ApplicationReport applicationReport = this.applicationReports.get(appId);
            if (applicationReport != null) {
                return applicationReport;
            }
            return super.getApplicationReport(appId);
        }
    }
}

