/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.yarn.cli.FallbackYarnSessionCli;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.junit.Assert;
import org.junit.Test;

public class FallbackYarnSessionCliTest {
    @Test(expected=IllegalStateException.class)
    public void testExceptionWhenActiveWithYarnApplicationId() throws ParseException {
        this.checkIfYarnFallbackCLIisActiveWithCLIArgs("run", "-yid", ApplicationId.newInstance((long)0L, (int)0).toString());
    }

    @Test(expected=IllegalStateException.class)
    public void testExceptionWhenActiveWithExplicitClusterType() throws ParseException {
        this.checkIfYarnFallbackCLIisActiveWithCLIArgs("run", "-m", "yarn-cluster");
    }

    @Test
    public void testFalseWhenNotActive() throws ParseException {
        boolean isActive = this.checkIfYarnFallbackCLIisActiveWithCLIArgs("run");
        Assert.assertFalse((boolean)isActive);
    }

    private boolean checkIfYarnFallbackCLIisActiveWithCLIArgs(String ... args) throws ParseException {
        Options options = new Options();
        FallbackYarnSessionCli cliUnderTest = new FallbackYarnSessionCli(new Configuration());
        cliUnderTest.addGeneralOptions(options);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        return cliUnderTest.isActive(cmd);
    }
}

