/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.ResourceInformationReflector;
import org.apache.hadoop.yarn.api.records.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ResourceInformationReflectorTest
extends TestLogger {
    private static final String RESOURCE_NAME = "test";
    private static final long RESOURCE_VALUE = 1L;

    @Test
    public void testSetResourceInformationIfMethodPresent() {
        ResourceInformationReflector resourceInformationReflector = new ResourceInformationReflector(ResourceWithMethod.class.getName(), ResourceInfoWithMethod.class.getName());
        ResourceWithMethod resourceWithMethod = new ResourceWithMethod();
        resourceInformationReflector.setResourceInformationUnSafe((Object)resourceWithMethod, RESOURCE_NAME, 1L);
        Assert.assertNotNull((Object)resourceWithMethod.getResourceWithName(RESOURCE_NAME));
        MatcherAssert.assertThat((Object)resourceWithMethod.getResourceWithName(RESOURCE_NAME).getName(), (Matcher)Is.is((Object)RESOURCE_NAME));
        MatcherAssert.assertThat((Object)resourceWithMethod.getResourceWithName(RESOURCE_NAME).getValue(), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void testGetResourceInformationIfMethodPresent() {
        ResourceInformationReflector resourceInformationReflector = new ResourceInformationReflector(ResourceWithMethod.class.getName(), ResourceInfoWithMethod.class.getName());
        ResourceWithMethod resourceWithMethod = new ResourceWithMethod();
        resourceWithMethod.setResourceInformation(RESOURCE_NAME, ResourceInfoWithMethod.newInstance(RESOURCE_NAME, 1L));
        Map externalResources = resourceInformationReflector.getExternalResourcesUnSafe((Object)resourceWithMethod);
        MatcherAssert.assertThat((Object)externalResources.size(), (Matcher)Is.is((Object)1));
        Assert.assertTrue((boolean)externalResources.containsKey(RESOURCE_NAME));
        MatcherAssert.assertThat(externalResources.get(RESOURCE_NAME), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void testSetResourceInformationIfMethodAbsent() {
        ResourceInformationReflector resourceInformationReflector = new ResourceInformationReflector(ResourceWithoutMethod.class.getName(), ResourceInfoWithMethod.class.getName());
        ResourceWithMethod resourceWithMethod = new ResourceWithMethod();
        resourceInformationReflector.setResourceInformationUnSafe((Object)resourceWithMethod, RESOURCE_NAME, 1L);
        Assert.assertNull((Object)resourceWithMethod.getResourceWithName(RESOURCE_NAME));
    }

    @Test
    public void testGetResourceInformationIfMethodAbsent() {
        ResourceInformationReflector resourceInformationReflector = new ResourceInformationReflector(ResourceWithoutMethod.class.getName(), ResourceInfoWithMethod.class.getName());
        ResourceWithMethod resourceWithMethod = new ResourceWithMethod();
        resourceWithMethod.setResourceInformation(RESOURCE_NAME, ResourceInfoWithMethod.newInstance(RESOURCE_NAME, 1L));
        Map externalResources = resourceInformationReflector.getExternalResourcesUnSafe((Object)resourceWithMethod);
        MatcherAssert.assertThat(externalResources.entrySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testDefaultTwoResourceTypeWithYarnSupport() {
        Assume.assumeTrue((boolean)HadoopUtils.isMinHadoopVersion((int)2, (int)10));
        Resource resource = Resource.newInstance((int)100, (int)1);
        Map resourcesResult = ResourceInformationReflector.INSTANCE.getAllResourceInfos((Object)resource);
        MatcherAssert.assertThat((Object)resourcesResult.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
    }

    @Test
    public void testSetAndGetExtendedResourcesWithoutYarnSupport() {
        Assume.assumeTrue((boolean)HadoopUtils.isMaxHadoopVersion((int)2, (int)10));
        Resource resource = Resource.newInstance((int)100, (int)1);
        ResourceInformationReflector.INSTANCE.setResourceInformation(resource, RESOURCE_NAME, 1L);
        Map externalResourcesResult = ResourceInformationReflector.INSTANCE.getExternalResources(resource);
        Assert.assertTrue((boolean)externalResourcesResult.isEmpty());
    }

    private static class ResourceWithoutMethod {
        private ResourceWithoutMethod() {
        }
    }

    private static class ResourceInfoWithMethod {
        private final String name;
        private final long value;

        private ResourceInfoWithMethod(String name, long value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }

        public static ResourceInfoWithMethod newInstance(String name, long value) {
            return new ResourceInfoWithMethod(name, value);
        }
    }

    private static class ResourceWithMethod {
        private final Map<String, ResourceInfoWithMethod> externalResource = new HashMap<String, ResourceInfoWithMethod>();

        private ResourceWithMethod() {
        }

        public void setResourceInformation(String name, ResourceInfoWithMethod resourceInfoWithMethod) {
            this.externalResource.put(name, resourceInfoWithMethod);
        }

        public ResourceInfoWithMethod[] getResources() {
            ResourceInfoWithMethod[] resourceInfos = new ResourceInfoWithMethod[2 + this.externalResource.size()];
            resourceInfos[0] = ResourceInfoWithMethod.newInstance("cpu", 1L);
            resourceInfos[1] = ResourceInfoWithMethod.newInstance("memory", 1024L);
            int i = 2;
            for (ResourceInfoWithMethod resourceInfoWithMethod : this.externalResource.values()) {
                resourceInfos[i++] = resourceInfoWithMethod;
            }
            return resourceInfos;
        }

        private ResourceInfoWithMethod getResourceWithName(String name) {
            return this.externalResource.get(name);
        }
    }
}

