/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.ResourceInformationReflector;
import org.apache.flink.yarn.TaskExecutorProcessSpecContainerResourcePriorityAdapter;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TaskExecutorProcessSpecContainerResourcePriorityAdapterTest
extends TestLogger {
    private static final Resource MAX_CONTAINER_RESOURCE = Resource.newInstance((int)102400, (int)100);
    private static final String SUPPORTED_EXTERNAL_RESOURCE_NAME = "testing-resource-name";
    private static final String SUPPORTED_EXTERNAL_RESOURCE_CONFIG_KEY = "testing-external-resource";
    private static final long SUPPORTED_EXTERNAL_RESOURCE_MAX = 10000L;
    private static final String UNSUPPORTED_EXTERNAL_RESOURCE_NAME = "testing-unsupported-resource";
    private static final String UNSUPPORTED_EXTERNAL_RESOURCE_CONFIG_KEY = "testing-unsupported-resource";
    private static final TaskExecutorProcessSpec TASK_EXECUTOR_PROCESS_SPEC_1 = new TaskExecutorProcessSpec(new CPUResource(1.0), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), Collections.emptyList());
    private static final TaskExecutorProcessSpec TASK_EXECUTOR_PROCESS_SPEC_2 = new TaskExecutorProcessSpec(new CPUResource(2.0), MemorySize.ofMebiBytes((long)200L), MemorySize.ofMebiBytes((long)200L), MemorySize.ofMebiBytes((long)200L), MemorySize.ofMebiBytes((long)200L), MemorySize.ofMebiBytes((long)200L), MemorySize.ofMebiBytes((long)200L), MemorySize.ofMebiBytes((long)200L), MemorySize.ofMebiBytes((long)200L), Collections.emptyList());
    private static final TaskExecutorProcessSpec TASK_EXECUTOR_PROCESS_SPEC_WITH_EXTERNAL_RESOURCE = new TaskExecutorProcessSpec(new CPUResource(1.0), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), Collections.singleton(new ExternalResource("testing-resource-name", 10000.0)));
    private static final TaskExecutorProcessSpec TASK_EXECUTOR_PROCESS_SPEC_WITH_EXTERNAL_RESOURCE_EXCEED_MAX = new TaskExecutorProcessSpec(new CPUResource(1.0), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), Collections.singleton(new ExternalResource("testing-resource-name", 10001.0)));
    private static final TaskExecutorProcessSpec TASK_EXECUTOR_PROCESS_SPEC_WITH_UNSUPPORTED_EXTERNAL_RESOURCE = new TaskExecutorProcessSpec(new CPUResource(1.0), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), MemorySize.ofMebiBytes((long)100L), Collections.singleton(new ExternalResource("testing-unsupported-resource", 1.0)));
    private static final TaskExecutorProcessSpec TASK_EXECUTOR_PROCESS_SPEC_EXCEED_MAX = new TaskExecutorProcessSpec(new CPUResource(200.0), MemorySize.ofMebiBytes((long)102400L), MemorySize.ofMebiBytes((long)102400L), MemorySize.ofMebiBytes((long)102400L), MemorySize.ofMebiBytes((long)102400L), MemorySize.ofMebiBytes((long)102400L), MemorySize.ofMebiBytes((long)102400L), MemorySize.ofMebiBytes((long)102400L), MemorySize.ofMebiBytes((long)102400L), Collections.emptyList());

    @Test
    public void testGetResourceFromSpec() {
        TaskExecutorProcessSpecContainerResourcePriorityAdapter adapter = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getAdapter();
        Resource resource = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getResource(adapter, TASK_EXECUTOR_PROCESS_SPEC_1);
        Assert.assertThat((Object)resource.getMemory(), (Matcher)Matchers.is((Object)TASK_EXECUTOR_PROCESS_SPEC_1.getTotalProcessMemorySize().getMebiBytes()));
        Assert.assertThat((Object)resource.getVirtualCores(), (Matcher)Matchers.is((Object)TASK_EXECUTOR_PROCESS_SPEC_1.getCpuCores().getValue().intValue()));
    }

    @Test
    public void testGetPriorityFromSpec() {
        TaskExecutorProcessSpecContainerResourcePriorityAdapter adapter = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getAdapter();
        Priority priority1 = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getPriority(adapter, TASK_EXECUTOR_PROCESS_SPEC_1);
        Priority priority2 = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getPriority(adapter, TASK_EXECUTOR_PROCESS_SPEC_2);
        Priority priority3 = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getPriority(adapter, TASK_EXECUTOR_PROCESS_SPEC_1);
        Assert.assertThat((Object)priority1, (Matcher)Matchers.not((Object)priority2));
        Assert.assertThat((Object)priority1, (Matcher)Matchers.is((Object)priority3));
    }

    @Test
    public void testMaxContainerResource() {
        TaskExecutorProcessSpecContainerResourcePriorityAdapter adapter = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getAdapter();
        Assert.assertThat((Object)adapter.getPriorityAndResource(TASK_EXECUTOR_PROCESS_SPEC_EXCEED_MAX).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetTaskExecutorProcessSpecAndResource() {
        TaskExecutorProcessSpecContainerResourcePriorityAdapter adapter = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getAdapter();
        TaskExecutorProcessSpecContainerResourcePriorityAdapter.PriorityAndResource addedPriorityAndResource = (TaskExecutorProcessSpecContainerResourcePriorityAdapter.PriorityAndResource)adapter.getPriorityAndResource(TASK_EXECUTOR_PROCESS_SPEC_1).get();
        Priority unknownPriority = Priority.newInstance((int)987);
        TaskExecutorProcessSpecContainerResourcePriorityAdapter.TaskExecutorProcessSpecAndResource resultSpecAndResource = (TaskExecutorProcessSpecContainerResourcePriorityAdapter.TaskExecutorProcessSpecAndResource)adapter.getTaskExecutorProcessSpecAndResource(addedPriorityAndResource.getPriority()).get();
        Assert.assertThat((Object)resultSpecAndResource.getTaskExecutorProcessSpec(), (Matcher)Matchers.is((Object)TASK_EXECUTOR_PROCESS_SPEC_1));
        Assert.assertThat((Object)resultSpecAndResource.getResource(), (Matcher)Matchers.is((Object)addedPriorityAndResource.getResource()));
        Assert.assertThat((Object)adapter.getTaskExecutorProcessSpecAndResource(unknownPriority).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testExternalResource() {
        Assume.assumeTrue((boolean)TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.isExternalResourceSupported());
        TaskExecutorProcessSpecContainerResourcePriorityAdapter adapter = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getAdapterWithExternalResources(SUPPORTED_EXTERNAL_RESOURCE_NAME, SUPPORTED_EXTERNAL_RESOURCE_CONFIG_KEY);
        Resource resource = TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getResource(adapter, TASK_EXECUTOR_PROCESS_SPEC_WITH_EXTERNAL_RESOURCE);
        Map resultExternalResources = ResourceInformationReflector.INSTANCE.getExternalResources(resource);
        Assert.assertThat((Object)resultExternalResources.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat(resultExternalResources.get(SUPPORTED_EXTERNAL_RESOURCE_CONFIG_KEY), (Matcher)Matchers.is((Object)10000L));
    }

    @Test(expected=IllegalStateException.class)
    public void testExternalResourceFailExceedMax() {
        Assume.assumeTrue((boolean)TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.isExternalResourceSupported());
        TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getAdapterWithExternalResources(SUPPORTED_EXTERNAL_RESOURCE_NAME, SUPPORTED_EXTERNAL_RESOURCE_CONFIG_KEY).getPriorityAndResource(TASK_EXECUTOR_PROCESS_SPEC_WITH_EXTERNAL_RESOURCE_EXCEED_MAX);
    }

    @Test(expected=IllegalStateException.class)
    public void testExternalResourceFailResourceTypeNotSupported() {
        Assume.assumeTrue((boolean)TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.isExternalResourceSupported());
        TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getAdapterWithExternalResources("testing-unsupported-resource", "testing-unsupported-resource").getPriorityAndResource(TASK_EXECUTOR_PROCESS_SPEC_WITH_UNSUPPORTED_EXTERNAL_RESOURCE);
    }

    @Test(expected=IllegalStateException.class)
    public void testExternalResourceFailHadoopVersionNotSupported() {
        Assume.assumeFalse((boolean)TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.isExternalResourceSupported());
        TaskExecutorProcessSpecContainerResourcePriorityAdapterTest.getAdapterWithExternalResources(SUPPORTED_EXTERNAL_RESOURCE_NAME, SUPPORTED_EXTERNAL_RESOURCE_CONFIG_KEY).getPriorityAndResource(TASK_EXECUTOR_PROCESS_SPEC_WITH_EXTERNAL_RESOURCE);
    }

    private static TaskExecutorProcessSpecContainerResourcePriorityAdapter getAdapter() {
        return new TaskExecutorProcessSpecContainerResourcePriorityAdapter(MAX_CONTAINER_RESOURCE, Collections.emptyMap());
    }

    private static TaskExecutorProcessSpecContainerResourcePriorityAdapter getAdapterWithExternalResources(String resourceName, String configKey) {
        Resource maxResource = Resource.newInstance((int)MAX_CONTAINER_RESOURCE.getMemory(), (int)MAX_CONTAINER_RESOURCE.getVirtualCores());
        ResourceInformationReflector.INSTANCE.setResourceInformation(maxResource, SUPPORTED_EXTERNAL_RESOURCE_CONFIG_KEY, 10000L);
        HashMap<String, String> externalResources = new HashMap<String, String>();
        externalResources.put(resourceName, configKey);
        return new TaskExecutorProcessSpecContainerResourcePriorityAdapter(maxResource, externalResources);
    }

    private static Resource getResource(TaskExecutorProcessSpecContainerResourcePriorityAdapter adapter, TaskExecutorProcessSpec spec) {
        return ((TaskExecutorProcessSpecContainerResourcePriorityAdapter.PriorityAndResource)adapter.getPriorityAndResource(spec).get()).getResource();
    }

    private static Priority getPriority(TaskExecutorProcessSpecContainerResourcePriorityAdapter adapter, TaskExecutorProcessSpec spec) {
        return ((TaskExecutorProcessSpecContainerResourcePriorityAdapter.PriorityAndResource)adapter.getPriorityAndResource(spec).get()).getPriority();
    }

    private static boolean isExternalResourceSupported() {
        return HadoopUtils.isMinHadoopVersion((int)2, (int)10) && ClassLoader.getSystemResource("resource-types.xml") != null;
    }
}

