/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.TriConsumer;
import org.apache.flink.util.function.TriFunction;
import org.apache.flink.yarn.TestingRegisterApplicationMasterResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.AMRMClientAsyncImpl;

public class TestingYarnAMRMClientAsync
extends AMRMClientAsyncImpl<AMRMClient.ContainerRequest> {
    private final Function<Tuple4<Priority, String, Resource, AMRMClientAsync.CallbackHandler>, List<? extends Collection<AMRMClient.ContainerRequest>>> getMatchingRequestsFunction;
    private final BiConsumer<AMRMClient.ContainerRequest, AMRMClientAsync.CallbackHandler> addContainerRequestConsumer;
    private final BiConsumer<AMRMClient.ContainerRequest, AMRMClientAsync.CallbackHandler> removeContainerRequestConsumer;
    private final BiConsumer<ContainerId, AMRMClientAsync.CallbackHandler> releaseAssignedContainerConsumer;
    private final Consumer<Integer> setHeartbeatIntervalConsumer;
    private final TriFunction<String, Integer, String, RegisterApplicationMasterResponse> registerApplicationMasterFunction;
    private final TriConsumer<FinalApplicationStatus, String, String> unregisterApplicationMasterConsumer;
    private final Runnable clientInitRunnable;
    private final Runnable clientStartRunnable;
    private final Runnable clientStopRunnable;

    private TestingYarnAMRMClientAsync(AMRMClientAsync.CallbackHandler callbackHandler, Function<Tuple4<Priority, String, Resource, AMRMClientAsync.CallbackHandler>, List<? extends Collection<AMRMClient.ContainerRequest>>> getMatchingRequestsFunction, BiConsumer<AMRMClient.ContainerRequest, AMRMClientAsync.CallbackHandler> addContainerRequestConsumer, BiConsumer<AMRMClient.ContainerRequest, AMRMClientAsync.CallbackHandler> removeContainerRequestConsumer, BiConsumer<ContainerId, AMRMClientAsync.CallbackHandler> releaseAssignedContainerConsumer, Consumer<Integer> setHeartbeatIntervalConsumer, TriFunction<String, Integer, String, RegisterApplicationMasterResponse> registerApplicationMasterFunction, TriConsumer<FinalApplicationStatus, String, String> unregisterApplicationMasterConsumer, Runnable clientInitRunnable, Runnable clientStartRunnable, Runnable clientStopRunnable) {
        super(0, callbackHandler);
        this.setHeartbeatIntervalConsumer = (Consumer)Preconditions.checkNotNull(setHeartbeatIntervalConsumer);
        this.addContainerRequestConsumer = (BiConsumer)Preconditions.checkNotNull(addContainerRequestConsumer);
        this.releaseAssignedContainerConsumer = (BiConsumer)Preconditions.checkNotNull(releaseAssignedContainerConsumer);
        this.removeContainerRequestConsumer = (BiConsumer)Preconditions.checkNotNull(removeContainerRequestConsumer);
        this.registerApplicationMasterFunction = (TriFunction)Preconditions.checkNotNull(registerApplicationMasterFunction);
        this.getMatchingRequestsFunction = (Function)Preconditions.checkNotNull(getMatchingRequestsFunction);
        this.unregisterApplicationMasterConsumer = (TriConsumer)Preconditions.checkNotNull(unregisterApplicationMasterConsumer);
        this.clientInitRunnable = (Runnable)Preconditions.checkNotNull((Object)clientInitRunnable);
        this.clientStartRunnable = (Runnable)Preconditions.checkNotNull((Object)clientStartRunnable);
        this.clientStopRunnable = (Runnable)Preconditions.checkNotNull((Object)clientStopRunnable);
    }

    public List<? extends Collection<AMRMClient.ContainerRequest>> getMatchingRequests(Priority priority, String resourceName, Resource capability) {
        return this.getMatchingRequestsFunction.apply((Tuple4<Priority, String, Resource, AMRMClientAsync.CallbackHandler>)Tuple4.of((Object)priority, (Object)resourceName, (Object)capability, (Object)this.handler));
    }

    public void addContainerRequest(AMRMClient.ContainerRequest req) {
        this.addContainerRequestConsumer.accept(req, this.handler);
    }

    public void removeContainerRequest(AMRMClient.ContainerRequest req) {
        this.removeContainerRequestConsumer.accept(req, this.handler);
    }

    public void releaseAssignedContainer(ContainerId containerId) {
        this.releaseAssignedContainerConsumer.accept(containerId, this.handler);
    }

    public void setHeartbeatInterval(int interval) {
        this.setHeartbeatIntervalConsumer.accept(interval);
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) {
        return (RegisterApplicationMasterResponse)this.registerApplicationMasterFunction.apply((Object)appHostName, (Object)appHostPort, (Object)appTrackingUrl);
    }

    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) {
        this.unregisterApplicationMasterConsumer.accept((Object)appStatus, (Object)appMessage, (Object)appTrackingUrl);
    }

    static Builder builder() {
        return new Builder();
    }

    public void init(Configuration conf) {
        this.clientInitRunnable.run();
    }

    public void start() {
        this.clientStartRunnable.run();
    }

    public void stop() {
        this.clientStopRunnable.run();
    }

    public static class Builder {
        private Function<Tuple4<Priority, String, Resource, AMRMClientAsync.CallbackHandler>, List<? extends Collection<AMRMClient.ContainerRequest>>> getMatchingRequestsFunction = ignored -> Collections.emptyList();
        private BiConsumer<AMRMClient.ContainerRequest, AMRMClientAsync.CallbackHandler> addContainerRequestConsumer = (ignored1, ignored2) -> {};
        private BiConsumer<AMRMClient.ContainerRequest, AMRMClientAsync.CallbackHandler> removeContainerRequestConsumer = (ignored1, ignored2) -> {};
        private BiConsumer<ContainerId, AMRMClientAsync.CallbackHandler> releaseAssignedContainerConsumer = (ignored1, ignored2) -> {};
        private Consumer<Integer> setHeartbeatIntervalConsumer = ignored -> {};
        private TriFunction<String, Integer, String, RegisterApplicationMasterResponse> registerApplicationMasterFunction = (ignored1, ignored2, ignored3) -> new TestingRegisterApplicationMasterResponse(Collections::emptyList);
        private TriConsumer<FinalApplicationStatus, String, String> unregisterApplicationMasterConsumer = (ignored1, ignored2, ignored3) -> {};
        private Runnable clientInitRunnable = () -> {};
        private Runnable clientStartRunnable = () -> {};
        private Runnable clientStopRunnable = () -> {};

        private Builder() {
        }

        Builder setAddContainerRequestConsumer(BiConsumer<AMRMClient.ContainerRequest, AMRMClientAsync.CallbackHandler> addContainerRequestConsumer) {
            this.addContainerRequestConsumer = addContainerRequestConsumer;
            return this;
        }

        Builder setGetMatchingRequestsFunction(Function<Tuple4<Priority, String, Resource, AMRMClientAsync.CallbackHandler>, List<? extends Collection<AMRMClient.ContainerRequest>>> getMatchingRequestsFunction) {
            this.getMatchingRequestsFunction = getMatchingRequestsFunction;
            return this;
        }

        Builder setRegisterApplicationMasterFunction(TriFunction<String, Integer, String, RegisterApplicationMasterResponse> registerApplicationMasterFunction) {
            this.registerApplicationMasterFunction = registerApplicationMasterFunction;
            return this;
        }

        Builder setReleaseAssignedContainerConsumer(BiConsumer<ContainerId, AMRMClientAsync.CallbackHandler> releaseAssignedContainerConsumer) {
            this.releaseAssignedContainerConsumer = releaseAssignedContainerConsumer;
            return this;
        }

        Builder setRemoveContainerRequestConsumer(BiConsumer<AMRMClient.ContainerRequest, AMRMClientAsync.CallbackHandler> removeContainerRequestConsumer) {
            this.removeContainerRequestConsumer = removeContainerRequestConsumer;
            return this;
        }

        Builder setSetHeartbeatIntervalConsumer(Consumer<Integer> setHeartbeatIntervalConsumer) {
            this.setHeartbeatIntervalConsumer = setHeartbeatIntervalConsumer;
            return this;
        }

        Builder setUnregisterApplicationMasterConsumer(TriConsumer<FinalApplicationStatus, String, String> unregisterApplicationMasterConsumer) {
            this.unregisterApplicationMasterConsumer = unregisterApplicationMasterConsumer;
            return this;
        }

        Builder setClientInitRunnable(Runnable clientInitRunnable) {
            this.clientInitRunnable = clientInitRunnable;
            return this;
        }

        Builder setClientStartRunnable(Runnable clientStartRunnable) {
            this.clientStartRunnable = clientStartRunnable;
            return this;
        }

        Builder setClientStopRunnable(Runnable clientStopRunnable) {
            this.clientStopRunnable = clientStopRunnable;
            return this;
        }

        public TestingYarnAMRMClientAsync build(AMRMClientAsync.CallbackHandler callbackHandler) {
            return new TestingYarnAMRMClientAsync(callbackHandler, this.getMatchingRequestsFunction, this.addContainerRequestConsumer, this.removeContainerRequestConsumer, this.releaseAssignedContainerConsumer, this.setHeartbeatIntervalConsumer, this.registerApplicationMasterFunction, this.unregisterApplicationMasterConsumer, this.clientInitRunnable, this.clientStartRunnable, this.clientStopRunnable);
        }
    }
}

