/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.TriConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;

class TestingYarnNMClientAsync
extends NMClientAsyncImpl {
    private final TriConsumer<Container, ContainerLaunchContext, NMClientAsync.CallbackHandler> startContainerAsyncConsumer;
    private final TriConsumer<ContainerId, NodeId, NMClientAsync.CallbackHandler> stopContainerAsyncConsumer;
    private final Runnable clientInitRunnable;
    private final Runnable clientStartRunnable;
    private final Runnable clientStopRunnable;

    private TestingYarnNMClientAsync(NMClientAsync.CallbackHandler callbackHandler, TriConsumer<Container, ContainerLaunchContext, NMClientAsync.CallbackHandler> startContainerAsyncConsumer, TriConsumer<ContainerId, NodeId, NMClientAsync.CallbackHandler> stopContainerAsyncConsumer, Runnable clientInitRunnable, Runnable clientStartRunnable, Runnable clientStopRunnable) {
        super(callbackHandler);
        this.startContainerAsyncConsumer = (TriConsumer)Preconditions.checkNotNull(startContainerAsyncConsumer);
        this.stopContainerAsyncConsumer = (TriConsumer)Preconditions.checkNotNull(stopContainerAsyncConsumer);
        this.clientInitRunnable = (Runnable)Preconditions.checkNotNull((Object)clientInitRunnable);
        this.clientStartRunnable = (Runnable)Preconditions.checkNotNull((Object)clientStartRunnable);
        this.clientStopRunnable = (Runnable)Preconditions.checkNotNull((Object)clientStopRunnable);
    }

    public void startContainerAsync(Container container, ContainerLaunchContext containerLaunchContext) {
        this.startContainerAsyncConsumer.accept((Object)container, (Object)containerLaunchContext, (Object)this.callbackHandler);
    }

    public void stopContainerAsync(ContainerId containerId, NodeId nodeId) {
        this.stopContainerAsyncConsumer.accept((Object)containerId, (Object)nodeId, (Object)this.callbackHandler);
    }

    static Builder builder() {
        return new Builder();
    }

    public void init(Configuration conf) {
        this.clientInitRunnable.run();
    }

    public void start() {
        this.clientStartRunnable.run();
    }

    public void stop() {
        this.clientStopRunnable.run();
    }

    public static class Builder {
        private TriConsumer<Container, ContainerLaunchContext, NMClientAsync.CallbackHandler> startContainerAsyncConsumer = (ignored1, ignored2, ignored3) -> {};
        private TriConsumer<ContainerId, NodeId, NMClientAsync.CallbackHandler> stopContainerAsyncConsumer = (ignored1, ignored2, ignored3) -> {};
        private Runnable clientInitRunnable = () -> {};
        private Runnable clientStartRunnable = () -> {};
        private Runnable clientStopRunnable = () -> {};

        private Builder() {
        }

        Builder setStartContainerAsyncConsumer(TriConsumer<Container, ContainerLaunchContext, NMClientAsync.CallbackHandler> startContainerAsyncConsumer) {
            this.startContainerAsyncConsumer = startContainerAsyncConsumer;
            return this;
        }

        Builder setStopContainerAsyncConsumer(TriConsumer<ContainerId, NodeId, NMClientAsync.CallbackHandler> stopContainerAsyncConsumer) {
            this.stopContainerAsyncConsumer = stopContainerAsyncConsumer;
            return this;
        }

        Builder setClientInitRunnable(Runnable clientInitRunnable) {
            this.clientInitRunnable = clientInitRunnable;
            return this;
        }

        Builder setClientStartRunnable(Runnable clientStartRunnable) {
            this.clientStartRunnable = clientStartRunnable;
            return this;
        }

        Builder setClientStopRunnable(Runnable clientStopRunnable) {
            this.clientStopRunnable = clientStopRunnable;
            return this;
        }

        public TestingYarnNMClientAsync build(NMClientAsync.CallbackHandler callbackHandler) {
            return new TestingYarnNMClientAsync(callbackHandler, this.startContainerAsyncConsumer, this.stopContainerAsyncConsumer, this.clientInitRunnable, this.clientStartRunnable, this.clientStopRunnable);
        }
    }
}

