/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.YarnApplicationFileUploader;
import org.apache.flink.yarn.YarnTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class YarnApplicationFileUploaderTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testRegisterProvidedLocalResources() throws IOException {
        File flinkLibDir = this.temporaryFolder.newFolder();
        Map<String, String> libJars = YarnApplicationFileUploaderTest.getLibJars();
        YarnTestUtils.generateFilesInDirectory(flinkLibDir, libJars);
        try (YarnApplicationFileUploader yarnApplicationFileUploader = YarnApplicationFileUploader.from((FileSystem)FileSystem.get((Configuration)new YarnConfiguration()), (Path)new Path(this.temporaryFolder.getRoot().toURI()), Collections.singletonList(new Path(flinkLibDir.toURI())), (ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)3);){
            yarnApplicationFileUploader.registerProvidedLocalResources();
            Set registeredResources = yarnApplicationFileUploader.getRegisteredLocalResources().keySet();
            Assert.assertThat(registeredResources, (Matcher)Matchers.containsInAnyOrder((Object[])libJars.keySet().toArray()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterProvidedLocalResourcesWithDuplication() throws IOException {
        File flinkLibDir1 = this.temporaryFolder.newFolder();
        File flinkLibDir2 = this.temporaryFolder.newFolder();
        YarnTestUtils.generateFilesInDirectory(flinkLibDir1, YarnApplicationFileUploaderTest.getLibJars());
        YarnTestUtils.generateFilesInDirectory(flinkLibDir2, YarnApplicationFileUploaderTest.getLibJars());
        FileSystem fileSystem = FileSystem.get((Configuration)new YarnConfiguration());
        try {
            CommonTestUtils.assertThrows((String)"Two files with the same filename exist in the shared libs", RuntimeException.class, () -> YarnApplicationFileUploader.from((FileSystem)fileSystem, (Path)new Path(this.temporaryFolder.getRoot().toURI()), Arrays.asList(new Path(flinkLibDir1.toURI()), new Path(flinkLibDir2.toURI())), (ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)3));
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)fileSystem);
        }
    }

    private static Map<String, String> getLibJars() {
        HashMap<String, String> libJars = new HashMap<String, String>(4);
        String jarContent = "JAR Content";
        libJars.put("flink-dist.jar", "JAR Content");
        libJars.put("log4j.jar", "JAR Content");
        libJars.put("flink-table.jar", "JAR Content");
        return libJars;
    }
}

