/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.YarnApplicationFileUploader;
import org.apache.flink.yarn.YarnTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class YarnFileStageTest
extends TestLogger {
    private static final String LOCAL_RESOURCE_DIRECTORY = "stage_test";
    @ClassRule
    public static final TemporaryFolder CLASS_TEMP_DIR = new TemporaryFolder();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private static MiniDFSCluster hdfsCluster;
    private static Path hdfsRootPath;
    private Configuration hadoopConfig;

    @BeforeClass
    public static void createHDFS() throws Exception {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        File tempDir = CLASS_TEMP_DIR.newFolder();
        Configuration hdConf = new Configuration();
        hdConf.set("hdfs.minidfs.basedir", tempDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(hdConf);
        hdfsCluster = builder.build();
        hdfsRootPath = new Path(hdfsCluster.getURI());
    }

    @AfterClass
    public static void destroyHDFS() {
        if (hdfsCluster != null) {
            hdfsCluster.shutdown();
        }
        hdfsCluster = null;
        hdfsRootPath = null;
    }

    @Before
    public void initConfig() {
        this.hadoopConfig = new Configuration();
        this.hadoopConfig.set("fs.defaultFS", hdfsRootPath.toString());
    }

    @Test
    public void testCopyFromLocalRecursiveWithScheme() throws Exception {
        FileSystem targetFileSystem = hdfsRootPath.getFileSystem(this.hadoopConfig);
        Path targetDir = targetFileSystem.getWorkingDirectory();
        YarnFileStageTest.testRegisterMultipleLocalResources(targetFileSystem, targetDir, LOCAL_RESOURCE_DIRECTORY, this.tempFolder, true, false);
    }

    @Test
    public void testCopyFromLocalRecursiveWithoutScheme() throws Exception {
        FileSystem targetFileSystem = hdfsRootPath.getFileSystem(this.hadoopConfig);
        Path targetDir = targetFileSystem.getWorkingDirectory();
        YarnFileStageTest.testRegisterMultipleLocalResources(targetFileSystem, targetDir, LOCAL_RESOURCE_DIRECTORY, this.tempFolder, false, false);
    }

    @Test
    public void testCopySingleFileFromLocal() throws IOException, URISyntaxException, InterruptedException {
        FileSystem targetFileSystem = hdfsRootPath.getFileSystem(this.hadoopConfig);
        Path targetDir = targetFileSystem.getWorkingDirectory();
        YarnFileStageTest.testCopySingleFileFromLocal(targetFileSystem, targetDir, LOCAL_RESOURCE_DIRECTORY, this.tempFolder);
    }

    @Test
    public void testRegisterMultipleLocalResourcesWithRemoteFiles() throws Exception {
        FileSystem targetFileSystem = hdfsRootPath.getFileSystem(this.hadoopConfig);
        Path targetDir = targetFileSystem.getWorkingDirectory();
        YarnFileStageTest.testRegisterMultipleLocalResources(targetFileSystem, targetDir, LOCAL_RESOURCE_DIRECTORY, this.tempFolder, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testRegisterMultipleLocalResources(FileSystem targetFileSystem, Path targetDir, String localResourceDirectory, TemporaryFolder tempFolder, boolean addSchemeToLocalPath, boolean useRemoteFiles) throws Exception {
        Path srcPath;
        Assert.assertFalse((boolean)targetFileSystem.exists(targetDir));
        File srcDir = tempFolder.newFolder();
        HashMap<String, String> srcFiles = new HashMap<String, String>(4);
        srcFiles.put("1", "Hello 1");
        srcFiles.put("2", "Hello 2");
        srcFiles.put("nested/3", "Hello nested/3");
        srcFiles.put("nested/4/5", "Hello nested/4/5");
        srcFiles.put("test.jar", "JAR Content");
        YarnTestUtils.generateFilesInDirectory(srcDir, srcFiles);
        if (useRemoteFiles) {
            srcPath = new Path(hdfsRootPath.toString() + "/tmp/remoteFiles");
            hdfsCluster.getFileSystem().copyFromLocalFile(new Path(srcDir.getAbsolutePath()), srcPath);
        } else {
            srcPath = addSchemeToLocalPath ? new Path("file://" + srcDir.getAbsolutePath()) : new Path(srcDir.getAbsolutePath());
        }
        try {
            ArrayList remotePaths = new ArrayList();
            ApplicationId applicationId = ApplicationId.newInstance((long)0L, (int)0);
            YarnApplicationFileUploader uploader = YarnApplicationFileUploader.from((FileSystem)targetFileSystem, (Path)targetDir, Collections.emptyList(), (ApplicationId)applicationId, (int)3);
            List classpath = uploader.registerMultipleLocalResources(Collections.singletonList(srcPath), localResourceDirectory, LocalResourceType.FILE);
            Path basePath = new Path(localResourceDirectory, srcPath.getName());
            Path nestedPath = new Path(basePath, "nested");
            MatcherAssert.assertThat((Object)classpath, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{basePath.toString(), nestedPath.toString(), new Path(nestedPath, "4").toString(), new Path(basePath, "test.jar").toString()}));
            Map localResources = uploader.getRegisteredLocalResources();
            Assert.assertEquals((long)srcFiles.size(), (long)localResources.size());
            Path workDir = ConverterUtils.getPathFromYarnURL((URL)((LocalResource)localResources.get(new Path(localResourceDirectory, new Path(srcPath.getName(), "1")).toString())).getResource()).getParent();
            YarnFileStageTest.verifyDirectoryRecursive(targetFileSystem, workDir, srcFiles);
        }
        finally {
            targetFileSystem.delete(targetDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCopySingleFileFromLocal(FileSystem targetFileSystem, Path targetDir, String localResourceDirectory, TemporaryFolder temporaryFolder) throws IOException, InterruptedException, URISyntaxException {
        File srcDir = temporaryFolder.newFolder();
        String localFile = "local.jar";
        String localFileContent = "Local Jar Content";
        HashMap<String, String> srcFiles = new HashMap<String, String>(4);
        srcFiles.put("local.jar", "Local Jar Content");
        YarnTestUtils.generateFilesInDirectory(srcDir, srcFiles);
        try {
            ArrayList remotePaths = new ArrayList();
            ApplicationId applicationId = ApplicationId.newInstance((long)0L, (int)0);
            YarnApplicationFileUploader uploader = YarnApplicationFileUploader.from((FileSystem)targetFileSystem, (Path)targetDir, Collections.emptyList(), (ApplicationId)applicationId, (int)3);
            List classpath = uploader.registerMultipleLocalResources(Collections.singletonList(new Path(srcDir.getAbsolutePath(), "local.jar")), localResourceDirectory, LocalResourceType.FILE);
            MatcherAssert.assertThat((Object)classpath, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{new Path(localResourceDirectory, "local.jar").toString()}));
            Map localResources = uploader.getRegisteredLocalResources();
            Path workDir = ConverterUtils.getPathFromYarnURL((URL)((LocalResource)localResources.get(new Path(localResourceDirectory, "local.jar").toString())).getResource()).getParent();
            YarnFileStageTest.verifyDirectoryRecursive(targetFileSystem, workDir, srcFiles);
        }
        finally {
            targetFileSystem.delete(targetDir, true);
        }
    }

    private static void verifyDirectoryRecursive(FileSystem targetFileSystem, Path workDir, Map<String, String> expectedFiles) throws IOException, InterruptedException {
        HashMap<String, String> targetFiles = new HashMap<String, String>();
        RemoteIterator targetFilesIterator = targetFileSystem.listFiles(workDir, true);
        int workDirPrefixLength = workDir.toString().length() + 1;
        block11: while (targetFilesIterator.hasNext()) {
            LocatedFileStatus targetFile = (LocatedFileStatus)targetFilesIterator.next();
            int retries = 5;
            while (true) {
                try {
                    FSDataInputStream in = targetFileSystem.open(targetFile.getPath());
                    Throwable throwable = null;
                    try {
                        String absolutePathString = targetFile.getPath().toString();
                        String relativePath = absolutePathString.substring(workDirPrefixLength);
                        targetFiles.put(relativePath, in.readUTF());
                        Assert.assertEquals((String)("extraneous data in file " + relativePath), (long)-1L, (long)in.read());
                        continue block11;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue block11;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue block11;
                        }
                        in.close();
                    }
                }
                catch (FileNotFoundException e) {
                    Thread.sleep(50L);
                    if (retries-- > 0) continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat(targetFiles, (Matcher)Matchers.equalTo(expectedFiles));
    }
}

