/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.testutils.junit.RetryOnFailure;
import org.apache.flink.testutils.junit.RetryRule;
import org.apache.flink.testutils.s3.S3TestCredentials;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.YarnFileStageTest;
import org.apache.hadoop.util.VersionUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class YarnFileStageTestS3ITCase
extends TestLogger {
    private static final String TEST_DATA_DIR = "tests-" + UUID.randomUUID();
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public final RetryRule retryRule = new RetryRule();
    private static int numRecursiveUploadTests = 0;
    private static boolean skipTest = true;

    @BeforeClass
    public static void checkCredentialsAndSetup() throws IOException {
        S3TestCredentials.assumeCredentialsAvailable();
        skipTest = false;
        YarnFileStageTestS3ITCase.setupCustomHadoopConfig();
    }

    @AfterClass
    public static void resetFileSystemConfiguration() throws IOException {
        FileSystem.initialize((Configuration)new Configuration());
    }

    @AfterClass
    public static void checkAtLeastOneTestRun() {
        if (!skipTest) {
            Assert.assertThat((String)"No S3 filesystem upload test executed. Please activate the 'include_hadoop_aws' build profile or set '-Dinclude_hadoop_aws' during build (Hadoop >= 2.6 moved S3 filesystems out of hadoop-common).", (Object)numRecursiveUploadTests, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
    }

    private static void setupCustomHadoopConfig() throws IOException {
        File hadoopConfig = TEMP_FOLDER.newFile();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("fs.s3a.access.key", S3TestCredentials.getS3AccessKey());
        parameters.put("fs.s3a.secret.key", S3TestCredentials.getS3SecretKey());
        parameters.put("fs.s3.awsAccessKeyId", S3TestCredentials.getS3AccessKey());
        parameters.put("fs.s3.awsSecretAccessKey", S3TestCredentials.getS3SecretKey());
        parameters.put("fs.s3n.awsAccessKeyId", S3TestCredentials.getS3AccessKey());
        parameters.put("fs.s3n.awsSecretAccessKey", S3TestCredentials.getS3SecretKey());
        try (PrintStream out = new PrintStream(new FileOutputStream(hadoopConfig));){
            out.println("<?xml version=\"1.0\"?>");
            out.println("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>");
            out.println("<configuration>");
            for (Map.Entry entry : parameters.entrySet()) {
                out.println("\t<property>");
                out.println("\t\t<name>" + (String)entry.getKey() + "</name>");
                out.println("\t\t<value>" + (String)entry.getValue() + "</value>");
                out.println("\t</property>");
            }
            out.println("</configuration>");
        }
        Configuration conf = new Configuration();
        conf.setString("fs.hdfs.hdfssite", hadoopConfig.getAbsolutePath());
        conf.set(CoreOptions.ALLOWED_FALLBACK_FILESYSTEMS, (Object)"s3;s3a;s3n");
        FileSystem.initialize((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRecursiveUploadForYarn(String scheme, String pathSuffix) throws Exception {
        ++numRecursiveUploadTests;
        Path basePath = new Path(S3TestCredentials.getTestBucketUriWithScheme((String)scheme) + TEST_DATA_DIR);
        HadoopFileSystem fs = (HadoopFileSystem)basePath.getFileSystem();
        Assume.assumeFalse((boolean)fs.exists(basePath));
        try {
            Path directory = new Path(basePath, pathSuffix);
            YarnFileStageTest.testRegisterMultipleLocalResources(fs.getHadoopFileSystem(), new org.apache.hadoop.fs.Path(directory.toUri()), ".", this.tempFolder, false, false);
        }
        finally {
            fs.delete(basePath, true);
        }
    }

    @Test
    @RetryOnFailure(times=3)
    public void testRecursiveUploadForYarnS3n() throws Exception {
        Assume.assumeTrue((String)"This test is skipped for Hadoop versions above 3", (VersionUtil.compareVersions((String)System.getProperty("hadoop.version"), (String)"3.0.0") < 0 ? 1 : 0) != 0);
        try {
            Class.forName("org.apache.hadoop.fs.s3native.NativeS3FileSystem");
        }
        catch (ClassNotFoundException e) {
            String msg = "Skipping test because NativeS3FileSystem is not in the class path";
            this.log.info(msg);
            Assume.assumeNoException((String)msg, (Throwable)e);
        }
        this.testRecursiveUploadForYarn("s3n", "testYarn-s3n");
    }

    @Test
    @RetryOnFailure(times=3)
    public void testRecursiveUploadForYarnS3a() throws Exception {
        try {
            Class.forName("org.apache.hadoop.fs.s3a.S3AFileSystem");
        }
        catch (ClassNotFoundException e) {
            String msg = "Skipping test because S3AFileSystem is not in the class path";
            this.log.info(msg);
            Assume.assumeNoException((String)msg, (Throwable)e);
        }
        this.testRecursiveUploadForYarn("s3a", "testYarn-s3a");
    }
}

