/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriverTestBase;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableList;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.TriConsumer;
import org.apache.flink.util.function.TriFunction;
import org.apache.flink.yarn.TestingContainer;
import org.apache.flink.yarn.TestingContainerStatus;
import org.apache.flink.yarn.TestingRegisterApplicationMasterResponse;
import org.apache.flink.yarn.TestingYarnAMRMClientAsync;
import org.apache.flink.yarn.TestingYarnNMClientAsync;
import org.apache.flink.yarn.TestingYarnNodeManagerClientFactory;
import org.apache.flink.yarn.TestingYarnResourceManagerClientFactory;
import org.apache.flink.yarn.YarnLocalResourceDescriptor;
import org.apache.flink.yarn.YarnNodeManagerClientFactory;
import org.apache.flink.yarn.YarnResourceManagerClientFactory;
import org.apache.flink.yarn.YarnResourceManagerDriver;
import org.apache.flink.yarn.YarnWorkerNode;
import org.apache.flink.yarn.configuration.YarnResourceManagerDriverConfiguration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class YarnResourceManagerDriverTest
extends ResourceManagerDriverTestBase<YarnWorkerNode> {
    private static final Resource testingResource = Resource.newInstance((int)1024, (int)1);
    private static final Priority testingPriority = Priority.newInstance((int)1);
    private static final Container testingContainer = YarnResourceManagerDriverTest.createTestingContainerWithResource(testingResource, testingPriority, 1);
    private static final TaskExecutorProcessSpec testingTaskExecutorProcessSpec = new TaskExecutorProcessSpec(new CPUResource(1.0), MemorySize.ZERO, MemorySize.ZERO, MemorySize.ofMebiBytes((long)256L), MemorySize.ofMebiBytes((long)256L), MemorySize.ofMebiBytes((long)256L), MemorySize.ofMebiBytes((long)256L), MemorySize.ZERO, MemorySize.ZERO, Collections.emptyList());
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    protected Context createContext() {
        return new Context();
    }

    @Test
    public void testRunAsyncCausesFatalError() throws Exception {
        new Context(){
            {
                String exceptionMessage = "runAsyncCausesFatalError";
                this.addContainerRequestFutures.add(CompletableFuture.completedFuture(null));
                this.testingYarnAMRMClientAsyncBuilder.setGetMatchingRequestsFunction(ignored -> {
                    throw new RuntimeException("runAsyncCausesFatalError");
                });
                CompletableFuture throwableCompletableFuture = new CompletableFuture();
                this.resourceEventHandlerBuilder.setOnErrorConsumer(throwableCompletableFuture::complete);
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getDriver().requestResource(testingTaskExecutorProcessSpec));
                    this.resourceManagerClientCallbackHandler.onContainersAllocated((List)ImmutableList.of((Object)testingContainer));
                    Throwable t = (Throwable)throwableCompletableFuture.get(5L, TimeUnit.SECONDS);
                    Optional optionalCause = ExceptionUtils.findThrowable((Throwable)t, RuntimeException.class);
                    Assert.assertTrue((boolean)optionalCause.isPresent());
                    Assert.assertThat((Object)((RuntimeException)optionalCause.get()).getMessage(), (Matcher)Matchers.is((Object)"runAsyncCausesFatalError"));
                });
            }
        };
    }

    @Test
    public void testShutdownRequestCausesFatalError() throws Exception {
        new Context(){
            {
                CompletableFuture throwableCompletableFuture = new CompletableFuture();
                this.resourceEventHandlerBuilder.setOnErrorConsumer(throwableCompletableFuture::complete);
                this.runTest(() -> {
                    this.resourceManagerClientCallbackHandler.onShutdownRequest();
                    Throwable throwable = (Throwable)throwableCompletableFuture.get(5L, TimeUnit.SECONDS);
                    Assert.assertThat((Object)ExceptionUtils.findThrowable((Throwable)throwable, ResourceManagerException.class).isPresent(), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)ExceptionUtils.findThrowableWithMessage((Throwable)throwable, (String)"Received shutdown request from YARN ResourceManager.").isPresent(), (Matcher)Matchers.is((Object)true));
                });
            }
        };
    }

    @Test
    public void testDeleteApplicationFiles() throws Exception {
        new Context(){
            {
                File applicationDir = YarnResourceManagerDriverTest.this.folder.newFolder(".flink");
                this.env.put("_FLINK_YARN_FILES", applicationDir.getCanonicalPath());
                this.runTest(() -> {
                    this.getDriver().deregisterApplication(ApplicationStatus.SUCCEEDED, null);
                    Assert.assertFalse((String)"YARN application directory was not removed", (boolean)Files.exists(applicationDir.toPath(), new LinkOption[0]));
                });
            }
        };
    }

    @Test
    public void testOnContainerAllocated() throws Exception {
        new Context(){
            {
                this.addContainerRequestFutures.add(new CompletableFuture());
                this.testingYarnAMRMClientAsyncBuilder.setAddContainerRequestConsumer((ignored1, ignored2) -> ((CompletableFuture)this.addContainerRequestFutures.get(this.addContainerRequestFuturesNumCompleted.getAndIncrement())).complete(null));
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getDriver().requestResource(testingTaskExecutorProcessSpec));
                    this.resourceManagerClientCallbackHandler.onContainersAllocated((List)ImmutableList.of((Object)testingContainer));
                    this.verifyFutureCompleted((CompletableFuture)this.addContainerRequestFutures.get(0));
                    this.verifyFutureCompleted(this.removeContainerRequestFuture);
                    this.verifyFutureCompleted(this.startContainerAsyncFuture);
                });
            }
        };
    }

    @Test
    public void testOnSuccessfulContainerCompleted() throws Exception {
        this.runTestOnContainerCompleted(this.createSuccessfulCompletedContainerStatus());
    }

    @Test
    public void testOnContainerCompletedBecauseDisksFailed() throws Exception {
        this.runTestOnContainerCompleted(this.createCompletedContainerStatusBecauseDisksFailed());
    }

    @Test
    public void testOnContainerCompletedBecauseItWasAborted() throws Exception {
        this.runTestOnContainerCompleted(this.createCompletedContainerStatusBecauseItWasAborted());
    }

    @Test
    public void testOnContainerCompletedBecauseItWasInvalid() throws Exception {
        this.runTestOnContainerCompleted(this.createCompletedContainerStatusBecauseItWasInvalid());
    }

    @Test
    public void testOnContainerCompletedForUnknownCause() throws Exception {
        this.runTestOnContainerCompleted(this.createCompletedContainerStatusForUnknownCause());
    }

    @Test
    public void testOnContainerCompletedBecauseItWasPreempted() throws Exception {
        this.runTestOnContainerCompleted(this.createCompletedContainerStatusBecauseItWasPreempted());
    }

    public void runTestOnContainerCompleted(final ContainerStatus completedContainerStatus) throws Exception {
        new Context(){
            {
                this.addContainerRequestFutures.add(new CompletableFuture());
                this.addContainerRequestFutures.add(new CompletableFuture());
                this.testingYarnAMRMClientAsyncBuilder.setAddContainerRequestConsumer((ignored1, ignored2) -> ((CompletableFuture)this.addContainerRequestFutures.get(this.addContainerRequestFuturesNumCompleted.getAndIncrement())).complete(null));
                this.resourceEventHandlerBuilder.setOnWorkerTerminatedConsumer((ignore1, ignore2) -> this.getDriver().requestResource(testingTaskExecutorProcessSpec));
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getDriver().requestResource(testingTaskExecutorProcessSpec));
                    this.resourceManagerClientCallbackHandler.onContainersAllocated((List)ImmutableList.of((Object)testingContainer));
                    this.resourceManagerClientCallbackHandler.onContainersCompleted((List)ImmutableList.of((Object)completedContainerStatus));
                    this.verifyFutureCompleted((CompletableFuture)this.addContainerRequestFutures.get(1));
                });
            }
        };
    }

    @Test
    public void testOnStartContainerError() throws Exception {
        new Context(){
            {
                this.addContainerRequestFutures.add(new CompletableFuture());
                this.addContainerRequestFutures.add(new CompletableFuture());
                this.testingYarnAMRMClientAsyncBuilder.setAddContainerRequestConsumer((ignored1, ignored2) -> ((CompletableFuture)this.addContainerRequestFutures.get(this.addContainerRequestFuturesNumCompleted.getAndIncrement())).complete(null));
                this.resourceEventHandlerBuilder.setOnWorkerTerminatedConsumer((ignore1, ignore2) -> this.getDriver().requestResource(testingTaskExecutorProcessSpec));
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getDriver().requestResource(testingTaskExecutorProcessSpec));
                    this.resourceManagerClientCallbackHandler.onContainersAllocated((List)ImmutableList.of((Object)testingContainer));
                    this.nodeManagerClientCallbackHandler.onStartContainerError(testingContainer.getId(), (Throwable)new Exception("start error"));
                    this.verifyFutureCompleted(this.releaseAssignedContainerFuture);
                    this.verifyFutureCompleted((CompletableFuture)this.addContainerRequestFutures.get(1));
                });
            }
        };
    }

    @Test
    public void testStartWorkerVariousSpec() throws Exception {
        final TaskExecutorProcessSpec taskExecutorProcessSpec1 = new TaskExecutorProcessSpec(new CPUResource(1.0), MemorySize.ZERO, MemorySize.ZERO, MemorySize.ofMebiBytes((long)50L), MemorySize.ofMebiBytes((long)50L), MemorySize.ofMebiBytes((long)50L), MemorySize.ofMebiBytes((long)50L), MemorySize.ZERO, MemorySize.ZERO, Collections.emptyList());
        final TaskExecutorProcessSpec taskExecutorProcessSpec2 = new TaskExecutorProcessSpec(new CPUResource(2.0), MemorySize.ZERO, MemorySize.ZERO, MemorySize.ofMebiBytes((long)500L), MemorySize.ofMebiBytes((long)500L), MemorySize.ofMebiBytes((long)500L), MemorySize.ofMebiBytes((long)500L), MemorySize.ZERO, MemorySize.ZERO, Collections.emptyList());
        new Context(){
            {
                String startCommand1 = TaskManagerOptions.TASK_HEAP_MEMORY.key() + "=" + 0x3200000L;
                String startCommand2 = TaskManagerOptions.TASK_HEAP_MEMORY.key() + "=" + 0x6400000L;
                CompletableFuture<Void> startContainerAsyncCommandFuture1 = new CompletableFuture<Void>();
                CompletableFuture<Void> startContainerAsyncCommandFuture2 = new CompletableFuture<Void>();
                this.prepareForTestStartTaskExecutorProcessVariousSpec(startCommand1, startCommand2, startContainerAsyncCommandFuture1, startContainerAsyncCommandFuture2, taskExecutorProcessSpec1);
                this.testingYarnAMRMClientAsyncBuilder.setGetMatchingRequestsFunction(tuple -> {
                    Priority priority = (Priority)tuple.f0;
                    ArrayList<AMRMClient.ContainerRequest> matchingRequests = new ArrayList<AMRMClient.ContainerRequest>();
                    for (CompletableFuture addContainerRequestFuture : this.addContainerRequestFutures) {
                        AMRMClient.ContainerRequest request = addContainerRequestFuture.getNow(null);
                        if (request == null || !priority.equals((Object)request.getPriority())) continue;
                        Assert.assertThat((Object)tuple.f2, (Matcher)Matchers.is((Object)request.getCapability()));
                        matchingRequests.add(request);
                    }
                    return Collections.singletonList(matchingRequests);
                });
                this.runTest(() -> {
                    Resource containerResource1 = (Resource)((YarnResourceManagerDriver)this.getDriver()).getContainerResource(taskExecutorProcessSpec1).get();
                    Resource containerResource2 = (Resource)((YarnResourceManagerDriver)this.getDriver()).getContainerResource(taskExecutorProcessSpec2).get();
                    Assert.assertNotEquals((Object)containerResource1, (Object)containerResource2);
                    this.runInMainThread(() -> this.getDriver().requestResource(taskExecutorProcessSpec1));
                    this.runInMainThread(() -> this.getDriver().requestResource(taskExecutorProcessSpec2));
                    this.verifyFutureCompleted((CompletableFuture)this.addContainerRequestFutures.get(0));
                    this.verifyFutureCompleted((CompletableFuture)this.addContainerRequestFutures.get(1));
                    Container container1 = this.createTestingContainerWithResource(containerResource1);
                    this.resourceManagerClientCallbackHandler.onContainersAllocated(Collections.singletonList(container1));
                    this.verifyFutureCompleted(startContainerAsyncCommandFuture1);
                    Assert.assertFalse((boolean)startContainerAsyncCommandFuture2.isDone());
                    ContainerStatus testingContainerStatus = this.createTestingContainerCompletedStatus(container1.getId());
                    this.resourceManagerClientCallbackHandler.onContainersCompleted(Collections.singletonList(testingContainerStatus));
                    this.verifyFutureCompleted((CompletableFuture)this.addContainerRequestFutures.get(2));
                    Assert.assertThat((Object)((AMRMClient.ContainerRequest)((CompletableFuture)this.addContainerRequestFutures.get(2)).get()).getCapability(), (Matcher)Matchers.is((Object)containerResource1));
                    Assert.assertFalse((boolean)((CompletableFuture)this.addContainerRequestFutures.get(3)).isDone());
                });
            }
        };
    }

    private boolean containsStartCommand(ContainerLaunchContext containerLaunchContext, String command) {
        return containerLaunchContext.getCommands().stream().anyMatch(str -> str.contains(command));
    }

    private static Container createTestingContainerWithResource(Resource resource, Priority priority, int containerIdx) {
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1), (int)containerIdx);
        NodeId nodeId = NodeId.newInstance((String)"container", (int)1234);
        return new TestingContainer(containerId, nodeId, resource, priority);
    }

    @Test
    public void testGetContainerCompletedCauseForSuccess() {
        ContainerStatus containerStatus = this.createSuccessfulCompletedContainerStatus();
        this.testingGetContainerCompletedCause(containerStatus, String.format("Container %s exited normally.", containerStatus.getContainerId()));
    }

    private ContainerStatus createSuccessfulCompletedContainerStatus() {
        return ContainerStatusPBImpl.newInstance((ContainerId)testingContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"success exit code", (int)0);
    }

    @Test
    public void testGetContainerCompletedCauseForPreempted() {
        ContainerStatus containerStatus = this.createCompletedContainerStatusBecauseItWasPreempted();
        this.testingGetContainerCompletedCause(containerStatus, String.format("Container %s was preempted by yarn.", containerStatus.getContainerId()));
    }

    private ContainerStatus createCompletedContainerStatusBecauseItWasPreempted() {
        return ContainerStatusPBImpl.newInstance((ContainerId)testingContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"preempted exit code", (int)-102);
    }

    @Test
    public void testGetContainerCompletedCauseForInvalid() {
        ContainerStatus containerStatus = this.createCompletedContainerStatusBecauseItWasInvalid();
        this.testingGetContainerCompletedCause(containerStatus, String.format("Container %s was invalid.", containerStatus.getContainerId()));
    }

    private ContainerStatus createCompletedContainerStatusBecauseItWasInvalid() {
        return ContainerStatusPBImpl.newInstance((ContainerId)testingContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"invalid exit code", (int)-1000);
    }

    @Test
    public void testGetContainerCompletedCauseForAborted() {
        ContainerStatus containerStatus = this.createCompletedContainerStatusBecauseItWasAborted();
        this.testingGetContainerCompletedCause(containerStatus, String.format("Container %s killed by YARN, either due to being released by the application or being 'lost' due to node failures etc.", containerStatus.getContainerId()));
    }

    private ContainerStatus createCompletedContainerStatusBecauseItWasAborted() {
        return ContainerStatusPBImpl.newInstance((ContainerId)testingContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"aborted exit code", (int)-100);
    }

    @Test
    public void testGetContainerCompletedCauseForDiskFailed() {
        ContainerStatus containerStatus = this.createCompletedContainerStatusBecauseDisksFailed();
        this.testingGetContainerCompletedCause(containerStatus, String.format("Container %s is failed because threshold number of the nodemanager-local-directories or threshold number of the nodemanager-log-directories have become bad.", containerStatus.getContainerId()));
    }

    private ContainerStatus createCompletedContainerStatusBecauseDisksFailed() {
        return ContainerStatusPBImpl.newInstance((ContainerId)testingContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"disk failed exit code", (int)-101);
    }

    @Test
    public void testGetContainerCompletedCauseForUnknown() {
        ContainerStatus containerStatus = this.createCompletedContainerStatusForUnknownCause();
        this.testingGetContainerCompletedCause(containerStatus, String.format("Container %s marked as failed.\n Exit code:%s.", containerStatus.getContainerId(), containerStatus.getExitStatus()));
    }

    private ContainerStatus createCompletedContainerStatusForUnknownCause() {
        return ContainerStatusPBImpl.newInstance((ContainerId)testingContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"unknown exit code", (int)-1);
    }

    public void testingGetContainerCompletedCause(ContainerStatus containerStatus, String expectedCompletedCause) {
        String containerCompletedCause = YarnResourceManagerDriver.getContainerCompletedCause((ContainerStatus)containerStatus);
        Assert.assertThat((Object)containerCompletedCause, (Matcher)Matchers.containsString((String)expectedCompletedCause));
        Assert.assertThat((Object)containerCompletedCause, (Matcher)Matchers.containsString((String)containerStatus.getDiagnostics()));
    }

    private class Context
    extends ResourceManagerDriverTestBase.Context {
        private final CompletableFuture<Void> stopAndCleanupClusterFuture;
        private final CompletableFuture<Resource> createTaskManagerContainerFuture;
        private final CompletableFuture<Void> stopContainerAsyncFuture;
        final List<CompletableFuture<AMRMClient.ContainerRequest>> addContainerRequestFutures;
        final AtomicInteger addContainerRequestFuturesNumCompleted;
        final CompletableFuture<Void> removeContainerRequestFuture;
        final CompletableFuture<Void> releaseAssignedContainerFuture;
        final CompletableFuture<Void> startContainerAsyncFuture;
        final CompletableFuture<Void> resourceManagerClientInitFuture;
        final CompletableFuture<Void> resourceManagerClientStartFuture;
        final CompletableFuture<Void> resourceManagerClientStopFuture;
        final CompletableFuture<Void> nodeManagerClientInitFuture;
        final CompletableFuture<Void> nodeManagerClientStartFuture;
        final CompletableFuture<Void> nodeManagerClientStopFuture;
        AMRMClientAsync.CallbackHandler resourceManagerClientCallbackHandler;
        NMClientAsync.CallbackHandler nodeManagerClientCallbackHandler;
        TestingYarnNMClientAsync testingYarnNMClientAsync;
        TestingYarnAMRMClientAsync testingYarnAMRMClientAsync;
        final TestingYarnNMClientAsync.Builder testingYarnNMClientAsyncBuilder;
        final TestingYarnAMRMClientAsync.Builder testingYarnAMRMClientAsyncBuilder;
        final TestingYarnResourceManagerClientFactory testingYarnResourceManagerClientFactory;
        final TestingYarnNodeManagerClientFactory testingYarnNodeManagerClientFactory;
        final Map<String, String> env;
        private int containerIdx;

        private Context() {
            super((ResourceManagerDriverTestBase)YarnResourceManagerDriverTest.this);
            this.stopAndCleanupClusterFuture = new CompletableFuture();
            this.createTaskManagerContainerFuture = new CompletableFuture();
            this.stopContainerAsyncFuture = new CompletableFuture();
            this.addContainerRequestFutures = new ArrayList<CompletableFuture<AMRMClient.ContainerRequest>>();
            this.addContainerRequestFuturesNumCompleted = new AtomicInteger(0);
            this.removeContainerRequestFuture = new CompletableFuture();
            this.releaseAssignedContainerFuture = new CompletableFuture();
            this.startContainerAsyncFuture = new CompletableFuture();
            this.resourceManagerClientInitFuture = new CompletableFuture();
            this.resourceManagerClientStartFuture = new CompletableFuture();
            this.resourceManagerClientStopFuture = new CompletableFuture();
            this.nodeManagerClientInitFuture = new CompletableFuture();
            this.nodeManagerClientStartFuture = new CompletableFuture();
            this.nodeManagerClientStopFuture = new CompletableFuture();
            this.testingYarnNMClientAsyncBuilder = TestingYarnNMClientAsync.builder().setStartContainerAsyncConsumer((TriConsumer<Container, ContainerLaunchContext, NMClientAsync.CallbackHandler>)((TriConsumer)(ignored1, ignored2, ignored3) -> this.startContainerAsyncFuture.complete(null))).setStopContainerAsyncConsumer((TriConsumer<ContainerId, NodeId, NMClientAsync.CallbackHandler>)((TriConsumer)(ignored1, ignored2, ignored3) -> this.stopContainerAsyncFuture.complete(null))).setClientInitRunnable(() -> this.nodeManagerClientInitFuture.complete(null)).setClientStartRunnable(() -> this.nodeManagerClientStartFuture.complete(null)).setClientStopRunnable(() -> this.nodeManagerClientStopFuture.complete(null));
            this.testingYarnAMRMClientAsyncBuilder = TestingYarnAMRMClientAsync.builder().setAddContainerRequestConsumer((request, handler) -> {
                this.createTaskManagerContainerFuture.complete(request.getCapability());
                this.resourceManagerClientCallbackHandler.onContainersAllocated(Collections.singletonList(testingContainer));
            }).setGetMatchingRequestsFunction(ignored -> Collections.singletonList(Collections.singletonList(YarnResourceManagerDriver.getContainerRequest((Resource)testingResource, (Priority)Priority.UNDEFINED)))).setRemoveContainerRequestConsumer((request, handler) -> this.removeContainerRequestFuture.complete(null)).setReleaseAssignedContainerConsumer((ignored1, ignored2) -> this.releaseAssignedContainerFuture.complete(null)).setUnregisterApplicationMasterConsumer((TriConsumer<FinalApplicationStatus, String, String>)((TriConsumer)(ignore1, ignore2, ignore3) -> this.stopAndCleanupClusterFuture.complete(null))).setClientInitRunnable(() -> this.resourceManagerClientInitFuture.complete(null)).setClientStartRunnable(() -> this.resourceManagerClientStartFuture.complete(null)).setClientStopRunnable(() -> this.resourceManagerClientStopFuture.complete(null));
            this.testingYarnResourceManagerClientFactory = new TestingYarnResourceManagerClientFactory((integer, handler) -> {
                this.resourceManagerClientCallbackHandler = handler;
                this.testingYarnAMRMClientAsync = this.testingYarnAMRMClientAsyncBuilder.build((AMRMClientAsync.CallbackHandler)handler);
                return this.testingYarnAMRMClientAsync;
            });
            this.testingYarnNodeManagerClientFactory = new TestingYarnNodeManagerClientFactory(handler -> {
                this.nodeManagerClientCallbackHandler = handler;
                this.testingYarnNMClientAsync = this.testingYarnNMClientAsyncBuilder.build((NMClientAsync.CallbackHandler)handler);
                return this.testingYarnNMClientAsync;
            });
            this.env = new HashMap<String, String>();
            this.containerIdx = 0;
        }

        protected void prepareRunTest() throws Exception {
            File root = YarnResourceManagerDriverTest.this.folder.getRoot();
            File home = new File(root, "home");
            boolean created = home.mkdir();
            Assert.assertTrue((boolean)created);
            this.env.put("_APP_ID", "foo");
            this.env.put("_CLIENT_HOME_DIR", home.getAbsolutePath());
            this.env.put("_CLIENT_SHIP_FILES", "");
            this.env.put("_FLINK_CLASSPATH", "");
            this.env.put("HADOOP_USER_NAME", "foo");
            this.env.putIfAbsent("_FLINK_YARN_FILES", "");
            this.env.put("_FLINK_DIST_JAR", new YarnLocalResourceDescriptor("flink.jar", new Path("/tmp/flink.jar"), 0L, System.currentTimeMillis(), LocalResourceVisibility.APPLICATION, LocalResourceType.FILE).toString());
            this.env.put(ApplicationConstants.Environment.PWD.key(), home.getAbsolutePath());
            BootstrapTools.writeConfiguration((Configuration)this.flinkConfig, (File)new File(home.getAbsolutePath(), "flink-conf.yaml"));
        }

        protected void preparePreviousAttemptWorkers() {
            this.testingYarnAMRMClientAsyncBuilder.setRegisterApplicationMasterFunction((TriFunction<String, Integer, String, RegisterApplicationMasterResponse>)((TriFunction)(ignored1, ignored2, ignored3) -> new TestingRegisterApplicationMasterResponse(() -> Collections.singletonList(testingContainer))));
        }

        protected ResourceManagerDriver<YarnWorkerNode> createResourceManagerDriver() {
            return new YarnResourceManagerDriver(this.flinkConfig, new YarnResourceManagerDriverConfiguration(this.env, "localhost:9000", null), (YarnResourceManagerClientFactory)this.testingYarnResourceManagerClientFactory, (YarnNodeManagerClientFactory)this.testingYarnNodeManagerClientFactory);
        }

        protected void validateInitialization() throws Exception {
            Assert.assertNotNull((Object)((Object)this.testingYarnAMRMClientAsync));
            Assert.assertNotNull((Object)((Object)this.testingYarnNMClientAsync));
            this.verifyFutureCompleted(this.nodeManagerClientInitFuture);
            this.verifyFutureCompleted(this.nodeManagerClientStartFuture);
            this.verifyFutureCompleted(this.resourceManagerClientInitFuture);
            this.verifyFutureCompleted(this.resourceManagerClientStartFuture);
        }

        protected void validateWorkersRecoveredFromPreviousAttempt(Collection<YarnWorkerNode> workers) {
            Assume.assumeTrue((boolean)HadoopUtils.isMinHadoopVersion((int)2, (int)2));
            Assert.assertThat((Object)workers.size(), (Matcher)Matchers.is((Object)1));
            ResourceID resourceId = workers.iterator().next().getResourceID();
            Assert.assertThat((Object)resourceId.toString(), (Matcher)Matchers.is((Object)testingContainer.getId().toString()));
        }

        protected void validateTermination() throws Exception {
            this.verifyFutureCompleted(this.nodeManagerClientStopFuture);
            this.verifyFutureCompleted(this.resourceManagerClientStopFuture);
        }

        protected void validateDeregisterApplication() throws Exception {
            this.verifyFutureCompleted(this.stopAndCleanupClusterFuture);
        }

        protected void validateRequestedResources(Collection<TaskExecutorProcessSpec> taskExecutorProcessSpecs) throws Exception {
            Assert.assertThat((Object)taskExecutorProcessSpecs.size(), (Matcher)Matchers.is((Object)1));
            TaskExecutorProcessSpec taskExecutorProcessSpec = taskExecutorProcessSpecs.iterator().next();
            Resource resource = this.createTaskManagerContainerFuture.get(5L, TimeUnit.SECONDS);
            Assert.assertThat((Object)resource.getMemory(), (Matcher)Matchers.is((Object)taskExecutorProcessSpec.getTotalProcessMemorySize().getMebiBytes()));
            Assert.assertThat((Object)resource.getVirtualCores(), (Matcher)Matchers.is((Object)taskExecutorProcessSpec.getCpuCores().getValue().intValue()));
            this.verifyFutureCompleted(this.removeContainerRequestFuture);
        }

        protected void validateReleaseResources(Collection<YarnWorkerNode> workerNodes) throws Exception {
            Assert.assertThat((Object)workerNodes.size(), (Matcher)Matchers.is((Object)1));
            this.verifyFutureCompleted(this.stopContainerAsyncFuture);
            this.verifyFutureCompleted(this.releaseAssignedContainerFuture);
        }

        ContainerStatus createTestingContainerCompletedStatus(ContainerId containerId) {
            return new TestingContainerStatus(containerId, ContainerState.COMPLETE, "Test exit", -1);
        }

        Container createTestingContainerWithResource(Resource resource) {
            return YarnResourceManagerDriverTest.createTestingContainerWithResource(resource, testingPriority, this.containerIdx++);
        }

        <T> void verifyFutureCompleted(CompletableFuture<T> future) throws Exception {
            future.get(5L, TimeUnit.SECONDS);
        }

        void prepareForTestStartTaskExecutorProcessVariousSpec(String startCommand1, String startCommand2, CompletableFuture<Void> startContainerAsyncCommandFuture1, CompletableFuture<Void> startContainerAsyncCommandFuture2, TaskExecutorProcessSpec taskExecutorProcessSpec) {
            this.addContainerRequestFutures.add(new CompletableFuture());
            this.addContainerRequestFutures.add(new CompletableFuture());
            this.addContainerRequestFutures.add(new CompletableFuture());
            this.addContainerRequestFutures.add(new CompletableFuture());
            this.testingYarnAMRMClientAsyncBuilder.setAddContainerRequestConsumer((request, ignored) -> this.addContainerRequestFutures.get(this.addContainerRequestFuturesNumCompleted.getAndIncrement()).complete((AMRMClient.ContainerRequest)request));
            this.testingYarnNMClientAsyncBuilder.setStartContainerAsyncConsumer((TriConsumer<Container, ContainerLaunchContext, NMClientAsync.CallbackHandler>)((TriConsumer)(ignored1, context, ignored3) -> {
                if (YarnResourceManagerDriverTest.this.containsStartCommand(context, startCommand1)) {
                    startContainerAsyncCommandFuture1.complete(null);
                } else if (YarnResourceManagerDriverTest.this.containsStartCommand(context, startCommand2)) {
                    startContainerAsyncCommandFuture2.complete(null);
                }
            }));
            this.resourceEventHandlerBuilder.setOnWorkerTerminatedConsumer((ignore1, ignore2) -> this.getDriver().requestResource(taskExecutorProcessSpec));
        }
    }
}

