/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.modules.HadoopModule;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.YarnTaskExecutorRunner;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class YarnTaskExecutorRunnerTest
extends TestLogger {
    @Test
    public void testDefaultKerberosKeytabConfiguration() throws Exception {
        String resourceDirPath = Paths.get("src", "test", "resources").toAbsolutePath().toString();
        HashMap<String, Object> envs = new HashMap<String, Object>(2);
        envs.put("_KEYTAB_PRINCIPAL", "testuser1@domain");
        envs.put("_REMOTE_KEYTAB_PATH", resourceDirPath);
        envs.put("_LOCAL_KEYTAB_PATH", YarnConfigOptions.LOCALIZED_KEYTAB_PATH.defaultValue());
        Configuration configuration = new Configuration();
        YarnTaskExecutorRunner.setupAndModifyConfiguration((Configuration)configuration, (String)resourceDirPath, envs);
        SecurityUtils.install((SecurityConfiguration)new SecurityConfiguration(configuration));
        List modules = SecurityUtils.getInstalledModules();
        Optional<SecurityModule> moduleOpt = modules.stream().filter(module -> module instanceof HadoopModule).findFirst();
        if (moduleOpt.isPresent()) {
            HadoopModule hadoopModule = (HadoopModule)moduleOpt.get();
            Assert.assertThat((Object)hadoopModule.getSecurityConfig().getPrincipal(), (Matcher)Matchers.is((Object)"testuser1@domain"));
            Assert.assertThat((Object)hadoopModule.getSecurityConfig().getKeytab(), (Matcher)Matchers.is((Object)new File(resourceDirPath, (String)YarnConfigOptions.LOCALIZED_KEYTAB_PATH.defaultValue()).getAbsolutePath()));
        } else {
            Assert.fail((String)"Can not find HadoopModule!");
        }
        Assert.assertThat((Object)configuration.getString(SecurityOptions.KERBEROS_LOGIN_KEYTAB), (Matcher)Matchers.is((Object)new File(resourceDirPath, (String)YarnConfigOptions.LOCALIZED_KEYTAB_PATH.defaultValue()).getAbsolutePath()));
        Assert.assertThat((Object)configuration.getString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL), (Matcher)Matchers.is((Object)"testuser1@domain"));
    }

    @Test
    public void testPreInstallKerberosKeytabConfiguration() throws Exception {
        String resourceDirPath = Paths.get("src", "test", "resources").toAbsolutePath().toString();
        HashMap<String, String> envs = new HashMap<String, String>(2);
        envs.put("_KEYTAB_PRINCIPAL", "testuser1@domain");
        envs.put("_LOCAL_KEYTAB_PATH", "src/test/resources/krb5.keytab");
        Configuration configuration = new Configuration();
        YarnTaskExecutorRunner.setupAndModifyConfiguration((Configuration)configuration, (String)resourceDirPath, envs);
        SecurityUtils.install((SecurityConfiguration)new SecurityConfiguration(configuration));
        List modules = SecurityUtils.getInstalledModules();
        Optional<SecurityModule> moduleOpt = modules.stream().filter(module -> module instanceof HadoopModule).findFirst();
        if (moduleOpt.isPresent()) {
            HadoopModule hadoopModule = (HadoopModule)moduleOpt.get();
            Assert.assertThat((Object)hadoopModule.getSecurityConfig().getPrincipal(), (Matcher)Matchers.is((Object)"testuser1@domain"));
            Assert.assertThat((Object)hadoopModule.getSecurityConfig().getKeytab(), (Matcher)Matchers.containsString((String)"src/test/resources/krb5.keytab"));
        } else {
            Assert.fail((String)"Can not find HadoopModule!");
        }
        Assert.assertThat((Object)configuration.getString(SecurityOptions.KERBEROS_LOGIN_KEYTAB), (Matcher)Matchers.containsString((String)"src/test/resources/krb5.keytab"));
        Assert.assertThat((Object)configuration.getString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL), (Matcher)Matchers.is((Object)"testuser1@domain"));
    }
}

