/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.yarn.YarnClientYarnClusterInformationRetriever;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.flink.yarn.YarnClusterInformationRetriever;
import org.apache.flink.yarn.configuration.YarnLogConfigUtil;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class YarnTestUtils {
    static boolean isHadoopVersionGreaterThanOrEquals(int major, int minor) {
        String[] splitVersion = VersionInfo.getVersion().split("\\.");
        int[] versions = Arrays.stream(splitVersion).mapToInt(Integer::parseInt).toArray();
        return versions[0] >= major && versions[1] >= minor;
    }

    private YarnTestUtils() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }

    public static YarnClusterDescriptor createClusterDescriptorWithLogging(String flinkConfDir, Configuration flinkConfiguration, YarnConfiguration yarnConfiguration, YarnClient yarnClient, boolean sharedYarnClient) {
        Configuration effectiveConfiguration = YarnTestUtils.configureLogFile(flinkConfiguration, flinkConfDir);
        return new YarnClusterDescriptor(effectiveConfiguration, yarnConfiguration, yarnClient, (YarnClusterInformationRetriever)YarnClientYarnClusterInformationRetriever.create((YarnClient)yarnClient), sharedYarnClient);
    }

    public static Configuration configureLogFile(Configuration flinkConfiguration, String flinkConfDir) {
        return YarnLogConfigUtil.setLogConfigFileInConfig((Configuration)flinkConfiguration, (String)flinkConfDir);
    }

    public static void generateFilesInDirectory(File directory, Map<String, String> srcFiles) throws IOException {
        for (Map.Entry<String, String> src : srcFiles.entrySet()) {
            File file = new File(directory, src.getKey());
            file.getParentFile().mkdirs();
            DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
            Throwable throwable = null;
            try {
                out.writeUTF(src.getValue());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }
}

