/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.entrypoint.YarnEntrypointUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class YarnEntrypointUtilsTest
extends TestLogger {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @Test
    public void testRestPortOptionsUnspecified() throws IOException {
        Configuration initialConfiguration = new Configuration();
        Configuration configuration = YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration);
        Assert.assertThat((Object)configuration.getString(RestOptions.BIND_PORT), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"0")));
    }

    @Test
    public void testRestPortSpecified() throws IOException {
        Configuration initialConfiguration = new Configuration();
        int port = 1337;
        initialConfiguration.setInteger(RestOptions.PORT, 1337);
        Configuration configuration = YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration);
        Assert.assertThat((Object)configuration.getString(RestOptions.BIND_PORT), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)String.valueOf(1337))));
    }

    @Test
    public void testRestPortAndBindingPortSpecified() throws IOException {
        Configuration initialConfiguration = new Configuration();
        int port = 1337;
        String bindingPortRange = "1337-7331";
        initialConfiguration.setInteger(RestOptions.PORT, 1337);
        initialConfiguration.setString(RestOptions.BIND_PORT, "1337-7331");
        Configuration configuration = YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration);
        Assert.assertThat((Object)configuration.getString(RestOptions.BIND_PORT), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"1337-7331")));
    }

    @Test
    public void testParsingValidKerberosEnv() throws IOException {
        Configuration initialConfiguration = new Configuration();
        HashMap<String, String> env = new HashMap<String, String>();
        File keytabFile = TEMPORARY_FOLDER.newFile();
        env.put("_LOCAL_KEYTAB_PATH", keytabFile.getAbsolutePath());
        env.put("_KEYTAB_PRINCIPAL", "starlord");
        Configuration configuration = YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration, env);
        Assert.assertThat((Object)configuration.get(SecurityOptions.KERBEROS_LOGIN_KEYTAB), (Matcher)Matchers.is((Object)keytabFile.getAbsolutePath()));
        Assert.assertThat((Object)configuration.get(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL), (Matcher)Matchers.is((Object)"starlord"));
    }

    @Test
    public void testParsingKerberosEnvWithMissingKeytab() throws IOException {
        Configuration initialConfiguration = new Configuration();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("_LOCAL_KEYTAB_PATH", "/hopefully/doesnt/exist");
        env.put("_KEYTAB_PRINCIPAL", "starlord");
        Configuration configuration = YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration, env);
        Assert.assertThat((Object)configuration.get(SecurityOptions.KERBEROS_LOGIN_KEYTAB), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)configuration.get(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDynamicParameterOverloading() throws IOException {
        Configuration initialConfiguration = new Configuration();
        initialConfiguration.set(JobManagerOptions.JVM_METASPACE, (Object)MemorySize.ofMebiBytes((long)1L));
        Configuration dynamicParameters = new Configuration();
        dynamicParameters.set(JobManagerOptions.JVM_METASPACE, (Object)MemorySize.MAX_VALUE);
        Configuration overloadedConfiguration = YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration, dynamicParameters);
        Assert.assertThat((Object)overloadedConfiguration.get(JobManagerOptions.JVM_METASPACE), (Matcher)Matchers.is((Object)MemorySize.MAX_VALUE));
    }

    @Nonnull
    private static Configuration loadConfiguration(Configuration initialConfiguration) throws IOException {
        return YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration, new HashMap<String, String>());
    }

    @Nonnull
    private static Configuration loadConfiguration(Configuration initialConfiguration, Configuration dynamicParameters) throws IOException {
        return YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration, dynamicParameters, new HashMap<String, String>());
    }

    @Nonnull
    private static Configuration loadConfiguration(Configuration initialConfiguration, Map<String, String> env) throws IOException {
        return YarnEntrypointUtilsTest.loadConfiguration(initialConfiguration, new Configuration(), env);
    }

    @Nonnull
    private static Configuration loadConfiguration(Configuration initialConfiguration, Configuration dynamicParameters, Map<String, String> env) throws IOException {
        File workingDirectory = TEMPORARY_FOLDER.newFolder();
        env.put(ApplicationConstants.Environment.NM_HOST.key(), "foobar");
        BootstrapTools.writeConfiguration((Configuration)initialConfiguration, (File)new File(workingDirectory, "flink-conf.yaml"));
        return YarnEntrypointUtils.loadConfiguration((String)workingDirectory.getAbsolutePath(), (Configuration)dynamicParameters, env);
    }
}

