/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.entrypoint.YarnWorkerResourceSpecFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class YarnWorkerResourceSpecFactoryTest
extends TestLogger {
    @Test
    public void testGetCpuCoresCommonOption() {
        Configuration configuration = new Configuration();
        configuration.setDouble(TaskManagerOptions.CPU_CORES, 1.0);
        configuration.setInteger(YarnConfigOptions.VCORES, 2);
        configuration.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, 3);
        Assert.assertThat((Object)YarnWorkerResourceSpecFactory.getDefaultCpus((Configuration)configuration), (Matcher)Matchers.is((Object)new CPUResource(1.0)));
    }

    @Test
    public void testGetCpuCoresYarnOption() {
        Configuration configuration = new Configuration();
        configuration.setInteger(YarnConfigOptions.VCORES, 2);
        configuration.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, 3);
        Assert.assertThat((Object)YarnWorkerResourceSpecFactory.getDefaultCpus((Configuration)configuration), (Matcher)Matchers.is((Object)new CPUResource(2.0)));
    }

    @Test
    public void testGetCpuCoresNumSlots() {
        Configuration configuration = new Configuration();
        configuration.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, 3);
        Assert.assertThat((Object)YarnWorkerResourceSpecFactory.getDefaultCpus((Configuration)configuration), (Matcher)Matchers.is((Object)new CPUResource(3.0)));
    }

    @Test
    public void testGetCpuRoundUp() {
        Configuration configuration = new Configuration();
        configuration.setDouble(TaskManagerOptions.CPU_CORES, 0.5);
        Assert.assertThat((Object)YarnWorkerResourceSpecFactory.getDefaultCpus((Configuration)configuration), (Matcher)Matchers.is((Object)new CPUResource(1.0)));
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testGetCpuExceedMaxInt() {
        Configuration configuration = new Configuration();
        configuration.setDouble(TaskManagerOptions.CPU_CORES, Double.MAX_VALUE);
        YarnWorkerResourceSpecFactory.getDefaultCpus((Configuration)configuration);
    }
}

