/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.RegisterApplicationMasterResponseReflector;
import org.apache.flink.yarn.YarnTestUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.api.records.Container;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterApplicationMasterResponseReflectorTest
extends TestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterApplicationMasterResponseReflectorTest.class);
    @Mock
    private Container mockContainer;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCallsGetContainersFromPreviousAttemptsMethodIfPresent() {
        RegisterApplicationMasterResponseReflector registerApplicationMasterResponseReflector = new RegisterApplicationMasterResponseReflector(LOG, HasMethod.class);
        List containersFromPreviousAttemptsUnsafe = registerApplicationMasterResponseReflector.getContainersFromPreviousAttemptsUnsafe((Object)new HasMethod());
        Assert.assertThat((Object)containersFromPreviousAttemptsUnsafe, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testDoesntCallGetContainersFromPreviousAttemptsMethodIfAbsent() {
        RegisterApplicationMasterResponseReflector registerApplicationMasterResponseReflector = new RegisterApplicationMasterResponseReflector(LOG, HasMethod.class);
        List containersFromPreviousAttemptsUnsafe = registerApplicationMasterResponseReflector.getContainersFromPreviousAttemptsUnsafe(new Object());
        Assert.assertThat((Object)containersFromPreviousAttemptsUnsafe, (Matcher)Matchers.empty());
    }

    @Test
    public void testGetContainersFromPreviousAttemptsMethodReflectiveHadoop22() {
        Assume.assumeTrue((String)("Method getContainersFromPreviousAttempts is not supported by Hadoop: " + VersionInfo.getVersion()), (boolean)YarnTestUtils.isHadoopVersionGreaterThanOrEquals(2, 2));
        RegisterApplicationMasterResponseReflector registerApplicationMasterResponseReflector = new RegisterApplicationMasterResponseReflector(LOG);
        Assert.assertTrue((boolean)registerApplicationMasterResponseReflector.getGetContainersFromPreviousAttemptsMethod().isPresent());
    }

    @Test
    public void testCallsGetSchedulerResourceTypesMethodIfPresent() {
        RegisterApplicationMasterResponseReflector registerApplicationMasterResponseReflector = new RegisterApplicationMasterResponseReflector(LOG, HasMethod.class);
        Optional schedulerResourceTypeNames = registerApplicationMasterResponseReflector.getSchedulerResourceTypeNamesUnsafe((Object)new HasMethod());
        Assert.assertTrue((boolean)schedulerResourceTypeNames.isPresent());
        Assert.assertThat(schedulerResourceTypeNames.get(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"MEMORY", "CPU"}));
    }

    @Test
    public void testDoesntCallGetSchedulerResourceTypesMethodIfAbsent() {
        RegisterApplicationMasterResponseReflector registerApplicationMasterResponseReflector = new RegisterApplicationMasterResponseReflector(LOG, HasMethod.class);
        Optional schedulerResourceTypeNames = registerApplicationMasterResponseReflector.getSchedulerResourceTypeNamesUnsafe(new Object());
        Assert.assertFalse((boolean)schedulerResourceTypeNames.isPresent());
    }

    @Test
    public void testGetSchedulerResourceTypesMethodReflectiveHadoop26() {
        Assume.assumeTrue((String)("Method getSchedulerResourceTypes is not supported by Hadoop: " + VersionInfo.getVersion()), (boolean)YarnTestUtils.isHadoopVersionGreaterThanOrEquals(2, 6));
        RegisterApplicationMasterResponseReflector registerApplicationMasterResponseReflector = new RegisterApplicationMasterResponseReflector(LOG);
        Assert.assertTrue((boolean)registerApplicationMasterResponseReflector.getGetSchedulerResourceTypesMethod().isPresent());
    }

    private static enum MockSchedulerResourceTypes {
        MEMORY,
        CPU;

    }

    private class HasMethod {
        private HasMethod() {
        }

        public List<Container> getContainersFromPreviousAttempts() {
            return Collections.singletonList(RegisterApplicationMasterResponseReflectorTest.this.mockContainer);
        }

        public EnumSet<MockSchedulerResourceTypes> getSchedulerResourceTypes() {
            return EnumSet.allOf(MockSchedulerResourceTypes.class);
        }
    }
}

