/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.Utils;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UtilsTest
extends TestLogger {
    private static final String YARN_RM_ARBITRARY_SCHEDULER_CLAZZ = "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testDeleteApplicationFiles() throws Exception {
        java.nio.file.Path applicationFilesDir = this.temporaryFolder.newFolder(".flink").toPath();
        Files.createFile(applicationFilesDir.resolve("flink.jar"), new FileAttribute[0]);
        try (Stream<java.nio.file.Path> files = Files.list(this.temporaryFolder.getRoot().toPath());){
            Assert.assertThat((Object)files.count(), (Matcher)Matchers.equalTo((Object)1L));
        }
        files = Files.list(applicationFilesDir);
        var3_3 = null;
        try {
            Assert.assertThat((Object)files.count(), (Matcher)Matchers.equalTo((Object)1L));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (files != null) {
                if (var3_3 != null) {
                    try {
                        files.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    files.close();
                }
            }
        }
        Utils.deleteApplicationFiles((String)applicationFilesDir.toString());
        files = Files.list(this.temporaryFolder.getRoot().toPath());
        var3_3 = null;
        try {
            Assert.assertThat((Object)files.count(), (Matcher)Matchers.equalTo((Object)0L));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (files != null) {
                if (var3_3 != null) {
                    try {
                        files.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    files.close();
                }
            }
        }
    }

    @Test
    public void testGetUnitResource() {
        int minMem = 64;
        boolean minVcore = true;
        int incMem = 512;
        int incVcore = 2;
        int incMemLegacy = 1024;
        int incVcoreLegacy = 4;
        YarnConfiguration yarnConfig = new YarnConfiguration();
        yarnConfig.setInt("yarn.scheduler.minimum-allocation-mb", 64);
        yarnConfig.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
        yarnConfig.setInt("yarn.scheduler.increment-allocation-mb", 1024);
        yarnConfig.setInt("yarn.scheduler.increment-allocation-vcores", 4);
        UtilsTest.verifyUnitResourceVariousSchedulers(yarnConfig, 64, 1, 1024, 4);
        yarnConfig.setInt("yarn.resource-types.memory-mb.increment-allocation", 512);
        yarnConfig.setInt("yarn.resource-types.vcores.increment-allocation", 2);
        UtilsTest.verifyUnitResourceVariousSchedulers(yarnConfig, 64, 1, 512, 2);
    }

    @Test
    public void testSharedLibWithNonQualifiedPath() throws Exception {
        String sharedLibPath = "/flink/sharedLib";
        String nonQualifiedPath = "hdfs:///flink/sharedLib";
        String defaultFs = "hdfs://localhost:9000";
        String qualifiedPath = "hdfs://localhost:9000/flink/sharedLib";
        Configuration flinkConfig = new Configuration();
        flinkConfig.set(YarnConfigOptions.PROVIDED_LIB_DIRS, Collections.singletonList("hdfs:///flink/sharedLib"));
        YarnConfiguration yarnConfig = new YarnConfiguration();
        yarnConfig.set("fs.defaultFS", "hdfs://localhost:9000");
        List sharedLibs = Utils.getQualifiedRemoteSharedPaths((Configuration)flinkConfig, (YarnConfiguration)yarnConfig);
        Assert.assertThat((Object)sharedLibs.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Path)sharedLibs.get(0)).toUri().toString(), (Matcher)Matchers.is((Object)"hdfs://localhost:9000/flink/sharedLib"));
    }

    @Test
    public void testSharedLibIsNotRemotePathShouldThrowException() throws IOException {
        String localLib = "file:///flink/sharedLib";
        Configuration flinkConfig = new Configuration();
        flinkConfig.set(YarnConfigOptions.PROVIDED_LIB_DIRS, Collections.singletonList("file:///flink/sharedLib"));
        try {
            Utils.getQualifiedRemoteSharedPaths((Configuration)flinkConfig, (YarnConfiguration)new YarnConfiguration());
            Assert.fail((String)"We should throw an exception when the shared lib is set to local path.");
        }
        catch (FlinkException ex) {
            String msg = "The \"" + YarnConfigOptions.PROVIDED_LIB_DIRS.key() + "\" should only contain dirs accessible from all worker nodes";
            Assert.assertThat((Object)((Object)ex), (Matcher)FlinkMatchers.containsMessage((String)msg));
        }
    }

    @Test
    public void testGetYarnConfiguration() {
        String flinkPrefix = "flink.yarn.";
        String yarnPrefix = "yarn.";
        String k1 = "brooklyn";
        String v1 = "nets";
        String k2 = "golden.state";
        String v2 = "warriors";
        String k3 = "miami";
        String v3 = "heat";
        Configuration flinkConfig = new Configuration();
        flinkConfig.setString("flink.yarn.brooklyn", "nets");
        flinkConfig.setString("flink.yarn.golden.state", "warriors");
        flinkConfig.setString("miami", "heat");
        YarnConfiguration yarnConfig = Utils.getYarnConfiguration((Configuration)flinkConfig);
        Assert.assertEquals((Object)"nets", (Object)yarnConfig.get("yarn.brooklyn", null));
        Assert.assertEquals((Object)"warriors", (Object)yarnConfig.get("yarn.golden.state", null));
        Assert.assertTrue((yarnConfig.get("yarn.miami") == null ? 1 : 0) != 0);
    }

    private static void verifyUnitResourceVariousSchedulers(YarnConfiguration yarnConfig, int minMem, int minVcore, int incMem, int incVcore) {
        yarnConfig.set("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler");
        UtilsTest.verifyUnitResource(yarnConfig, incMem, incVcore);
        yarnConfig.set("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.sls.scheduler.SLSFairScheduler");
        UtilsTest.verifyUnitResource(yarnConfig, incMem, incVcore);
        yarnConfig.set("yarn.resourcemanager.scheduler.class", YARN_RM_ARBITRARY_SCHEDULER_CLAZZ);
        UtilsTest.verifyUnitResource(yarnConfig, minMem, minVcore);
    }

    private static void verifyUnitResource(YarnConfiguration yarnConfig, int expectedMem, int expectedVcore) {
        Resource unitResource = Utils.getUnitResource((YarnConfiguration)yarnConfig);
        Assert.assertThat((Object)unitResource.getMemory(), (Matcher)Matchers.is((Object)expectedMem));
        Assert.assertThat((Object)unitResource.getVirtualCores(), (Matcher)Matchers.is((Object)expectedVcore));
    }
}

